<?php
session_start();
include '../db.php';

// Cek apakah user sudah login dan memiliki peran yang benar
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'user') {
    header('Location: login.php');
    exit;
}

// Ambil ID reservasi dari URL
if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo "ID reservasi tidak ditemukan.";
    exit;
}

$id = intval($_GET['id']);

// Ambil detail reservasi berdasarkan ID
$query = "SELECT * FROM reservations WHERE id = $id";
$result = $conn->query($query);

if ($result->num_rows == 0) {
    echo "Reservasi tidak ditemukan.";
    exit;
}

$reservation = $result->fetch_assoc();

$statusColor = match (strtolower($reservation['status'])) {
    'disetujui' => 'success',
    'ditolak'   => 'danger',
    default     => 'warning'
  };
?>

<!DOCTYPE html>
<html lang="id">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Detail Reservasi</title>
  <!-- Bootstrap & Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet" />
  <!-- Font -->
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet" />
  <link rel="icon" href="../assets/img/logotng.png" type="image/x-icon" />
  <style>
    :root {
      --primary: #002147;
      --primary-dark: #001634;
      --accent: #f0ad4e;
    }

    body {
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(135deg, #eef2ff 0%, #e0e7ff 100%);
      min-height: 100vh;
      display: flex;
      align-items: center;
      justify-content: center;
      padding: 2rem;
    }

    .card-detail {
      border: none;
      border-radius: 1rem;
      overflow: hidden;
      box-shadow: 0 12px 35px rgba(0, 0, 0, 0.07);
      animation: slideUp .5s ease-out;
    }

    @keyframes slideUp {
      0% {
        transform: translateY(30px);
        opacity: 0;
      }
      100% {
        transform: translateY(0);
        opacity: 1;
      }
    }

    .card-detail .card-header {
      background: linear-gradient(135deg, var(--primary), var(--primary-dark));
      color: #fff;
      padding: 1rem 1.5rem;
      display: flex;
      align-items: center;
      gap: 0.6rem;
    }

    .list-group-item {
      border: 0;
      padding-left: 0;
      padding-right: 0;
      display: flex;
      align-items: flex-start;
      gap: 0.75rem;
      font-size: 0.95rem;
    }

    .list-group-item i {
      width: 24px;
      text-align: center;
      color: var(--primary);
    }

    .list-group-item strong {
      min-width: 135px;
      font-weight: 600;
      color: #000;
    }

    .btn-accent {
      background-color: var(--accent);
      border: none;
      color: #fff;
    }

    .btn-accent:hover {
      background-color: #e79b3d;
    }
  </style>
</head>

<body>
  <div class="container" style="max-width: 640px;">
    <div class="card card-detail shadow-sm">
      <div class="card-header">
        <i class="fas fa-ticket-alt"></i>
        <h5 class="mb-0">Detail Reservasi</h5>
      </div>
      <div class="card-body py-4">
        <ul class="list-group list-group-flush">
          <li class="list-group-item"><i class="fas fa-hashtag"></i><span><strong>Kode Booking:</strong> <?= htmlspecialchars($reservation['kode_booking']); ?></span></li>
          <li class="list-group-item"><i class="fas fa-user"></i><span><strong>Nama:</strong> <?= htmlspecialchars($reservation['nama']); ?></span></li>
          <li class="list-group-item"><i class="fas fa-phone-alt"></i><span><strong>No Telepon:</strong> <?= htmlspecialchars($reservation['no_telepon']); ?></span></li>
          <li class="list-group-item"><i class="fas fa-envelope"></i><span><strong>Email:</strong> <?= htmlspecialchars($reservation['surat']); ?></span></li>
          <li class="list-group-item"><i class="fas fa-map-marker-alt"></i><span><strong>Tempat:</strong> <?= htmlspecialchars($reservation['tempat']); ?></span></li>
          <li class="list-group-item"><i class="fas fa-calendar-day"></i><span><strong>Tanggal:</strong> <?= htmlspecialchars($reservation['hari']); ?></span></li>
          <li class="list-group-item"><i class="fas fa-clock"></i><span><strong>Waktu:</strong> <?= htmlspecialchars($reservation['jam_mulai'] . ' - ' . $reservation['jam_selesai']); ?></span></li>
          <li class="list-group-item"><i class="fas fa-sticky-note"></i><span><strong>Keterangan:</strong> <?= htmlspecialchars($reservation['keterangan']); ?></span></li>
          <li class="list-group-item"><i class="fas fa-file-alt"></i>
            <span><strong>File Upload:</strong>
              <?php if ($reservation['file_upload']): ?>
                <a href="../uploads/<?= htmlspecialchars($reservation['file_upload']); ?>" target="_blank" class="text-decoration-none"><i class="fas fa-paperclip me-1"></i> Lihat File</a>
              <?php else: ?>
                Tidak ada file.
              <?php endif; ?>
            </span>
          </li>
          <li class="list-group-item"><i class="fas fa-info-circle"></i><span><strong>Status:</strong> <span class="badge bg-<?= $statusColor ?>"><?= htmlspecialchars($reservation['status']); ?></span></span></li>
        </ul>
      </div>
      <div class="card-footer bg-transparent border-0 text-end pb-4 pe-4">
        <a href="dashboard.php" class="btn btn-accent"><i class="fas fa-arrow-left me-1"></i> Back</a>
      </div>
    </div>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
