<?php
session_start();
include '../db.php';

// Ambil data dari tabel places
$sql = "SELECT * FROM places";
$result = $conn->query($sql);
$places = $result->fetch_all(MYSQLI_ASSOC);

// Cek status login
$isLoggedIn = isset($_SESSION['user_id']);
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reservasi Tempat</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css">
    <script src="../assets/js/sweetalert.min.js"></script>
    <link crossorigin="anonymous" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" integrity="sha384-T3c6CoIi6uLrA9TneNEoa7RxnatzjcDSCmG1MXxSR1GAsXEV/Dwwykc2MPK8M2HN" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
    <link rel="icon" href="../assets/img/logotng.png" type="image/x-icon">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        body {
            background-size: cover;
            color: #fff;
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 0;
        }

        .navbar {
            background-color: rgba(255, 255, 255, 0.5);
            border-radius: 10px;
            padding: 10px 20px;
            position: absolute;
            top: 10px;
            right: 10px;
            z-index: 1000;
            box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
        }

        .navbar-nav .nav-link {
            color: black;
            font-weight: bold;
            margin-left: 15px;
            transition: color 0.3s ease;
        }

        .navbar-nav .nav-link.active {
            color: #FF6F61;
        }

        .navbar-nav .nav-link.login {
            background-color: #FF6F61;
            color: white;
            border-radius: 20px;
            padding: 5px 15px;
        }

        .navbar .navbar-brand img {
            max-height: 40px;
        }

        .navbar-toggler {
            border: none;
        }

        .content {
            margin-top: 150px;
            text-align: center;
        }

        .content h1 {
            font-size: 3em;
            font-weight: bold;
        }

        .content p {
            font-size: 1.2em;
        }

        .content .branches {
            margin-top: 20px;
            text-align: left;
            display: inline-block;
        }

        h1 {
            font-weight: bold;
            margin-top: 30px;
            color: #fff;
        }

        .card-container {
            background: url(../assets/img/middle.png);
            background-size: cover;
            border-radius: 15px;
            padding: 20px;
            margin: 40px 0;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }

        .card {
            margin-top: 20px;
            background: rgba(255, 255, 255, 0.9);
            border: none;
            border-radius: 15px;
            transition: transform 0.3s, box-shadow 0.3s;
            padding: 20px;
        }

        .card:hover {
            transform: scale(1.05);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.3);
        }

        .card-title {
            font-weight: bold;
            color: #333;
        }

        .card-text {
            color: #dcdcdc;
        }

        .card-img-top {
            height: 180px;
            object-fit: cover;
            border-bottom: 2px solid rgba(0, 0, 0, 0.1);
        }

        .btn-primary {
            background-color: #ff8c42;
            border: none;
            border-radius: 20px;
            font-weight: bold;
            padding: 10px 20px;
            transition: background 0.3s, box-shadow 0.3s;
        }

        .btn-primary:hover {
            background-color: #ffa756;
            box-shadow: 0 5px 15px rgba(255, 140, 66, 0.4);
        }

        /* Bagian untuk memungkinkan gambar latar belakang digeser di perangkat mobile */
        .contents {
            background-image: url('../assets/img/utama4.png');
            background-size: auto 100%;
            /* Menyesuaikan gambar agar lebar dan tinggi sesuai */
            background-position: left center;
            /* Memulai gambar dari kiri */
            background-repeat: no-repeat;
            width: 100vw;
            /* Lebar 100% dari layar */
            height: 100vh;
            /* Tinggi 100% dari layar */
            padding: 20px 0;
            color: white;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            box-sizing: border-box;
            overflow-x: auto;
            /* Menambahkan scroll horizontal */
            overflow-y: hidden;
            /* Menyembunyikan scroll vertikal */
            white-space: nowrap;
            /* Membuat konten dalam satu garis horizontal */
            position: relative;
        }

        /* Mengatur lebar konten agar bisa digeser */
        .contents .content-inner {
            display: inline-flex;
            /* Konten akan ditampilkan dalam satu baris horizontal */
            min-width: 100%;
            /* Setiap item konten mengambil lebar penuh layar */
        }

        .contents h1 {
            font-size: 48px;
            font-weight: bold;
            color: #000;
            margin-bottom: 20px;
        }

        .contents p {
            font-size: 24px;
            color: #000;
            margin-bottom: 40px;
        }

        .icons {
            display: flex;
            justify-content: center;
            margin-top: 30px;
        }

        .icon {
            margin: 0 20px;
            text-align: center;
        }

        .icon img {
            width: 100px;
            height: 100px;
        }

        .icon p {
            font-size: 18px;
            color: #000;
            font-weight: bold;
        }

        .container.text-center {
            background-image: url('../assets/img/middle.png');
            background-size: cover;
            background-position: center;
            background-repeat: no-repeat;
            width: 100vw;
            height: 100%;
            margin: 0;
            padding: 0;
            color: white;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            box-sizing: border-box;
        }

        .footer {
            padding: 40px 0;
            color: #333;
            text-align: center;
            position: relative;
            width: 100%;
            border-top: 1px solid rgba(255, 255, 255, 0.3);
        }

        .footer .col {
            text-align: center;
            margin-bottom: 20px;
        }

        .footer .col h5 {
            font-weight: bold;
            margin-bottom: 20px;
        }

        .footer .col p,
        .footer .col a {
            color: #333;
            text-decoration: none;
        }

        .footer .col a:hover {
            text-decoration: underline;
        }

        .footer .social-icons a {
            color: #333;
            margin-right: 10px;
            font-size: 20px;
            padding: 10px;
            border-radius: 50%;
            display: inline-block;
            background-color: rgba(255, 255, 255, 0.7);
            transition: background 0.3s, transform 0.3s;
        }

        .footer .social-icons a:hover {
            transform: scale(1.1);
            background-color: rgba(255, 255, 255, 1);
            opacity: 0.9;
        }

        .footertag {
            margin-top: 50px;
            text-align: center;
            color: #000;
            font-size: 14px;
        }

        /* Media Queries for Responsiveness */
        @media (max-width: 1200px) {
            .content h1 {
                font-size: 2.5em;
            }

            .content p {
                font-size: 1.1em;
            }

            .navbar-nav .nav-link {
                font-size: 14px;
            }
        }

        @media (max-width: 768px) {
            .navbar-toggler {
                position: absolute;
                top: 20px;
                right: 20px;
                z-index: 1050;
            }

            .navbar-collapse {
                text-align: center;
                background-color: transparent;
                border-radius: 8px;
                padding: 20px;
                margin-top: 10px;
            }

            .navbar-nav .nav-item {
                margin-bottom: 15px;
            }

            .nav-link {
                font-size: 14px;
                padding: 12px 0;
            }

            .navbar-toggler-icon {
                width: 35px;
                height: 4px;
                background-color: #000;
                border-radius: 2px;
            }

            .navbar {
                margin-bottom: 20px;
            }
        }

        @media (max-width: 576px) {
            .navbar-toggler {
                top: 15px;
                right: 15px;
            }

            .navbar-collapse {
                padding: 25px;
                margin-top: 15px;
                background-color: transparent;
            }

            .navbar-nav .nav-item {
                margin-bottom: 20px;
            }

            .nav-link {
                font-size: 12px;
                padding: 15px 0;
            }
        }
    </style>
</head>

<body>
    <div class="contents">
        <nav class="navbar navbar-expand-lg">
            <div class="container-fluid">
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
                    aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                </button>
                <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
                    <ul class="navbar-nav">
                        <li class="nav-item">
                            <?php
                            $isUserLoggedIn = isset($_SESSION['user_id']);
                            ?>
                            <a class="nav-link" href="<?= $isUserLoggedIn ? 'reservasi.php' : 'login.php' ?>">RESERVASI</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#fasilitas">FASILITAS</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="#footer">CONTACT US</a>
                        </li>
                        <li class="nav-item">
                            <?php
                            $isUserLoggedIn = isset($_SESSION['user_id']);
                            ?>
                            <?php if ($isUserLoggedIn) : ?>
                                <a class="nav-link login" href="logout.php">LOGOUT</a>
                            <?php else : ?>
                                <!-- <a class="nav-link login" href="login.php">LOGIN</a> -->
                            <?php endif; ?>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>
    </div>

    <div class="container-fluid py-5 card-container" id="fasilitas">
        <div class="row g-4">
            <?php foreach ($places as $place) : ?>
                <div class="col-lg-3 col-md-4 col-sm-6">
                    <div class="card shadow">
                        <img src="../<?= htmlspecialchars($place['image']); ?>" class="card-img-top" alt="<?= htmlspecialchars($place['name']); ?>">
                        <div class="card-body">
                            <h5 class="card-title"><?= htmlspecialchars($place['name']); ?></h5>
                            <a href="detail.php?id=<?= $place['id']; ?>" class="btn btn-primary">Lihat Detail</a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <div class="footer" id="footer">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-md-6 text-center">
                        <p>Dinas Kebudayaan dan Pariwisata Kota Tangerang<br>
                            Jl. Mayjen Sutoyo No.11, RT.002/RW.001<br>
                            Sukarasa, Kec. Tangerang,<br>
                            Kota Tangerang, Banten 15111</p>
                        <p>
                            <i class="fa fa-phone" aria-hidden="true"></i>
                            <span>0857 2888 6957 (chat only)</span>
                        </p>
                        <p>
                            <i class="fas fa-envelope"></i>
                            <span>disbudpar@tangerangkota.go.id</span>
                        </p>
                        <p>
                            <a href="https://play.google.com/store/apps/details?id=id.go.tangerangkota.tangeranglive" target="_blank" rel="noopener noreferrer">
                                <i class="fas fa-headset"></i>
                                <span>Tangerang Live</span>
                            </a>
                        </p>
                        <div class="social-icons">
                            <a href="#"><i class="fab fa-facebook-f" style="background-color: #3b5998; padding: 10px; border-radius: 50%;"></i></a>
                            <a href="#"><i class="fab fa-twitter" style="background-color: #1da1f2; padding: 10px; border-radius: 50%;"></i></a>
                            <a href="#"><i class="fab fa-instagram" style="background-color: #e1306c; padding: 10px; border-radius: 50%;"></i></a>
                            <a href="#"><i class="fab fa-tiktok" style="background-color: #000000; padding: 10px; border-radius: 50%;"></i></a>
                            <a href="#"><i class="fab fa-youtube" style="background-color: #ff0000; padding: 10px; border-radius: 50%;"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>

    <footer class="footertag">
        <p>&copy; 2024 Reservasi Tempat. Semua Hak Dilindungi.</p>
    </footer>
    </div>
</body>

</html>