<?php
include '../db.php';

// Ambil ID tempat dari URL
if (isset($_GET['id'])) {
    $place_id = $_GET['id'];

    // Ambil data tempat berdasarkan ID
    $sql = "SELECT * FROM places WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $place_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $place = $result->fetch_assoc();

    // Jika tempat tidak ditemukan
    if (!$place) {
        echo "Tempat tidak ditemukan.";
        exit;
    }
} else {
    echo "ID tempat tidak ditemukan.";
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Tempat</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css">
    <script src="../assets/js/sweetalert.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet" />
    <link rel="icon" href="../assets/img/logotng.png" type="image/x-icon">
    <style>
        body {
            background: linear-gradient(to bottom, #f8f9fa, #e3f2fd);
            /* Warna gradient dari abu muda ke biru lembut */
            font-family: 'Arial', sans-serif;
            margin: 0;
            padding: 0;
            color: #333;
        }

        /* Produk Detail */
        .product-detail {
            background-color: #ffffff;
            border: 1px solid #e0e0e0;
            padding: 20px;
            margin-top: 20px;
            border-radius: 10px;
        }

        .product-title {
            font-size: 24px;
            font-weight: bold;
        }

        .product-description-title {
            font-weight: bold;
            margin-top: 20px;
        }

        .product-location-title {
            font-weight: bold;
            margin-top: 20px;
        }

        /* Desain Card */
        .card {
            background: rgba(255, 255, 255, 0.8);
            /* Transparansi lembut */
            border: none;
            border-radius: 15px;
            transition: transform 0.3s, box-shadow 0.3s;
        }

        .card:hover {
            transform: scale(1.05);
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.3);
        }

        .card-img-top {
            height: 300px;
            object-fit: cover;
            border-radius: 10px;
        }

        /* Footer */
        .footer {
            background-color: rgba(255, 255, 255, 0.5);
            /* Transparansi 50% */
            backdrop-filter: blur(5px);
            /* Efek blur */
            padding: 40px 0;
            /* Jarak atas dan bawah */
            color: #333;
            /* Warna teks kontras */
            text-align: center;
            /* Teks di tengah */
            position: relative;
            /* Posisi normal tetapi tetap mengikuti tata letak */
            width: 100%;
            /* Lebar penuh */
            border-top: 1px solid rgba(255, 255, 255, 0.3);
            /* Garis pemisah transparan di atas */
        }

        .footer .col {
            text-align: center;
            margin-bottom: 20px;
        }

        .footer .col h5 {
            font-weight: bold;
            margin-bottom: 20px;
        }

        .footer .col p,
        .footer .col a {
            color: #333;
            text-decoration: none;
        }

        .footer .col a:hover {
            text-decoration: underline;
        }

        .footer .social-icons a {
            color: #333;
            /* Warna ikon sosial */
            margin-right: 10px;
            font-size: 20px;
            padding: 10px;
            border-radius: 50%;
            display: inline-block;
            background-color: rgba(255, 255, 255, 0.7);
            /* Background ikon */
            transition: background 0.3s, transform 0.3s;
        }

        .footer .social-icons a:hover {
            transform: scale(1.1);
            /* Efek zoom saat hover */
            background-color: rgba(255, 255, 255, 1);
            /* Warna ikon berubah lebih solid */
            opacity: 0.9;
        }


        .footertag {
            margin-top: 50px;
            text-align: center;
            color: #000;
            font-size: 14px;
        }

        h1 {
            font-weight: bold;
            margin-top: 30px;
            color: #fff;
        }

        .btn-custom {
            background-color: #ff8c42;
            border: none;
            border-radius: 20px;
            font-weight: bold;
            padding: 10px 20px;
            transition: all 0.3s ease;
        }

        .btn-custom:hover {
            background-color: #ffa756;
            box-shadow: 0 5px 15px rgba(255, 140, 66, 0.4);
        }

        .btn-primary {
            background-color: #ff8c42;
            border: none;
            border-radius: 20px;
            font-weight: bold;
            padding: 10px 20px;
            transition: background 0.3s, box-shadow 0.3s;
        }

        .btn-primary:hover {
            background-color: #ffa756;
            box-shadow: 0 5px 15px rgba(255, 140, 66, 0.4);
        }
    </style>
</head>

<body>
    <div class="container mt-4">
        <h2 class="text-center">Detail Tempat</h2>
        <div class="row product-detail align-items-center">
            <!-- Kolom Gambar -->
            <div class="col-md-6 mb-4 mb-md-0">
                <img src="../<?= htmlspecialchars($place['image']); ?>" class="img-fluid rounded shadow-sm" alt="<?= htmlspecialchars($place['name']); ?>">
            </div>
            <!-- Kolom Detail -->
            <div class="col-md-6">
                <h3 class="product-title mb-3"><?= htmlspecialchars($place['name']); ?></h3>
                <p class="product-description text-muted"><?= nl2br(htmlspecialchars($place['description'])); ?></p>
                <p class="product-location text-muted">
                    <strong>Lokasi:</strong>
                    <a href="https://www.google.com/maps/search/?q=<?= urlencode($place['lokasi']); ?>"
                        target="_blank"
                        class="text-decoration-none text-primary">
                        <?= htmlspecialchars($place['lokasi']); ?>
                    </a>
                </p>
                <div class="mt-4">
                    <a href="reservasi.php" class="btn btn-primary me-2">Reservasi Sekarang</a>
                    <a href="index.php" class="btn btn-secondary">Kembali</a>
                </div>
            </div>
        </div>
    </div>


    <div class="footer" id="footer">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-6 text-center">
                    <p>Dinas Kebudayaan dan Pariwisata Kota Tangerang<br>
                        Jl. Mayjen Sutoyo No.11, RT.002/RW.001<br>
                        Sukarasa, Kec. Tangerang,<br>
                        Kota Tangerang, Banten 15111</p>
                    <p>
                        <i class="fa fa-phone" aria-hidden="true"></i>
                        <span>0857 2888 6957 (chat only)</span>
                    </p>
                    <p>
                        <i class="fas fa-envelope"></i>
                        <span>disbudpar@tangerangkota.go.id</span>
                    </p>
                    <p>
                        <a href="https://play.google.com/store/apps/details?id=id.go.tangerangkota.tangeranglive" target="_blank" rel="noopener noreferrer">
                            <i class="fas fa-headset"></i>
                            <span>Tangerang Live</span>
                        </a>
                    </p>
                    <div class="social-icons">
                        <a href="#"><i class="fab fa-facebook-f" style="background-color: #3b5998; padding: 10px; border-radius: 50%;"></i></a>
                        <a href="#"><i class="fab fa-twitter" style="background-color: #1da1f2; padding: 10px; border-radius: 50%;"></i></a>
                        <a href="#"><i class="fab fa-instagram" style="background-color: #e1306c; padding: 10px; border-radius: 50%;"></i></a>
                        <a href="#"><i class="fab fa-tiktok" style="background-color: #000000; padding: 10px; border-radius: 50%;"></i></a>
                        <a href="#"><i class="fab fa-youtube" style="background-color: #ff0000; padding: 10px; border-radius: 50%;"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <footer class="footertag">
        <p>&copy; 2024 Reservasi Tempat. Semua Hak Dilindungi.</p>
    </footer>
    </div>
</body>

</html>