<?php
session_start();
include '../db.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'user') {
    header('Location: login.php');
    exit;
}

$user_id = intval($_SESSION['user_id']);

/* === Pagination Setup === */
$items_per_page = 8;
$current_page   = isset($_GET['page']) ? max(1, (int) $_GET['page']) : 1;
$offset         = ($current_page - 1) * $items_per_page;

/* === Hitung total data === */
$stmtTotal = $conn->prepare("SELECT COUNT(*) AS total FROM reservations WHERE user_id = ?");
$stmtTotal->bind_param('i', $user_id);
$stmtTotal->execute();
$total_data  = $stmtTotal->get_result()->fetch_assoc()['total'] ?? 0;
$total_pages = (int) ceil($total_data / $items_per_page);

/* === Ambil data reservasi: urut ID terbesar === */
$dataQuery = "SELECT * FROM reservations WHERE user_id = ? ORDER BY id DESC LIMIT ? OFFSET ?";
$stmtData  = $conn->prepare($dataQuery);
$stmtData->bind_param('iii', $user_id, $items_per_page, $offset);
$stmtData->execute();
$result = $stmtData->get_result();

/* === Ambil nama pengguna === */
$user_stmt = $conn->prepare("SELECT username FROM users WHERE id = ?");
$user_stmt->bind_param('i', $user_id);
$user_stmt->execute();
$users = $user_stmt->get_result()->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="id">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Dashboard User</title>
  <link rel="icon" href="../assets/img/logo.png" type="image/x-icon" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet" />
      <!-- Favicon -->
      <link rel="icon" href="../assets/img/logotng.png" type="image/x-icon">
  <style>
    body {
      font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
      background-color: #f8f9fa;
    }

    .navbar {
      background-color: #002147;
    }

    .navbar-brand img {
      height: 40px;
    }

    .navbar .nav-link {
      color: #fff;
    }

    .navbar .nav-link:hover {
      color: #f0ad4e;
    }

    .dropdown-menu {
      background-color: #002147;
      border: none;
    }

    .dropdown-item {
      color: white;
    }

    .dropdown-item:hover {
      background-color: #f0ad4e;
      color: #002147;
    }

    .content {
      padding: 30px;
    }

    .table {
      background-color: #fff;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(0, 0, 0, 0.05);
      overflow: hidden;
    }

    .table thead {
      background-color: #002147;
      color: #fff;
    }

    .table th,
    .table td {
      vertical-align: middle;
      padding: 12px;
    }

    .btn-dark i,
    .btn-info i {
      margin-right: 4px;
    }

    .pagination .page-item.active .page-link {
      background-color: #002147;
      border-color: #002147;
    }

    .pagination .page-link {
      color: #002147;
    }

    .pagination .page-link:hover {
      background-color: #f0ad4e;
      color: #fff;
    }
  </style>
</head>

<body>
  <nav class="navbar navbar-expand-lg navbar-dark">
    <div class="container-fluid">
      <a class="navbar-brand" href="#">
        <img src="../assets/img/logo.png" alt="Logo">
      </a>
      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>
      <div class="collapse navbar-collapse" id="navbarNav">
        <ul class="navbar-nav ms-auto">
          <li class="nav-item">
            <a href="index.php" class="nav-link">
              <i class="fas fa-home"></i> Home
            </a>
          </li>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
              <i class="far fa-user-circle"></i> <?php echo htmlspecialchars($users['username']); ?>
            </a>
            <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
              <li>
                <a class="dropdown-item" href="logout.php">
                  <i class="fas fa-sign-out-alt"></i> Logout
                </a>
              </li>
            </ul>
          </li>
        </ul>
      </div>
    </div>
  </nav>

  <div class="content container">
    <div class="d-flex justify-content-between align-items-center mb-4">
      <h4 class="mb-0">Reservasi Anda</h4>
      <a href="reservasi.php" class="btn btn-dark">
        <i class="fas fa-plus"></i> Reservasi Baru
      </a>
    </div>

    <div class="table-responsive">
      <table class="table table-hover">
        <thead>
          <tr>
            <th>Kode Booking</th>
            <th>Nama</th>
            <th>Email</th>
            <th>Tempat</th>
            <th>Tanggal</th>
            <th>Jam Mulai</th>
            <th>Jam Selesai</th>
            <th>Keterangan</th>
            <th>Status</th>
            <th>Aksi</th>
          </tr>
        </thead>
        <tbody>
          <?php
            // /* Pastikan query asal sudah: SELECT ... FROM reservasi WHERE user_id=? ORDER BY id DESC */
            if ($result->num_rows > 0):
              while ($row = $result->fetch_assoc()):
          ?>
            <tr>
              <td><?= htmlspecialchars($row['kode_booking']); ?></td>
              <td><?= htmlspecialchars($row['nama']); ?></td>
              <td><?= htmlspecialchars($row['surat']); ?></td>
              <td><?= htmlspecialchars($row['tempat']); ?></td>
              <td><?= htmlspecialchars($row['hari']); ?></td>
              <td><?= htmlspecialchars($row['jam_mulai']); ?></td>
              <td><?= htmlspecialchars($row['jam_selesai']); ?></td>
              <td><?= htmlspecialchars($row['keterangan']); ?></td>
              <td><?= ucfirst(htmlspecialchars($row['status'])); ?></td>
              <td>
                <a href="v_reserv.php?id=<?= urlencode($row['id']); ?>" class="btn btn-info btn-sm">
                  <i class="fas fa-eye"></i> Lihat
                </a>
              </td>
            </tr>
          <?php
              endwhile;
            else:
          ?>
            <tr>
              <td colspan="10" class="text-center">Belum ada reservasi</td>
            </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>

    <!-- Pagination -->
    <nav>
      <ul class="pagination justify-content-center mt-4">
        <?php if ($current_page > 1): ?>
          <li class="page-item">
            <a class="page-link" href="?page=<?= $current_page - 1; ?>">Previous</a>
          </li>
        <?php endif; ?>

        <?php for ($i = 1; $i <= $total_pages; $i++): ?>
          <li class="page-item <?= $i == $current_page ? 'active' : ''; ?>">
            <a class="page-link" href="?page=<?= $i; ?>"> <?= $i; ?> </a>
          </li>
        <?php endfor; ?>

        <?php if ($current_page < $total_pages): ?>
          <li class="page-item">
            <a class="page-link" href="?page=<?= $current_page + 1; ?>">Next</a>
          </li>
        <?php endif; ?>
      </ul>
    </nav>

    <p class="text-muted text-center">Menampilkan halaman <?= $current_page ?> dari <?= $total_pages ?></p>
  </div>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>
