<?php
session_start();
include '../db.php';

// Pastikan hanya user yang dapat mengakses halaman ini
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'user') {
    header('Location: login.php');
    exit;
}

// Ambil parameter tempat (jika ada)
$tempat = isset($_GET['tempat']) ? $_GET['tempat'] : null;

// Query untuk mendapatkan daftar tempat unik dari tabel places
$queryTempat = "SELECT DISTINCT name FROM places";
$resultTempat = $conn->query($queryTempat);

$tempatList = [];
while ($rowTempat = $resultTempat->fetch_assoc()) {
    $tempatList[] = $rowTempat['name'];
}

// Query untuk mendapatkan tanggal yang sudah terisi berdasarkan tempat (jika tempat dipilih)
$query = "SELECT DISTINCT hari FROM reservations";
if ($tempat) {
    $query .= " WHERE tempat = '" . $conn->real_escape_string($tempat) . "'";
}
$result = $conn->query($query);

$booked_dates = [];
while ($row = $result->fetch_assoc()) {
    $booked_dates[] = $row['hari'];
}

// Kirim data tanggal terisi dalam format JSON
$booked_dates_json = json_encode($booked_dates);
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kalender Reservasi</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.css">
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
    <link rel="icon" href="../assets/img/logotng.png" type="image/x-icon">
</head>

<body>
    <div class="container mt-5">
        <h2 class="text-center mb-4">Kalender Reservasi</h2>
        <div class="mb-3">
            <label for="filterTempat" class="form-label">Filter Berdasarkan Tempat:</label>
            <select id="filterTempat" class="form-select">
                <option value="">Semua Tempat</option>
                <?php foreach ($tempatList as $t): ?>
                    <option value="<?= htmlspecialchars($t); ?>" <?= ($tempat === $t) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($t); ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>
        <a href="reservasi.php" class="btn btn-danger mb-3">Back</a>
        <div id="calendar"></div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');

            // Ambil tanggal yang sudah terisi dari PHP
            var bookedDates = <?php echo $booked_dates_json; ?>;

            // Ambil elemen dropdown filter tempat
            var filterTempat = document.getElementById('filterTempat');

            // Ambil data terakhir yang dipilih dari sessionStorage (jika ada)
            var selectedDate = sessionStorage.getItem('selectedDate');

            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                headerToolbar: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'dayGridMonth,timeGridWeek,timeGridDay'
                },
                events: function(fetchInfo, successCallback, failureCallback) {
                    var events = bookedDates.map(function(date) {
                        return {
                            title: 'Sudah Terisi', // Judul event untuk tanggal yang sudah terisi
                            start: date, // Tanggal event
                            color: '#007bff' // Warna biru
                        };
                    });
                    successCallback(events);
                },
                dateClick: function(info) {
                    if (bookedDates.includes(info.dateStr)) {
                        return; // Tidak ada aksi untuk tanggal terisi
                    }

                    // Ambil tempat yang dipilih dari dropdown
                    var selectedTempat = filterTempat.value;

                    if (!selectedTempat) {
                        alert('Pilih tempat terlebih dahulu!');
                        return;
                    }

                    // Simpan tempat dan tanggal yang dipilih di sessionStorage
                    sessionStorage.setItem('selectedDate', info.dateStr);
                    sessionStorage.setItem('selectedTempat', selectedTempat);

                    // Redirect ke halaman reservasi dengan tempat dan tanggal yang dipilih
                    window.location.href = 'reservasi.php?date=' + info.dateStr + '&tempat=' + encodeURIComponent(selectedTempat);
                }
            });

            calendar.render(); // Render kalender

            // Jika ada data terakhir yang dipilih, fokuskan kalender ke tanggal tersebut
            if (selectedDate) {
                calendar.gotoDate(selectedDate);
            }

            // Filter tempat berdasarkan dropdown
            filterTempat.addEventListener('change', function() {
                var tempat = this.value;
                var urlParams = new URLSearchParams(window.location.search);
                if (tempat) {
                    urlParams.set('tempat', tempat);
                } else {
                    urlParams.delete('tempat');
                }
                window.location.search = urlParams.toString();
            });
        });
    </script>
</body>

</html>
