<?php
session_start();
include '../db.php';

// Pastikan hanya user yang dapat mengakses halaman ini
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'user') {
    header('Location: login.php');
    exit;
}

try {
    // Query untuk mengambil data dari tabel reservations
    $query = "SELECT id, nama, hari, keterangan FROM reservations";
    $stmt = $conn->prepare($query);
    $stmt->execute();

    $events = [];
    // Ambil data dan masukkan ke dalam array events
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        // Format tanggal 'hari' menjadi format yang sesuai dengan FullCalendar (YYYY-MM-DD)
        $date = new DateTime($row['hari']);
        $formatted_date = $date->format('Y-m-d'); // Format sesuai FullCalendar (YYYY-MM-DD)

        // Menambahkan event ke dalam array
        $events[] = [
            'id' => $row['id'],
            'title' => $row['nama'] . ' (' . $row['keterangan'] . ')', // Nama dan keterangan sebagai judul
            'start' => $formatted_date, // Pastikan format hari sesuai dengan FullCalendar
        ];
    }

    // Mengembalikan data dalam format JSON
    header('Content-Type: application/json');
    echo json_encode($events);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Terjadi kesalahan: ' . $e->getMessage()]);
}
?>
