<?php
session_start();
include '../db.php';

// Cek apakah admin sudah login dan memiliki role 'admin'
if (!isset($_SESSION['admin_id'])) {
    header('Location: login_admin.php');
    exit;
}

// Ambil ID reservasi dari URL
if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo "ID reservasi tidak ditemukan.";
    exit;
}

$id = intval($_GET['id']);

// Cek apakah ID adalah angka yang valid
if ($id <= 0) {
    echo "ID reservasi tidak valid.";
    exit;
}

// Ambil detail reservasi berdasarkan ID
$query = "SELECT * FROM reservations WHERE id = $id";
$result = $conn->query($query);

if ($result->num_rows == 0) {
    echo "Reservasi tidak ditemukan.";
    exit;
}

$reservation = $result->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Reservasi</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css">
    <link rel="icon" href="../assets/img/logotng.png" type="image/x-icon">
</head>

<body>
    <div class="container mt-5">
        <h1 class="text-center">Detail Reservasi</h1>
        <div class="card mt-4">
            <div class="card-body">
                <p><strong>Kode Booking:</strong> <?= htmlspecialchars($reservation['kode_booking']); ?></p>
                <p><strong>Nama:</strong> <?= htmlspecialchars($reservation['nama']); ?></p>
                <p><strong>No Telepon:</strong> <?= htmlspecialchars($reservation['no_telepon']); ?></p>
                <p><strong>Email:</strong> <?= htmlspecialchars($reservation['surat']); ?></p>
                <p><strong>Tempat:</strong> <?= htmlspecialchars($reservation['tempat']); ?></p>
                <p><strong>Tanggal:</strong> <?= htmlspecialchars($reservation['hari']); ?></p>
                <p><strong>Waktu:</strong> <?= htmlspecialchars($reservation['jam_mulai'] . ' - ' . $reservation['jam_selesai']); ?></p>
                <p><strong>Keterangan:</strong> <?= htmlspecialchars($reservation['keterangan']); ?></p>
                <?php if ($reservation['file_upload']): ?>
                    <p><strong>File Upload:</strong> <a href="../uploads/<?= htmlspecialchars($reservation['file_upload']); ?>" target="_blank">Lihat File</a></p>
                <?php else: ?>
                    <p><strong>File Upload:</strong> Tidak ada file yang diunggah.</p>
                <?php endif; ?>
                <p><strong>Status:</strong> <?= htmlspecialchars($reservation['status']); ?></p>
                <p><strong>Catatan:</strong> <?= htmlspecialchars($reservation['catatan']); ?></p>
            </div>
            <div class="card-footer text-end">
                <a href="kelola_reserv.php" class="btn btn-secondary">Kembali</a>
            </div>
        </div>
    </div>
</body>

</html>
