<?php
/* -----------------------------------------------------------
 *  reservation_pdf.php  –  Surat Reservasi (layout resmi)
 * -----------------------------------------------------------
 */
require_once __DIR__ . '/fpdf_php8_polyfill.php';
require_once __DIR__ . '/../vendor/setasign/fpdf/fpdf.php';

/* util tanggal */
function indoDate(string $iso): string
{
    $bulan = [
        1 => 'Januari',
        'Februari',
        'Maret',
        'April',
        'Mei',
        'Juni',
        'Juli',
        'Agustus',
        'September',
        'Oktober',
        'November',
        'Desember'
    ];
    [$y, $m, $d] = explode('-', date('Y-m-d', strtotime($iso)));
    return ltrim($d, '0') . ' ' . $bulan[(int)$m] . ' ' . $y;
}

function buatPDFReservasi(array $data, string $status): string
{

    /* ===== HEADER & FOOTER ===== */
    class SuratPDF extends \FPDF
    {
        public string $logo = '';          // di‑set di luar
        private bool  $first = true;

        function Header()
        {
            if (!$this->first) return;

            /* --- LOGO --- */
            if (is_file($this->logo)) {
                // x = 20 mm, y = 12 mm, lebar = 22 mm
                $this->Image($this->logo, 20, 12, 22);
            }

            /*  posisi awal teks  */
            $xText = 60;                   // 20 mm (margin) + 22 mm (logo) + ±18 mm jarak
            $this->SetFont('Arial', 'B', 14);

            $this->SetXY($xText, 15);
            $this->Cell(0, 5, 'PEMERINTAH KOTA TANGERANG', 0, 1, 'C');

            $this->SetX($xText);
            $this->SetFont('Arial', 'B', 16);
            $this->Cell(0, 7, 'DINAS KEBUDAYAAN DAN PARIWISATA', 0, 1, 'C');

            $this->SetFont('Arial', '', 10);
            $this->SetX($xText);
            $this->Cell(
                0,
                5,
                'Jl. Mayjen Sutoyo No.11, Kel. Sukarasa, Kec. Tangerang, Kota Tangerang, Banten 15111',
                0,
                1,
                'C'
            );
            $this->SetX($xText);
            $this->Cell(0, 5, 'Telepon 021-38959052  Faksimile 021-38959052', 0, 1, 'C');
            $this->SetX($xText);
            $this->Cell(
                0,
                5,
                'Laman. disbudpar.tangerangkota.go.id   Pos-el disbudpar@tangerangkota.go.id',
                0,
                1,
                'C'
            );

            /* --- garis tebal --- */
            $this->SetLineWidth(1.2);
            $this->Line(15, $this->GetY() + 2, 195, $this->GetY() + 2);
            $this->Ln(10);

            $this->first = false;
        }
    }

    $pdf = new SuratPDF('P', 'mm', 'A4');
    $pdf->SetMargins(20, 20, 20);
    $pdf->logo = __DIR__ . '/../assets/img/logotng.png';          // ✔ path baru
    $pdf->AddPage();
    $pdf->SetTitle('Surat Reservasi ' . $data['kode_booking']);

    /* ===== HEADER SURAT ===== */
    $pdf->SetFont('Arial', '', 12);
    $y0 = $pdf->GetY();
    $pdf->Cell(0, 6, 'Perihal : Reservasi Tempat');
    $pdf->SetXY(0, $y0);
    $pdf->Cell(0, 6, 'Tangerang, ' . indoDate($data['hari']), 0, 1, 'R');
    $pdf->Ln(3);

    /* ---------- 2. “Kepada Yth.” KIRI ---------- */
    $pdf->Cell(0, 6, 'Kepada Yth.', 0, 1);
    $pdf->MultiCell(
        0,
        6,
        "Dinas Kebudayaan dan\nPariwisata Tangerang\ndi -\nTangerang",
        0
    );
    $pdf->Ln(4);

    /* hitung lebar area teks sekali saja */
    $pageW     = method_exists($pdf, 'GetPageWidth') ? $pdf->GetPageWidth() : $pdf->w;
    $margin    = 20;
    $indent    = 10;                     // indent khusus paragraf pertama
    $lebarFull = $pageW - ($margin * 2);

    /* ==== PARAGRAF PERTAMA – DENGAN INDENT 1 cm ==== */
    $pdf->SetX($margin);
    $paragraf1 =
        "Kami berencana mengadakan kegiatan sesuai keperluan instansi dan memerlukan tempat "
        . "di lingkungan Pemerintah Kota Tangerang. Sehubungan dengan itu, kami mohon kesediaan "
        . "Dinas Kebudayaan dan Pariwisata untuk menyediakan tempat.";
    $pdf->MultiCell($lebarFull, 6, $paragraf1, 0, 'J');
    $pdf->Ln(3);

    /* tabel info */
    $info = [
        'Tanggal'    => indoDate($data['hari']),
        'Tempat'     => $data['tempat'],
        'Waktu'      => $data['jam_mulai'] . ' - ' . $data['jam_selesai'],
        'Keterangan' => $data['keterangan']
    ];
    foreach ($info as $k => $v) {
        $pdf->Cell(25, 6, $k, 0, 0);
        $pdf->Cell(4, 6, ':', 0, 0);
        $pdf->MultiCell(0, 6, $v, 0);
    }
    $pdf->Ln(4);

    $pdf->SetX($margin);
    $paragraf2 =
        "Demikian Surat Reservasi ini kami buat dengan sebenarnya agar dapat dipergunakan "
        . "sebagaimana mestinya.";
    $pdf->MultiCell($lebarFull, 6, $paragraf2, 0, 'J');
    $pdf->Ln(10);

    /* =====  TANDA TANGAN  ===== */

    /* kolom kiri: pemohon + e‑materai */
    $margin = 20;
    $pageW  = $pdf->GetPageWidth();
    $colW   = ($pageW - ($margin * 2)) / 2;   // 2 kolom sama lebar

    $yStart = $pdf->GetY() + 8;               // sedikit jarak dari paragraf penutup

    /* --- Baris 1 : label --- */
    $pdf->SetFont('Arial', '', 12);
    $pdf->SetXY($margin, $yStart);
    $pdf->Cell($colW, 6, 'Yang Mengajukan,', 0, 0, 'C');
    $pdf->Cell($colW, 6, 'Tangerang, ' . indoDate($data['hari']), 0, 1, 'C');

    /* --- Baris 2 : sub‑label --- */
    $pdf->SetX($margin);
    $pdf->Cell($colW, 6, '(e-materai)', 0, 0, 'C');
    $pdf->Cell($colW, 6, 'SEKRETARIS', 0, 1, 'C');

    /* --- Sisipkan gambar tanda tangan di kolom kanan --- */
    $ttdPath = __DIR__ . '/../assets/img/ttd.png';      // pastikan file ada
    $sigH    = 18;                                    // tinggi gambar (mm)
    if (is_file($ttdPath)) {
        $sigW = 40;                                   // lebar gambar (mm)
        $sigX = $margin + $colW + ($colW - $sigW) / 2;
        $sigY = $pdf->GetY() + 2;                     // 2 mm di bawah baris 2
        $pdf->Image($ttdPath, $sigX, $sigY, $sigW);   // tampilkan
    }
    $pdf->Ln($sigH + 6);                              // ruang untuk ttd + jarak

    /* --- Baris 3 : NAMA & NIP --- */
    $yName = $pdf->GetY();

    # Pemohon (kiri)
    $pdf->SetXY($margin, $yName);
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->Cell($colW, 6, strtoupper($data['nama']), 0, 0, 'C');

    # Sekretaris (kanan)
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->Cell($colW, 6, 'NANA CISYANA, S.SOS., M.Si.', 0, 1, 'C');
    $pdf->SetX($margin + $colW);
    $pdf->SetFont('Arial', '', 12);
    $pdf->Cell($colW, 6, 'NIP. 197302072002121005', 0, 1, 'C');

    /* --- Garis bawah di kedua kolom --- */
    $yLine = $yName + 6;
    $pdf->Line($margin + 10,          $yLine, $margin + $colW - 10,          $yLine); // kiri
    $pdf->Line($margin + $colW + 10,  $yLine, $margin + $colW * 2 - 10,        $yLine); // kanan

    $pdf->Ln(12); // lanjut dokumen

    // /* status */
    // $pdf->Ln(10);
    // $pdf->SetFont('Arial', '', 11);
    // $pdf->Cell(0, 5, 'Status Terbaru: ' . ucfirst($status), 0, 1);

    /* output */
    return $pdf->Output('S');
}
