<?php
include '../db.php';
session_start();

// Pastikan admin sudah login
if (!isset($_SESSION['admin_id'])) {
    header('Location: login_admin.php');
    exit;
}

// Pastikan ID reservasi tersedia
if (!isset($_GET['id'])) {
    echo "ID reservasi tidak ditemukan.";
    exit;
}
$id = intval($_GET['id']); // Sanitasi ID

// Ambil detail reservasi berdasarkan ID
$query = "SELECT * FROM reservations WHERE id = $id";
$result = $conn->query($query);

if (!$result || $result->num_rows === 0) {
    echo "Reservasi tidak ditemukan.";
    exit;
}
$reservation = $result->fetch_assoc();

// Ambil daftar tempat
$queryPlaces = "SELECT name FROM places"; // Tabel tempat
$resultPlaces = $conn->query($queryPlaces);

if (!$resultPlaces) {
    echo "Error: " . $conn->error;
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validasi data input
    $nama = $conn->real_escape_string($_POST['nama']);
    $no_telepon = $conn->real_escape_string($_POST['no_telepon']);
    $surat = $conn->real_escape_string($_POST['email']); // Konsisten dengan kolom
    $tempat = $conn->real_escape_string($_POST['tempat']);
    $keterangan = $conn->real_escape_string($_POST['keterangan']);
    $catatan = $conn->real_escape_string($_POST['catatan']);

    // Perbarui data reservasi
    $sql = "UPDATE reservations SET 
                nama='$nama', 
                no_telepon='$no_telepon', 
                surat='$surat', 
                tempat='$tempat', 
                keterangan='$keterangan', 
                catatan='$catatan' 
            WHERE id='$id'";
    if ($conn->query($sql) === TRUE) {
        header('Location: kelola_reserv.php');
        exit;
    } else {
        echo "Error: " . $conn->error;
    }
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Tempat</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css">
    <link rel="icon" href="../assets/img/logotng.png" type="image/x-icon">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>

<body>
    <div class="container mt-5">
        <h1>Edit Reservasi</h1>
        <form method="post" enctype="multipart/form-data" id="editForm">
            <div class="form-group">
                <label for="nama">Nama:</label>
                <input type="text" class="form-control" id="nama" name="nama" value="<?= htmlspecialchars($reservation['nama']); ?>" required>
            </div>
            <div class="form-group">
                <label for="notelepon">No Telepon:</label>
                <input type="text" class="form-control" id="notelepon" name="no_telepon" value="<?= htmlspecialchars($reservation['no_telepon']); ?>" required>
            </div>
            <div class="form-group">
                <label for="email">Email:</label>
                <input type="text" class="form-control" id="email" name="email" value="<?= htmlspecialchars($reservation['surat']); ?>" required>
            </div>
            <div class="form-group">
                <label for="tempat" class="form-label">Tempat:</label>
                <select name="tempat" class="form-select" required>
                    <option value="">-</option>
                    <?php while ($places = $resultPlaces->fetch_assoc()): ?>
                        <option value="<?= htmlspecialchars($places['name']); ?>" <?= $reservation['tempat'] === $places['name'] ? 'selected' : ''; ?>>
                            <?= htmlspecialchars($places['name']); ?>
                        </option>
                    <?php endwhile; ?>
                </select>
            </div>
            <div class="form-group">
                <label for="keterangan">Keterangan:</label>
                <textarea class="form-control" id="keterangan" name="keterangan" required><?= htmlspecialchars($reservation['keterangan']); ?></textarea>
            </div>
            <div class="form-group">
                <label for="catatan">Catatan:</label>
                <textarea class="form-control" id="catatan" name="catatan" required><?= htmlspecialchars($reservation['catatan']); ?></textarea>
            </div>
            <button type="button" class="btn btn-primary mt-3" onclick="confirmSave()">Simpan</button>
            <a href="kelola_reserv.php" class="btn btn-secondary mt-3">Batal</a>
        </form>
    </div>
    
    <script>
        function confirmSave() {
            // SweetAlert untuk konfirmasi simpan
            Swal.fire({
                title: 'Apakah sudah benar?',
                text: "Data yang Anda masukkan akan diperbarui!",
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Ya, simpan!',
                cancelButtonText: 'Batal'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Jika konfirmasi simpan, submit form
                    document.getElementById('editForm').submit();
                }
            });
        }
    </script>
</body>

</html>
