<?php
session_start();
include '../db.php';
if (!isset($_SESSION['admin_id'])) {
    header('Location: login_admin.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Kalender Reservasi</title>
    <!-- Fonts & Icons -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet" />
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" rel="stylesheet" />
    <!-- Bootstrap -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <!-- FullCalendar -->
    <link href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.css" rel="stylesheet" />
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.5/main.min.js"></script>
    <link rel="icon" href="../assets/img/logotng.png" type="image/x-icon" />
    <style>
        :root {
            --navy: #002147;
            --navy-dark: #001531;
            --accent: #f0ad4e;
            --sidebar-w: 260px;
            --sidebar-c: 80px;
            --nav-h: 56px;
        }

        body {
            font-family: 'Poppins', sans-serif;
            background: #f4f6fb;
            transition: margin-left .3s;
            overflow-x: hidden;
        }

        /* Sidebar */
        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            width: var(--sidebar-w);
            background: linear-gradient(180deg, var(--navy)0%, var(--navy-dark)100%);
            color: #fff;
            padding: 20px 0;
            transition: width .3s, left .3s;
            z-index: 1040
        }

        .sidebar.collapsed {
            width: var(--sidebar-c)
        }

        .sidebar h5 {
            font-weight: 600;
            text-align: center;
            margin-bottom: 1.3rem;
            transition: opacity .3s
        }

        .sidebar.collapsed h5 {
            opacity: 0
        }

        .sidebar a {
            color: #fff;
            display: flex;
            align-items: center;
            gap: 12px;
            text-decoration: none !important;
            padding: 12px 22px;
            border-radius: 6px;
            margin: 4px 10px;
            font-weight: 500;
            white-space: nowrap;
            transition: background .2s
        }

        .sidebar a i {
            min-width: 22px;
            text-decoration: none !important;
            text-align: center
        }

        .sidebar.collapsed a span {
            display: none
        }

        .sidebar a.active,
        .sidebar a:hover {
            background: rgba(240, 173, 78, .18);
            text-decoration: none
        }

        /* Navbar */
        .navbar {
            background: var(--navy);
            height: var(--nav-h);
            transition: margin-left .3s
        }

        .navbar .nav-link {
            color: #fff;
            font-weight: 500
        }

        .navbar .nav-link:hover {
            color: var(--accent)
        }

        /* Content */
        .content {
            margin-left: var(--sidebar-w);
            padding: calc(var(--nav-h) + 3rem) 2rem 4rem;
            transition: margin-left .3s;
        }

        body.sidebar-collapsed .navbar {
            margin-left: var(--sidebar-c)
        }

        body.sidebar-collapsed .content {
            margin-left: var(--sidebar-c)
        }

        /* FullCalendar overrides */
        #calendar {
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, .05);
            padding: 1rem
        }

        .fc-toolbar-title {
            font-weight: 600;
            font-size: 1.25rem
        }

        .fc-header-toolbar{
            margin-top: .5rem;      /* jarak ekstra dari tepi card */
        }

        .fc-button {
            background: var(--navy);
            border: none;
            padding: .35rem .65rem;
            font-size: .85rem
        }

        .fc-button-primary:not(:disabled):hover {
            background: var(--accent);
            border: none
        }

        .fc-daygrid-event {
            background: var(--accent);
            border: none;
            padding: 2px 4px;
            font-size: .75rem
        }
    </style>
</head>

<body>
    <!-- Sidebar -->
    <aside id="sidebar" class="sidebar">
        <h5><i class="fas fa-building me-1"></i><span>Disbudpar</span></h5>
        <a href="dashboard_admin.php"><i class="fas fa-home"></i><span>Dashboard</span></a>
        <a href="kelola_reserv.php"><i class="fas fa-table"></i><span>Data Reservasi</span></a>
        <a href="kelola_tempat.php"><i class="fas fa-map-marker-alt"></i><span>Kelola Tempat</span></a>
        <a class="active" href="calendar.php"><i class="fas fa-calendar"></i><span>Kalender</span></a>
        <a href="logout_admin.php"><i class="fas fa-sign-out-alt"></i><span>Logout</span></a>
    </aside>

    <!-- Navbar -->
    <!-- Navbar -->
    <nav class="navbar fixed-top navbar-dark shadow-sm">
        <div class="container-fluid px-3">
            <span class="navbar-brand d-none d-lg-block fw-semibold">Kalender Reservasi</span>
            <!-- Icon buttons on the right -->
            <div class="d-flex align-items-center gap-2 ms-auto">
                <button id="sidebarToggle" class="btn btn-outline-light btn-sm" title="Menu"><i class="fas fa-bars"></i></button>
                <button id="fullscreenToggle" class="btn btn-outline-light btn-sm" title="Fullscreen"><i class="fas fa-expand"></i></button>
                <!-- <a href="dashboard_admin.php" class="btn btn-outline-light btn-sm" title="Back"><i class="fas fa-arrow-left"></i></a> -->
            </div>
        </div>
    </nav>

    <!-- Content -->
    <main class="content">
        <div id="calendar"></div>
    </main>

    <!-- Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script>
        // Sidebar & Fullscreen logic
        const sidebar = document.getElementById('sidebar');
        document.getElementById('sidebarToggle').addEventListener('click', () => {
            if (window.matchMedia('(max-width:768px)').matches) {
                sidebar.classList.toggle('show');
            } else {
                sidebar.classList.toggle('collapsed');
                document.body.classList.toggle('sidebar-collapsed');
            }
        });
        const fsBtn = document.getElementById('fullscreenToggle');
        fsBtn.addEventListener('click', () => {
            if (!document.fullscreenElement) {
                document.documentElement.requestFullscreen();
                fsBtn.innerHTML = '<i class="fas fa-compress"></i>';
            } else {
                document.exitFullscreen();
                fsBtn.innerHTML = '<i class="fas fa-expand"></i>';
            }
        });
        document.addEventListener('click', e => {
            if (window.matchMedia('(max-width:768px)').matches && sidebar.classList.contains('show') && !sidebar.contains(e.target) && !e.target.closest('#sidebarToggle')) {
                sidebar.classList.remove('show');
            }
        });
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const calendar = new FullCalendar.Calendar(document.getElementById('calendar'), {
                initialView: 'dayGridMonth',
                height: 'auto',
                headerToolbar: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'dayGridMonth,timeGridWeek,timeGridDay'
                },
                events: {
                    url: '../admin/tampil_reservations.php',
                    method: 'GET',
                    failure() {
                        alert('Gagal memuat data');
                    }
                },
                eventClick(info) {
                    const tempat = info.event.extendedProps?.tempat || info.event.title;
                    const tanggal = info.event.start.toLocaleDateString('id-ID');
                    Swal.fire({
                        title: 'Detail Reservasi',
                        html: `<b>Keterangan :</b> ${tempat}<br><b>Tanggal :</b> ${tanggal}`,
                        icon: 'info'
                    });
                },
                eventDisplay: 'block',
                dayMaxEvents: true,
            });
            calendar.render();
        });
    </script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</body>

</html>