<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Dashboard</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        .navbar-custom {
            background: linear-gradient(90deg, #1b59d5, #0a3d91);
            box-shadow: 0 4px 10px rgba(0,0,0,0.2);
        }
        .navbar-brand {
            font-weight: 700;
            letter-spacing: 1px;
        }
        .nav-link {
            font-weight: 500;
            transition: 0.3s;
        }
        .nav-link:hover {
            color: #ffd700 !important; /* gold effect */
        }
        .nav-link.active {
            color: #ffd700 !important;
            font-weight: 700;
        }
        .btn-logout {
            font-weight: 600;
            border-radius: 8px;
            padding: 6px 12px;
        }
    </style>
</head>
<body class="bg-light">

<!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-dark navbar-custom">
  <div class="container">
    <a class="navbar-brand" href="<?= site_url('pendaftaran/dashboard'); ?>">
        <i class="fas fa-palette"></i> Pendaftaran Seni
    </a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav ms-auto align-items-lg-center gap-2">
         <li class="nav-item">
            <a class="nav-link <?= current_url() == site_url('pendaftaran/dashboard') ? 'active' : '' ?>" 
               href="<?= site_url('pendaftaran/dashboard'); ?>">
               <i class="fas fa-home"></i> Dashboard
            </a>
        </li>
         <li class="nav-item">
            <a class="nav-link <?= current_url() == site_url('pendaftaran/biodata') ? 'active' : '' ?>" 
               href="<?= site_url('pendaftaran/biodata'); ?>">
               <i class="fas fa-users"></i> Biodata Pendaftar Seni
            </a>
        </li>
        <li class="nav-item">
          <a class="nav-link <?= current_url() == site_url('pendaftaran') ? 'active' : '' ?>" 
             href="<?= site_url('pendaftaran'); ?>">
             <i class="fas fa-edit"></i> Form
          </a>
        </li>
        <li class="nav-item">
         <a class="nav-link <?= current_url() == site_url('pendaftaran/profile') ? 'active' : '' ?>" 
            href="<?= site_url('pendaftaran/profile'); ?>">
            <i class="fas fa-user"></i> Profile
         </a>
        </li>
       <li class="nav-item">
    <button class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#logoutModal">
        <i class="fas fa-door-open"></i> Logout
    </button>
</li>

<!-- Modal Konfirmasi -->
<div class="modal fade" id="logoutModal" tabindex="-1" aria-labelledby="logoutModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header bg-danger text-white">
        <h5 class="modal-title" id="logoutModalLabel">Konfirmasi Logout</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        Apakah Anda yakin ingin keluar?
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
        <a href="<?= site_url('auth/logout'); ?>" class="btn btn-danger">Keluar</a>
      </div>
    </div>
  </div>
</div>
      </ul>
    </div>
  </div>
</nav>

<!-- Konten
<div class="container py-4">
    <h2 class="fw-bold">Selamat Datang di Dashboard 🎉</h2>
    <p class="text-muted">Silakan gunakan menu di atas untuk mengakses data pendaftaran.</p>
</div> -->

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>