<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title><?= isset($title) ? $title : 'Admin Panel'; ?></title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

  <style>
    body {
      min-height: 100vh;
      display: flex;
      flex-direction: row;
      transition: background 0.3s, color 0.3s;
    }
    .sidebar {
      width: 240px;
      background-color: #1e1e2d;
      color: #fff;
      min-height: 100vh;
      position: fixed;
      left: 0;
      top: 0;
      padding-top: 20px;
      transition: background 0.3s, color 0.3s;
    }
    .sidebar a {
      color: #bbb;
      text-decoration: none;
      display: block;
      padding: 12px 20px;
      transition: background 0.3s, color 0.3s;
    }
    .sidebar a:hover, .sidebar a.active {
      background: #343a40;
      color: #fff;
    }
    .content {
      margin-left: 240px;
      padding: 20px;
      flex: 1;
      background: #f5f6fa;
      transition: background 0.3s, color 0.3s;
    }
    .topbar {
      background: #fff;
      border-radius: 10px;
      padding: 12px 20px;
      margin-bottom: 20px;
      display: flex;
      justify-content: space-between;
      align-items: center;
      box-shadow: 0 2px 5px rgba(0,0,0,0.1);
      transition: background 0.3s, color 0.3s;
    }

    /* DARK MODE */
    body.dark-mode {
      background: #181a1b !important;
      color: #eee !important;
    }
    body.dark-mode .content {
      background: #212529 !important;
      color: #fff !important;
    }
    body.dark-mode .topbar {
      background: #2c2f33 !important;
      color: #fff !important;
    }
    body.dark-mode .card {
      background: #2c2f33 !important;
      color: #fff !important;
    }
    body.dark-mode .table {
      color: #fff !important;
    }
    body.dark-mode .table thead {
      background: #333 !important;
    }
    body.dark-mode .sidebar {
      background: #1f1f1f !important;
    }
    body.dark-mode .sidebar a {
      color: #ccc;
    }
    body.dark-mode .sidebar a:hover, 
    body.dark-mode .sidebar a.active {
      background: #444 !important;
      color: #fff !important;
    }
  </style>
</head>
<body>

  <!-- Sidebar -->
  <div class="sidebar">
    <h4 class="px-3 mb-4">Admin Panel</h4>
    <a href="<?= base_url('admin/dashboard'); ?>" class="active"><i class="fa fa-home me-2"></i> Dashboard</a>
    <a href="<?= base_url('admin/users'); ?>"><i class="fa fa-users me-2"></i> Kelola User</a>
    <a href="<?= base_url('admin/data_seni'); ?>"><i class="fa fa-palette me-2"></i> Data Seni</a>
    <a href="<?= base_url('admin/settings'); ?>"><i class="fa fa-cog me-2"></i> Pengaturan</a>
    <a href="<?= base_url('auth/logout'); ?>" class="text-danger"><i class="fa fa-sign-out-alt me-2"></i> Logout</a>
  </div>

  <!-- Content -->
  <div class="content">

    <!-- Topbar -->
    <div class="topbar">
      <h5 class="mb-0 fw-bold"><?= isset($title) ? $title : 'Dashboard '; ?></h5>
      <div>
        <span class="me-3">👋 Hai, <b><?= isset($username) ? $username : 'Admin'; ?></b></span>
        <button class="btn btn-sm btn-outline-dark" id="toggle-dark">🌙 Mode Gelap</button>
      </div>
    </div>

    <!-- Dark Mode Script -->
    <script>
      document.addEventListener("DOMContentLoaded", function () {
        const toggleBtn = document.getElementById("toggle-dark");
        const body = document.body;

        // Cek preferensi dark mode dari localStorage
        if(localStorage.getItem("dark-mode") === "enabled") {
          body.classList.add("dark-mode");
        }

        toggleBtn.addEventListener("click", function() {
          body.classList.toggle("dark-mode");

          if(body.classList.contains("dark-mode")) {
            localStorage.setItem("dark-mode", "enabled");
          } else {
            localStorage.removeItem("dark-mode");
          }
        });
      });
    </script>