<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Tambah Seni Sanggar</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container mt-5">
    <div class="card shadow-lg border-0 rounded-4">
        <div class="card-header bg-success text-white text-center">
            <h4 class="mb-0">➕ Tambah Seni untuk Sanggar: <?= htmlspecialchars($sanggar->nama_sanggar) ?></h4>
        </div>
        <div class="card-body p-4">
            <form method="post">
                <div class="mb-3">
                    <label for="id_seni" class="form-label fw-bold">Pilih Seni</label>
                    <select name="id_seni" id="id_seni" class="form-select" required>
                        <option value="">Pilih salah satu...</option>
                        <?php foreach ($jenis_seni as $seni): ?>
                            <option value="<?= $seni['id_seni'] ?>">
                                <?= htmlspecialchars($seni['nama_seni']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="mb-3">
                    <label for="deskripsi_global" class="form-label fw-bold">Deskripsi Seni (opsional)</label>
                    <textarea name="deskripsi_global" id="deskripsi_global" rows="3" class="form-control"></textarea>
                </div>

                <div class="d-flex gap-2 mt-3">
                    <button type="submit" class="btn btn-success flex-fill">💾 Simpan</button>
                    <a href="<?= site_url('pendaftaran/biodata') ?>" class="btn btn-secondary flex-fill">❌ Batal</a>
                </div>
            </form>
        </div>
    </div>
</div>

</body>
</html>