<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tambah Seni | Perorangan</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #6c5ce7, #8e44ad);
            --secondary-gradient-new: linear-gradient(135deg, #a4b0be, #747d8c); 
            --bg-color: #eef2f7;
            --card-bg: #ffffff;
            --text-color-dark: #2c3e50;
            --text-color-light: #f4f6f9;
            --border-radius-main: 2rem;
            --border-radius-item: 0.75rem;
            --shadow-light: 0 15px 35px rgba(0, 0, 0, 0.08);
            --shadow-hover: 0 20px 45px rgba(0, 0, 0, 0.15);
        }

        body {
            font-family: 'Poppins', sans-serif;
            background-color: var(--bg-color);
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            padding: 2rem;
            color: var(--text-color-dark);
            transition: background-color 0.5s ease;
        }

        .card-container {
            width: 100%;
            max-width: 550px;
            background: var(--card-bg);
            padding: 2.5rem;
            border-radius: var(--border-radius-main);
            box-shadow: var(--shadow-light);
            animation: slideInUp 0.8s cubic-bezier(0.25, 0.46, 0.45, 0.94);
            border: 1px solid #e0e0e0;
        }

        @keyframes slideInUp {
            from { opacity: 0; transform: translateY(40px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .header-section {
            text-align: center;
            margin-bottom: 2rem;
        }

        .header-icon {
            font-size: 2rem;
            color: #6c5ce7;
            margin-bottom: 0.5rem;
            animation: bounceIn 1s ease-in-out;
        }

        @keyframes bounceIn {
            0%, 20%, 50%, 80%, 100% {
                transform: translateY(0);
            }
            40% {
                transform: translateY(-10px);
            }
            60% {
                transform: translateY(-5px);
            }
        }

        .header-title {
            font-weight: 700;
            font-size: 1.75rem;
            color: var(--text-color-dark);
            margin-bottom: 0.5rem;
        }

        .subtitle {
            font-size: 1rem;
            color: #7f8c8d;
            font-weight: 400;
        }

        .form-content {
            padding: 2rem;
            border: 1px solid #dcdde1;
            border-radius: var(--border-radius-item);
            background-color: #fafbfd;
        }

        .form-group {
            margin-bottom: 2rem;
        }

        .form-label {
            font-weight: 600;
            color: #555;
            margin-bottom: 0.75rem;
            display: block;
        }

        .form-select {
            width: 100%;
            padding: 1rem 1.25rem;
            border: 2px solid #e9ecef;
            border-radius: 1rem;
            font-size: 1rem;
            background-color: var(--card-bg);
            box-shadow: inset 0 1px 3px rgba(0, 0, 0, 0.05);
            transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
        }

        .form-select:focus {
            outline: none;
            border-color: #a29bfe;
            box-shadow: 0 0 0 4px rgba(108, 92, 231, 0.1);
        }
        
        .form-select option {
            padding: 10px;
        }

        .btn-action {
            width: 100%;
            padding: 1rem;
            border: none;
            border-radius: 1rem;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            display: flex;
            justify-content: center;
            align-items: center;
            gap: 10px;
            transition: all 0.3s cubic-bezier(0.25, 0.46, 0.45, 0.94);
            text-decoration: none; /* Menghilangkan garis bawah pada link */
        }

        .btn-primary {
            background: var(--primary-gradient);
            color: var(--text-color-light);
            box-shadow: 0 8px 20px rgba(108, 92, 231, 0.3);
        }

        .btn-primary:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 25px rgba(108, 92, 231, 0.4);
        }

        .btn-secondary {
            background: var(--secondary-gradient-new);
            color: var(--text-color-light);
            box-shadow: 0 8px 20px rgba(164, 176, 190, 0.3);
        }

        .btn-secondary:hover {
            transform: translateY(-5px);
            box-shadow: 0 12px 25px rgba(164, 176, 190, 0.4);
        }

        .form-buttons {
            display: flex;
            flex-direction: column;
            gap: 1.5rem;
            margin-top: 2rem;
            align-items: center; /* Perbaikan: Memusatkan item secara vertikal */
        }

        .alert-custom {
            padding: 1rem 1.5rem;
            border-radius: var(--border-radius-item);
            font-weight: 500;
            margin-bottom: 2rem;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            animation: slideIn 0.5s ease-out;
        }
        .alert-success-custom { background-color: #d4edda; color: #155724; }
        .alert-danger-custom { background-color: #f8d7da; color: #721c24; }
    </style>
</head>
<body>
    <div class="card-container">
        <div class="header-section">
            <div class="header-icon"><i class="fas fa-palette"></i></div>
            <h2 class="header-title">Tambah Seni Perorangan</h2>
            <p class="subtitle">Pilih jenis seni yang sesuai dengan keahlian Anda.</p>
        </div>

        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert-custom alert-danger-custom"><?= $this->session->flashdata('error'); ?></div>
        <?php endif; ?>
        <?php if ($this->session->flashdata('success')): ?>
            <div class="alert-custom alert-success-custom"><?= $this->session->flashdata('success'); ?></div>
        <?php endif; ?>

        <div class="form-content">
            <form action="<?= site_url('pendaftaran/simpan_seni_perorangan'); ?>" method="post">
                <input type="hidden" name="id_sdm" value="<?= htmlspecialchars($pendaftar->id_sdm); ?>">

                <div class="form-group">
                    <label for="id_seni" class="form-label">Jenis Seni</label>
                    <select class="form-select" id="id_seni" name="id_seni" required>
                        <option value="">Pilih Jenis Seni</option>
                        <?php foreach($jenis_seni as $seni): ?>
                            <option value="<?= isset($seni->id_seni) ? $seni->id_seni : $seni['id_seni']; ?>">
                                <?= isset($seni->nama_seni) ? htmlspecialchars($seni->nama_seni) : htmlspecialchars($seni['nama_seni']); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-buttons">
                    <button type="submit" class="btn-action btn-primary">
                        <i class="fas fa-save"></i> Simpan
                    </button>
                    <a href="<?= site_url('pendaftaran/biodata'); ?>" class="btn-action btn-secondary">
                        <i class="fas fa-arrow-left"></i> Kembali
                    </a>
                </div>
            </form>
        </div>
    </div>
</body>
</html>