<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Form Pendaftaran Lembaga</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f4f7f9;
        }
        .card {
            border-radius: 1rem;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            border: none;
        }
        .card-header-custom {
            background-image: linear-gradient(45deg, #00b09b, #96c93d);
            padding: 1.5rem 2rem;
            font-weight: 700;
            color: #fff;
            border-top-left-radius: 1rem;
            border-top-right-radius: 1rem;
        }
        .btn-success {
            background-color: #00b09b;
            border-color: #00b09b;
        }
        .btn-success:hover {
            background-color: #008f7b;
            border-color: #008f7b;
        }
        .btn-secondary {
            background-color: #6c757d;
            border-color: #6c757d;
        }
        .btn-secondary:hover {
            background-color: #5a6268;
            border-color: #5a6268;
        }
        .form-control, .form-select {
            border-radius: 0.5rem;
        }
        h5.form-section-title {
            padding: 1rem 0;
            margin-top: 2rem;
            border-bottom: 2px solid #e9ecef;
        }
    </style>
</head>
<body class="bg-light">

<div class="container mt-5 mb-5">
    <div class="card shadow-lg border-0 rounded-4">
        <div class="card-header card-header-custom text-white text-center rounded-top-4">
            <h4 class="mb-0">➕ Tambah Pengurus Sanggar</h4>
        </div>
        <div class="card-body p-4">

            <?php if ($this->session->flashdata('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?= $this->session->flashdata('error') ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if ($this->session->flashdata('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?= $this->session->flashdata('success') ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <form method="post" action="<?= site_url('pendaftaran/tambah_pengurus/'.$sanggar->id_sanggar) ?>">
                <h5 class="form-section-title fw-bold text-primary">Data Personal</h5>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="nik" class="form-label fw-bold">NIK *</label>
                        <input type="text" id="nik" name="nik" class="form-control rounded-3" required>
                    </div>
                    <div class="col-md-6">
                        <label for="nama_lengkap" class="form-label fw-bold">Nama Lengkap *</label>
                        <input type="text" id="nama_lengkap" name="nama_lengkap" class="form-control rounded-3" required>
                    </div>
                    <div class="col-md-6">
                        <label for="gelar_pendidikan" class="form-label fw-bold">Gelar Pendidikan</label>
                        <input type="text" id="gelar_pendidikan" name="gelar_pendidikan" class="form-control rounded-3">
                    </div>
                    <div class="col-md-6">
                        <label for="jenis_kelamin" class="form-label fw-bold">Jenis Kelamin</label>
                        <select id="jenis_kelamin" name="jenis_kelamin" class="form-select rounded-3">
                            <option value="">Pilih Jenis Kelamin</option>
                            <option value="L">Laki-laki</option>
                            <option value="P">Perempuan</option>
                        </select>
                    </div>
                </div>

                <div class="row g-3 mt-3">
                    <div class="col-md-4">
                        <label for="tempat_lahir" class="form-label fw-bold">Tempat Lahir</label>
                        <input type="text" id="tempat_lahir" name="tempat_lahir" class="form-control rounded-3">
                    </div>
                    <div class="col-md-4">
                        <label for="tanggal_lahir" class="form-label fw-bold">Tanggal Lahir</label>
                        <input type="date" id="tanggal_lahir" name="tanggal_lahir" class="form-control rounded-3">
                    </div>
                    <div class="col-md-4">
                        <label for="kewarganegaraan" class="form-label fw-bold">Kewarganegaraan</label>
                        <select id="kewarganegaraan" name="kewarganegaraan" class="form-select rounded-3">
                            <option value="">Pilih Kewarganegaraan</option>
                            <option value="WNI">Warga Negara Indonesia</option>
                            <option value="WNA">Warga Negara Asing</option>
                        </select>
                    </div>
                </div>

                <div class="row g-3 mt-3">
                    <div class="col-md-6">
                        <label for="agama" class="form-label fw-bold">Agama</label>
                        <select id="agama" name="agama" class="form-select rounded-3">
                            <option value="">Pilih Agama</option>
                            <option value="Islam">Islam</option>
                            <option value="Kristen">Kristen</option>
                            <option value="Katolik">Katolik</option>
                            <option value="Hindu">Hindu</option>
                            <option value="Buddha">Buddha</option>
                            <option value="Konghucu">Konghucu</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label for="nama_peran" class="form-label fw-bold">Peran</label>
                        <select id="nama_peran" name="nama_peran" class="form-select rounded-3" required>
                            <option value="">Pilih Peran</option>
                            <option value="Ketua">Ketua</option>
                            <option value="Wakil Ketua">Wakil Ketua</option>
                            <option value="Sekretaris">Sekretaris</option>
                            <option value="Bendahara">Bendahara</option>
                            <option value="Pelatih">Pelatih</option>
                            <option value="Wakil Pelatih">Wakil Pelatih</option>
                        </select>
                    </div>
                </div>

                <div class="d-flex gap-2 mt-4">
                    <button type="submit" class="btn btn-success flex-fill fw-bold rounded-3">💾 Simpan</button>
                    <a href="<?= site_url('pendaftaran/biodata') ?>" class="btn btn-secondary flex-fill fw-bold rounded-3">❌ Batal</a>
                </div>
            </form>

        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>