<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Tambah Anggota Kelompok</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <style>
        .form-hidden {
            display: none;
        }
        .card-header-custom {
            background-image: linear-gradient(45deg, #ef476f, #ffd166);
            padding: 1.5rem 2rem;
            font-weight: 700;
            color: #fff;
            border-top-left-radius: 1rem;
            border-top-right-radius: 1rem;
        }
        .card {
            border-radius: 1rem;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            border: none;
        }
        .btn-success {
            background-color: #00b09b;
            border-color: #00b09b;
        }
        .btn-success:hover {
            background-color: #008f7b;
            border-color: #008f7b;
        }
        .btn-secondary {
            background-color: #6c757d;
            border-color: #6c757d;
        }
        .btn-secondary:hover {
            background-color: #5a6268;
            border-color: #5a6268;
        }
        .form-control, .form-select {
            border-radius: 0.5rem;
        }
    </style>
</head>
<body class="bg-light">

<div class="container mt-5 mb-5">
    <div class="card shadow-lg border-0 rounded-4">
        <div class="card-header card-header-custom text-white text-center rounded-top-4">
            <h4 class="mb-0">➕ Tambah Anggota Kelompok</h4>
        </div>
        <div class="card-body p-4">

            <?php if ($this->session->flashdata('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?= $this->session->flashdata('error') ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if ($this->session->flashdata('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?= $this->session->flashdata('success') ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <div class="mb-3">
                <label class="form-label fw-bold">Pilihan Tambah Anggota:</label>
                <div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="radio" name="cara_tambah" id="input_manual" value="manual" checked>
                        <label class="form-check-label" for="input_manual">Input Manual</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="radio" name="cara_tambah" id="cari_nik" value="cari">
                        <label class="form-check-label" for="cari_nik">Cari NIK Terdaftar</label>
                    </div>
                </div>
            </div>

            <form id="form_manual_submit" method="post" action="<?= site_url('pendaftaran/tambah_anggota/'.$sanggar->id_sanggar) ?>">
                <div id="form_manual">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label fw-bold">NIK</label>
                            <input type="text" name="nik" id="manual_nik" class="form-control rounded-3" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold">Nama Anggota</label>
                            <input type="text" name="nama_anggota" id="manual_nama_anggota" class="form-control rounded-3" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold">Jenis Kelamin</label>
                            <select name="jenis_kelamin" id="manual_jk" class="form-select rounded-3" required>
                                <option value="">Pilih Jenis Kelamin</option>
                                <option value="L">Laki-laki</option>
                                <option value="P">Perempuan</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold">Nomor HP</label>
                            <input type="text" name="nomor_hp" id="manual_no_hp" class="form-control rounded-3">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold">Tempat Lahir</label>
                            <input type="text" name="tempat_lahir" id="manual_tempat_lahir" class="form-control rounded-3">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label fw-bold">Tanggal Lahir</label>
                            <input type="date" name="tanggal_lahir" id="manual_tanggal_lahir" class="form-control rounded-3">
                        </div>
                        <div class="form-group">
                            <label>Kewarganegaraan</label>
                            <select id="anggota_kewarganegaraan_input" class="form-select">
                                <option value="">Pilih Kewarganegaraan</option>
                                <option value="WNI">Warga Negara Indonesia</option>
                                <option value="WNA">Warga Negara Asing</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label>Agama</label>
                            <select id="anggota_agama_input" class="form-select">
                                <option value="">Pilih Agama</option>
                                <option value="Islam">Islam</option>
                                <option value="Kristen">Kristen</option>
                                <option value="Katolik">Katolik</option>
                                <option value="Hindu">Hindu</option>
                                <option value="Buddha">Buddha</option>
                                <option value="Konghucu">Konghucu</option>
                            </select>
                        </div>
                        <div class="col-md-12">
                            <label class="form-label fw-bold">Level</label>
                            <select name="id_level" id="manual_level" class="form-select rounded-3" required>
                                <option value="">Pilih Level</option>
                                <?php foreach ($master_level as $level): ?>
                                    <option value="<?= $level->id_level ?>"><?= htmlspecialchars($level->nama_level) ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="d-flex gap-2 mt-4">
                    <button type="submit" class="btn btn-success flex-fill fw-bold rounded-3">
                        💾 Simpan Anggota
                    </button>
                    <a href="<?= site_url('pendaftaran/biodata') ?>" class="btn btn-secondary flex-fill fw-bold rounded-3">
                        ❌ Batal
                    </a>
                </div>
            </form>

            <form id="form_cari_submit" class="form-hidden" method="post" action="<?= site_url('pendaftaran/tambah_anggota_dari_pencarian/'.$sanggar->id_sanggar) ?>">
                <div id="form_cari">
                    <div class="mb-3">
                        <label class="form-label fw-bold">Cari Berdasarkan NIK</label>
                        <div class="input-group">
                            <input type="text" id="input_cari_nik" class="form-control rounded-start" placeholder="Masukkan NIK">
                            <button type="button" class="btn btn-primary" onclick="cariAnggota()">Cari</button>
                        </div>
                    </div>
                    <div id="hasil_pencarian" class="mt-3"></div>
                </div>
                <div class="d-flex gap-2 mt-4">
                    <input type="hidden" name="nik" id="nik_cari_hidden">
                    <input type="hidden" name="id_level" id="level_cari_hidden" value="1">
                    <button type="submit" id="simpan_cari_btn" class="btn btn-success flex-fill fw-bold rounded-3" disabled>
                        💾 Simpan Anggota
                    </button>
                    <a href="<?= site_url('pendaftaran/biodata') ?>" class="btn btn-secondary flex-fill fw-bold rounded-3">
                        ❌ Batal
                    </a>
                </div>
            </form>

        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const radioManual = document.getElementById('input_manual');
        const radioCari = document.getElementById('cari_nik');
        const formManual = document.getElementById('form_manual_submit');
        const formCari = document.getElementById('form_cari_submit');

        // Sembunyikan form cari saat pertama kali dimuat
        formCari.classList.add('form-hidden');

        // Atur event listener untuk radio button
        radioManual.addEventListener('change', function() {
            formManual.classList.remove('form-hidden');
            formCari.classList.add('form-hidden');
        });

        radioCari.addEventListener('change', function() {
            formCari.classList.remove('form-hidden');
            formManual.classList.add('form-hidden');
        });
    });

    function cariAnggota() {
        const nik = document.getElementById('input_cari_nik').value;
        
        if (nik.trim().length !== 16 || isNaN(nik)) {
            alert("NIK harus 16 digit angka.");
            return;
        }
        
        document.getElementById('simpan_cari_btn').disabled = true;

        fetch('<?= site_url("pendaftaran/cari_anggota_by_nik") ?>/' + nik)
            .then(response => response.json())
            .then(data => {
                const hasilDiv = document.getElementById('hasil_pencarian');
                if (data.status === 'success') {
                    // Masukkan NIK ke input tersembunyi
                    document.getElementById('nik_cari_hidden').value = data.anggota.nik;
                    
                    // Tambahkan input tersembunyi untuk data anggota lainnya
                    hasilDiv.innerHTML = `
                        <div class="alert alert-success">NIK ditemukan! Data akan ditambahkan sebagai anggota dengan Level Pemula.</div>
                        <p class="mb-1"><strong>Nama:</strong> ${data.anggota.nama_anggota}</p>
                        <p class="mb-1"><strong>Jenis Kelamin:</strong> ${data.anggota.jenis_kelamin === 'L' ? 'Laki-laki' : 'Perempuan'}</p>
                        <p class="mb-1"><strong>Tempat, Tanggal Lahir:</strong> ${data.anggota.tempat_lahir}, ${data.anggota.tanggal_lahir}</p>
                        <p class="mb-1"><strong>No HP:</strong> ${data.anggota.nomor_hp}</p>
                        <input type="hidden" name="nama_anggota" value="${data.anggota.nama_anggota}">
                        <input type="hidden" name="jenis_kelamin" value="${data.anggota.jenis_kelamin}">
                        <input type="hidden" name="tempat_lahir" value="${data.anggota.tempat_lahir}">
                        <input type="hidden" name="tanggal_lahir" value="${data.anggota.tanggal_lahir}">
                        <input type="hidden" name="kewarganegaraan" value="${data.anggota.kewarganegaraan}">
                        <input type="hidden" name="agama" value="${data.anggota.agama}">
                        <input type="hidden" name="nomor_hp" value="${data.anggota.nomor_hp}">
                    `;
                    document.getElementById('simpan_cari_btn').disabled = false;
                } else {
                    hasilDiv.innerHTML = `<div class="alert alert-danger">${data.message}</div>`;
                    document.getElementById('nik_cari_hidden').value = '';
                }
            })
            .catch(error => {
                console.error('Error:', error);
                hasilDiv.innerHTML = `<div class="alert alert-danger">Terjadi kesalahan saat mencari NIK.</div>`;
            });
    }
</script>
</body>
</html>