<?php $this->load->view('templates/header_user'); ?>

<style>
    /* Global Styles */
    body {
        background-color: #f0f2f5;
        font-family: 'Poppins', sans-serif;
    }

    /* Main Container */
    .profile-container {
        max-width: 800px;
        margin: auto;
    }

    /* Header */
    .profile-header {
        text-align: center;
        margin-bottom: 2rem;
        color: #343a40;
    }

    /* Card */
    .main-card {
        background-color: #fff;
        border-radius: 20px;
        box-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        padding: 40px;
        position: relative;
    }

    /* Card Header with Gradient */
    .card-header-colorful {
        background: linear-gradient(45deg, #5A7EFC, #8a63f1);
        color: #fff;
        border-radius: 20px 20px 0 0;
        padding: 20px 25px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-weight: 600;
        font-size: 1.25rem;
        box-shadow: 0 5px 15px rgba(90, 126, 252, 0.3);
        margin: -40px -40px 20px -40px; /* Offset to cover the card padding */
    }

    .card-header-colorful i {
        font-size: 1.5rem;
    }
    
    .info-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }
    
    .info-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 15px 0;
        border-bottom: 1px solid #e9ecef;
    }
    
    .info-item:last-child {
        border-bottom: none;
    }
    
    .info-label {
        font-weight: 500;
        color: #6c757d;
        flex: 1;
    }
    
    .info-value {
        font-weight: 600;
        color: #343a40;
        text-align: right;
        flex: 2;
    }

</style>

<div class="container py-5 profile-container">
    <div class="profile-header">
        <h2 class="fw-bold">Profile User 🎉</h2>
        <p class="text-muted">Selamat datang di dashboard Anda. Berikut adalah ringkasan data profil Anda.</p>
    </div>

    <?php if ($user): ?>
        <div class="main-card">
            <div class="card-header-colorful">
                <i class="fas fa-user-circle me-3"></i> Data User
            </div>
            
            <div class="info-list">
                <?php if ($user->nik): ?>
                    <div class="info-item">
                        <span class="info-label">NIK</span>
                        <span class="info-value"><?= htmlspecialchars($user->nik); ?></span>
                    </div>
                <?php endif; ?>
                
                <?php if ($user->email): ?>
                    <div class="info-item">
                        <span class="info-label">Email</span>
                        <span class="info-value"><?= htmlspecialchars($user->email); ?></span>
                    </div>
                <?php endif; ?>
                
                <div class="info-item">
                    <span class="info-label">Nama Lengkap</span>
                    <span class="info-value"><?= htmlspecialchars($user->nama_lengkap); ?></span>
                </div>
                
                <div class="info-item">
                    <span class="info-label">Role</span>
                    <span class="info-value">
                        <?php if ($user->id_role == 1): ?>
                            Admin
                        <?php elseif ($user->id_role == 2): ?>
                            Perorangan
                        <?php else: ?>
                            Kelompok
                        <?php endif; ?>
                    </span>
                </div>
                
                <div class="info-item">
                    <span class="info-label">Tanggal Daftar</span>
                    <span class="info-value"><?= date('d-m-Y H:i', strtotime($user->created_at)); ?></span>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="alert alert-danger text-center main-card">Data user tidak ditemukan.</div>
    <?php endif; ?>
</div>

<?php $this->load->view('templates/footer_user'); ?>