<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pendaftaran Tenaga Budaya Perorangan</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        .card-header {
            font-weight: bold;
            background-color: #f7f7f7;
        }
        .required-label::after {
            content: "*";
            color: red;
            margin-left: 4px;
        }
        .form-label {
            font-weight: 500;
        }
    </style>
</head>
<body>

<div class="container-xl mt-5 mb-5">
    <div class="row">
        <div class="col-md-12">

            <?php if ($this->session->flashdata('error')): ?>
                <div class="alert alert-danger" role="alert">
                    <?php echo $this->session->flashdata('error'); ?>
                </div>
            <?php endif; ?>

            <?php echo form_open_multipart('pendaftaran/submit_perorangan', ['id' => 'form-perorangan']); ?>

            <div class="card shadow-sm mb-4">
                <div class="card-header">
                    Identitas Tenaga Budaya
                </div>
                <div class="card-body">
                    <div class="form-row">
                        <div class="form-group col-md-4 mb-3">
                            <label for="nama_lengkap" class="form-label required-label">Nama Lengkap (Tanpa Gelar)</label>
                            <input type="text" class="form-control" id="nama_lengkap" name="nama_lengkap" placeholder="Nama Lengkap (Tanpa Gelar)" value="<?php echo set_value('nama_lengkap'); ?>" required>
                        </div>
                        <div class="form-group col-md-4 mb-3">
                            <label for="gelar_pendidikan" class="form-label">Gelar Pendidikan</label>
                            <input type="text" class="form-control" id="gelar_pendidikan" name="gelar_pendidikan" placeholder="Gelar Pendidikan" value="<?php echo set_value('gelar_pendidikan'); ?>">
                        </div>
                        <div class="form-group col-md-4 mb-3">
                            <label for="nama_alias" class="form-label">Nama Alias</label>
                            <input type="text" class="form-control" id="nama_alias" name="nama_alias" placeholder="Nama Alias" value="<?php echo set_value('nama_alias'); ?>">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-4 mb-3">
                            <label for="jenis_identitas" class="form-label required-label">Jenis Identitas</label>
                            <select id="jenis_identitas" name="jenis_identitas" class="form-control" required>
                                <option value="">Pilih Jenis Identitas</option>
                                <option value="KTP" <?php echo set_select('jenis_identitas', 'KTP'); ?>>KTP</option>
                                <option value="SIM" <?php echo set_select('jenis_identitas', 'SIM'); ?>>SIM</option>
                                <option value="Paspor" <?php echo set_select('jenis_identitas', 'Paspor'); ?>>Paspor</option>
                            </select>
                        </div>
                        <div class="form-group col-md-4 mb-3">
                            <label for="nik" class="form-label required-label">NIK (Nomor Induk Kependudukan)</label>
                            <input type="text" class="form-control" id="nik" name="nik" placeholder="NIK" value="<?php echo set_value('nik'); ?>" required>
                        </div>
                        <div class="form-group col-md-4 mb-3">
                            <label for="tempat_lahir" class="form-label required-label">Tempat Lahir</label>
                            <input type="text" class="form-control" id="tempat_lahir" name="tempat_lahir" placeholder="Tempat Lahir" value="<?php echo set_value('tempat_lahir'); ?>" required>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label for="tanggal_lahir" class="form-label required-label">Tanggal Lahir</label>
                            <input type="date" class="form-control" id="tanggal_lahir" name="tanggal_lahir" value="<?php echo set_value('tanggal_lahir'); ?>" required>
                        </div>
                        <div class="form-group col-md-4">
                            <label for="jenis_kelamin" class="form-label required-label">Jenis Kelamin</label>
                            <select id="jenis_kelamin" name="jenis_kelamin" class="form-control" required>
                                <option value="">Pilih Jenis Kelamin</option>
                                <option value="L" <?php echo set_select('jenis_kelamin', 'L'); ?>>Laki-laki</option>
                                <option value="P" <?php echo set_select('jenis_kelamin', 'P'); ?>>Perempuan</option>
                            </select>
                        </div>
                        <div class="form-group col-md-4">
                            <label for="agama" class="form-label required-label">Agama</label>
                            <select id="agama" name="agama" class="form-control" required>
                                <option value="">Pilih Agama</option>
                                <option value="Islam" <?php echo set_select('agama', 'Islam'); ?>>Islam</option>
                                <option value="Kristen" <?php echo set_select('agama', 'Kristen'); ?>>Kristen</option>
                                <option value="Katolik" <?php echo set_select('agama', 'Katolik'); ?>>Katolik</option>
                                <option value="Hindu" <?php echo set_select('agama', 'Hindu'); ?>>Hindu</option>
                                <option value="Buddha" <?php echo set_select('agama', 'Buddha'); ?>>Buddha</option>
                                <option value="Konghucu" <?php echo set_select('agama', 'Konghucu'); ?>>Konghucu</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-4 mb-3">
                            <label for="kewarganegaraan" class="form-label required-label">Kewarganegaraan</label>
                            <select id="kewarganegaraan" name="kewarganegaraan" class="form-control" required>
                                <option value="">Pilih Kewarganegaraan</option>
                                <option value="WNI" <?php echo set_select('kewarganegaraan', 'WNI'); ?>>Warga Negara Indonesia</option>
                                <option value="WNA" <?php echo set_select('kewarganegaraan', 'WNA'); ?>>Warga Negara Asing</option>
                            </select>
                        </div>
                        <div class="form-group col-md-4 mb-3">
                            <label for="nama_ayah" class="form-label">Nama Ayah</label>
                            <input type="text" class="form-control" id="nama_ayah" name="nama_ayah" placeholder="Nama Ayah" value="<?php echo set_value('nama_ayah'); ?>">
                        </div>
                        <div class="form-group col-md-4 mb-3">
                            <label for="nama_ibu" class="form-label">Nama Ibu</label>
                            <input type="text" class="form-control" id="nama_ibu" name="nama_ibu" placeholder="Nama Ibu" value="<?php echo set_value('nama_ibu'); ?>">
                        </div>
                    </div>
                    <div class="form-group col-md-4 mb-3">
    <label class="form-label required-label d-block">Jenis Seni</label>
    <div class="form-check">
        <?php foreach ($jenis_seni as $row): ?>
            <input class="form-check-input" type="checkbox" name="jenis_seni[]" id="seni-<?= $row['id_seni'] ?>" value="<?= $row['id_seni'] ?>">
            <label class="form-check-label" for="seni-<?= $row['id_seni'] ?>">
                <?= $row['nama_seni'] ?>
            </label>
            <br>
        <?php endforeach; ?>
    </div>
</div>
                </div>
            </div>

            <div class="card shadow-sm mb-4">
                <div class="card-header">
                    Media Foto
                </div>
                <div class="card-body">
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="foto_identitas" class="form-label required-label">Foto Kartu Identitas</label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="foto_identitas" name="foto_identitas" required>
                                <label class="custom-file-label" for="foto_identitas">Pilih file</label>
                            </div>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="pas_foto" class="form-label">Pas Foto</label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" id="pas_foto" name="pas_foto">
                                <label class="custom-file-label" for="pas_foto">Pilih file</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card shadow-sm mb-4">
                <div class="card-header">
                    Alamat
                </div>
                <div class="card-body">
                    <div class="form-row">
                        <div class="form-group col-md-3">
                            <label for="provinsi" class="form-label required-label">Provinsi</label>
                            <input type="text" class="form-control" id="provinsi" name="provinsi" placeholder="Pilih Provinsi" value="<?php echo set_value('provinsi'); ?>" required>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="kabupaten" class="form-label required-label">Kabupaten / Kota</label>
                            <input type="text" class="form-control" id="kabupaten" name="kabupaten" placeholder="Pilih Kabupaten / Kota" value="<?php echo set_value('kabupaten'); ?>" required>
                        </div>
                        <div class="form-group col-md-3">
                            <label for="kecamatan" class="form-label">Kecamatan</label>
                            <input type="text" class="form-control" id="kecamatan" name="kecamatan" placeholder="Pilih Kecamatan" value="<?php echo set_value('kecamatan'); ?>">
                        </div>
                        <div class="form-group col-md-3">
                            <label for="desa" class="form-label">Desa / Kelurahan</label>
                            <input type="text" class="form-control" id="desa" name="desa" placeholder="Pilih Desa / Kelurahan" value="<?php echo set_value('desa'); ?>">
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="alamat" class="form-label">Alamat</label>
                        <textarea class="form-control" id="alamat" name="alamat" rows="3" placeholder="Alamat"><?php echo set_value('alamat'); ?></textarea>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="latitude" class="form-label">Latitude</label>
                            <input type="text" class="form-control" id="latitude" name="latitude" value="0">
                        </div>
                        <div class="form-group col-md-6">
                            <label for="longitude" class="form-label">Longitude</label>
                            <input type="text" class="form-control" id="longitude" name="longitude" value="0">
                        </div>
                    </div>
                </div>
            </div>

            <div class="card shadow-sm mb-4">
                <div class="card-header">
                    Kontak
                </div>
                <div class="card-body">
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="no_hp" class="form-label required-label">Nomor HP (Min 7, Max 15)</label>
                            <input type="text" class="form-control" id="no_hp" name="no_hp" placeholder="Nomor HP" value="<?php echo set_value('no_hp'); ?>" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="email" class="form-label">Alamat Email</label>
                            <input type="email" class="form-control" id="email" name="email" placeholder="Alamat Email" value="<?php echo set_value('email'); ?>">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="facebook" class="form-label">Akun Facebook</label>
                            <input type="text" class="form-control" id="facebook" name="facebook" placeholder="Akun Facebook" value="<?php echo set_value('facebook'); ?>">
                        </div>
                        <div class="form-group col-md-6">
                            <label for="youtube" class="form-label">Akun Youtube</label>
                            <input type="text" class="form-control" id="youtube" name="youtube" placeholder="Akun Youtube" value="<?php echo set_value('youtube'); ?>">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="website" class="form-label">Alamat Website</label>
                            <input type="text" class="form-control" id="website" name="website" placeholder="Alamat Website" value="<?php echo set_value('website'); ?>">
                        </div>
                        <div class="form-group col-md-6">
                            <label for="twitter" class="form-label">Akun Twitter</label>
                            <input type="text" class="form-control" id="twitter" name="twitter" placeholder="Akun Twitter" value="<?php echo set_value('twitter'); ?>">
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="instagram" class="form-label">Akun Instagram</label>
                        <input type="text" class="form-control" id="instagram" name="instagram" placeholder="Akun Instagram" value="<?php echo set_value('instagram'); ?>">
                    </div>
                </div>
            </div>

            <div id="riwayat-container">
                <div class="card shadow-sm mb-4">
                    <div class="card-header">
                        Riwayat Pendidikan
                        <button type="button" class="btn btn-sm btn-success float-right tambah-riwayat" data-riwayat="pendidikan">+</button>
                    </div>
                    <div class="card-body">
                        <div id="pendidikan-form-list"></div>
                    </div>
                </div>

                <div class="card shadow-sm mb-4">
                    <div class="card-header">
                        Riwayat Pelatihan
                        <button type="button" class="btn btn-sm btn-success float-right tambah-riwayat" data-riwayat="pelatihan">+</button>
                    </div>
                    <div class="card-body">
                        <div id="pelatihan-form-list"></div>
                    </div>
                </div>
                
                <div class="card shadow-sm mb-4">
                    <div class="card-header">
                        Riwayat Pekerjaan
                        <button type="button" class="btn btn-sm btn-success float-right tambah-riwayat" data-riwayat="pekerjaan">+</button>
                    </div>
                    <div class="card-body">
                        <div id="pekerjaan-form-list"></div>
                    </div>
                </div>
                
                <div class="card shadow-sm mb-4">
                    <div class="card-header">
                        Riwayat Aktivitas Kebudayaan
                        <button type="button" class="btn btn-sm btn-success float-right tambah-riwayat" data-riwayat="aktivitas">+</button>
                    </div>
                    <div class="card-body">
                        <div id="aktivitas-form-list"></div>
                    </div>
                </div>
                
                <div class="card shadow-sm mb-4">
                    <div class="card-header">
                        Riwayat Penghargaan
                        <button type="button" class="btn btn-sm btn-success float-right tambah-riwayat" data-riwayat="penghargaan">+</button>
                    </div>
                    <div class="card-body">
                        <div id="penghargaan-form-list"></div>
                    </div>
                </div>
            </div>

            <div class="d-flex justify-content-end mt-4">
                <a href="<?php echo base_url('pendaftaran/dashboard'); ?>" class="btn btn-secondary mr-2">Batal</a>
                <button type="submit" class="btn btn-primary">Simpan</button>
            </div>
            
            <?php echo form_close(); ?>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
$(document).ready(function() {
    // Fungsi untuk menambah form riwayat secara dinamis
    $('.tambah-riwayat').on('click', function() {
        var riwayatType = $(this).data('riwayat');
        var container = $('#' + riwayatType + '-form-list');
        var formHtml = '';
        var formIndex = container.children('.riwayat-item').length;

        if (riwayatType === 'pendidikan') {
            formHtml = `
                <div class="riwayat-item border p-3 mb-2 rounded">
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Jenjang</label>
                            <input type="text" class="form-control" name="pendidikan[${formIndex}][jenjang]">
                        </div>
                        <div class="form-group col-md-6">
                            <label>Nama Sekolah</label>
                            <input type="text" class="form-control" name="pendidikan[${formIndex}][nama_sekolah]">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Program Studi</label>
                            <input type="text" class="form-control" name="pendidikan[${formIndex}][program_studi]">
                        </div>
                        <div class="form-group col-md-6">
                            <label>Tahun Lulus</label>
                            <input type="number" class="form-control" name="pendidikan[${formIndex}][tahun_lulus]">
                        </div>
                    </div>
                    <button type="button" class="btn btn-sm btn-danger hapus-riwayat">Hapus</button>
                </div>
            `;
        } else if (riwayatType === 'pelatihan') {
             formHtml = `
                 <div class="riwayat-item border p-3 mb-2 rounded">
                    <div class="form-row">
                         <div class="form-group col-md-6">
                             <label>Nama Pelatihan</label>
                             <input type="text" class="form-control" name="pelatihan[${formIndex}][nama_pelatihan]">
                         </div>
                         <div class="form-group col-md-6">
                             <label>Jenis Pelatihan</label>
                             <input type="text" class="form-control" name="pelatihan[${formIndex}][jenis_pelatihan]">
                         </div>
                     </div>
                     <div class="form-row">
                         <div class="form-group col-md-6">
                             <label>Tingkat Pelatihan</label>
                             <input type="text" class="form-control" name="pelatihan[${formIndex}][tingkat_pelatihan]">
                         </div>
                         <div class="form-group col-md-6">
                             <label>Peran</label>
                             <input type="text" class="form-control" name="pelatihan[${formIndex}][peran]">
                         </div>
                     </div>
                     <div class="form-row">
                         <div class="form-group col-md-6">
                             <label>Tahun</label>
                             <input type="number" class="form-control" name="pelatihan[${formIndex}][tahun]">
                         </div>
                         <div class="form-group col-md-6">
                             <label>Penyelenggara</label>
                             <input type="text" class="form-control" name="pelatihan[${formIndex}][penyelenggara]">
                         </div>
                     </div>
                     <div class="form-group">
                         <label>Bukti Sertifikat</label>
                         <input type="file" class="form-control" name="pelatihan_bukti[${formIndex}]">
                     </div>
                     <button type="button" class="btn btn-sm btn-danger hapus-riwayat">Hapus</button>
                 </div>
            `;
        } else if (riwayatType === 'pekerjaan') {
            formHtml = `
                <div class="riwayat-item border p-3 mb-2 rounded">
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Nama Pekerjaan</label>
                            <input type="text" class="form-control" name="pekerjaan[${formIndex}][nama_pekerjaan]">
                        </div>
                        <div class="form-group col-md-6">
                            <label>Nama Tempat Kerja</label>
                            <input type="text" class="form-control" name="pekerjaan[${formIndex}][nama_tempat_kerja]">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Jabatan</label>
                            <input type="text" class="form-control" name="pekerjaan[${formIndex}][jabatan]">
                        </div>
                        <div class="form-group col-md-6">
                            <label>Status</label>
                            <input type="text" class="form-control" name="pekerjaan[${formIndex}][status]">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Mulai Kerja</label>
                            <input type="date" class="form-control" name="pekerjaan[${formIndex}][mulai_kerja]">
                        </div>
                        <div class="form-group col-md-6">
                            <label>Selesai Kerja</label>
                            <input type="date" class="form-control" name="pekerjaan[${formIndex}][selesai_kerja]">
                        </div>
                    </div>
                    <button type="button" class="btn btn-sm btn-danger hapus-riwayat">Hapus</button>
                </div>
            `;
        } else if (riwayatType === 'aktivitas') {
            formHtml = `
                <div class="riwayat-item border p-3 mb-2 rounded">
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Nama Kegiatan</label>
                            <input type="text" class="form-control" name="aktivitas[${formIndex}][nama_kegiatan]">
                        </div>
                        <div class="form-group col-md-6">
                            <label>Peran</label>
                            <input type="text" class="form-control" name="aktivitas[${formIndex}][peran]">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Penyelenggara</label>
                            <input type="text" class="form-control" name="aktivitas[${formIndex}][penyelenggara]">
                        </div>
                        <div class="form-group col-md-6">
                            <label>Tingkat</label>
                            <input type="text" class="form-control" name="aktivitas[${formIndex}][tingkat]">
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Tahun</label>
                        <input type="number" class="form-control" name="aktivitas[${formIndex}][tahun]">
                    </div>
                    <button type="button" class="btn btn-sm btn-danger hapus-riwayat">Hapus</button>
                </div>
            `;
        } else if (riwayatType === 'penghargaan') {
            formHtml = `
                <div class="riwayat-item border p-3 mb-2 rounded">
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Nama Penghargaan</label>
                            <input type="text" class="form-control" name="penghargaan[${formIndex}][nama_penghargaan]">
                        </div>
                        <div class="form-group col-md-6">
                            <label>Peran</label>
                            <input type="text" class="form-control" name="penghargaan[${formIndex}][peran]">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Pemberi</label>
                            <input type="text" class="form-control" name="penghargaan[${formIndex}][pemberi]">
                        </div>
                        <div class="form-group col-md-6">
                            <label>Tingkat</label>
                            <input type="text" class="form-control" name="penghargaan[${formIndex}][tingkat]">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Tahun</label>
                            <input type="number" class="form-control" name="penghargaan[${formIndex}][tahun]">
                        </div>
                        <div class="form-group col-md-6">
                            <label>Bukti</label>
                            <input type="file" class="form-control" name="penghargaan_bukti[${formIndex}]">
                        </div>
                    </div>
                    <button type="button" class="btn btn-sm btn-danger hapus-riwayat">Hapus</button>
                </div>
            `;
        }
        
        container.append(formHtml);
    });

    // Fungsi untuk menghapus form riwayat
    $(document).on('click', '.hapus-riwayat', function() {
        $(this).closest('.riwayat-item').remove();
    });

    // Mengubah label file saat file dipilih
    $(document).on('change', '.custom-file-input', function() {
        var fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').html(fileName);
    });
});
</script>

</body>
</html>