<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Form Pendaftaran Lembaga</title>
    <style>
        body { font-family: sans-serif; background: #f0f2f5; margin: 0; padding: 20px; }
        .container { max-width: 900px; margin: auto; background: #fff; padding: 30px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        h1, h2 { text-align: center; color: #333; }
        .form-section { border: 1px solid #e0e0e0; border-radius: 8px; padding: 20px; margin-bottom: 20px; }
        .form-section-title { font-size: 1.2em; font-weight: bold; margin-bottom: 15px; color: #555; }
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: bold; }
        .form-group label span.required { color: red; }
        .form-control, .form-select { width: 100%; padding: 8px; box-sizing: border-box; border: 1px solid #ccc; border-radius: 4px; }
        .form-row { display: flex; flex-wrap: wrap; gap: 20px; }
        .form-row .form-group { flex: 1; min-width: 200px; }
        .button-group { text-align: right; margin-top: 20px; }
        .button-group .btn { padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; }
        .button-group .btn-submit { background-color: #007bff; color: white; }
        .button-group .btn-danger { background-color: #dc3545; color: white; }
        .form-inline { display: flex; align-items: center; gap: 10px; }
        .form-inline .form-control, .form-inline .form-select { flex: 1; }
        .repeatable-group { border: 1px dashed #ccc; padding: 15px; margin-top: 10px; border-radius: 5px; position: relative; }
        .repeatable-group .btn-remove { position: absolute; top: 5px; right: 5px; background: #dc3545; color: white; border: none; border-radius: 50%; width: 25px; height: 25px; cursor: pointer; }
        .alert { padding: 15px; margin-bottom: 20px; border-radius: 4px; }
        .alert-success { background-color: #d4edda; color: #155724; border-color: #c3e6cb; }
        .alert-danger { background-color: #f8d7da; color: #721c24; border-color: #f5c6cb; }
        .btn-add-item { background: #28a745; color: white; padding: 8px 15px; border: none; border-radius: 4px; cursor: pointer; margin-top: 10px; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        table th, table td { border: 1px solid #e0e0e0; padding: 10px; text-align: left; }
        table th { background-color: #f8f9fa; }
        .btn-action { padding: 5px 10px; margin: 2px; border: none; border-radius: 4px; cursor: pointer; }
        .btn-edit { background: #ffc107; color: #333; }
        .btn-delete { background: #dc3545; color: white; }
    </style>
</head>
<body>

<div class="container">
    <h1>Pendaftaran Lembaga</h1>
    
    <?php if ($this->session->flashdata('success')): ?>
        <div class="alert alert-success">
            <?= $this->session->flashdata('success') ?>
        </div>
    <?php endif; ?>

    <?php if ($this->session->flashdata('error')): ?>
        <div class="alert alert-danger">
            <?= $this->session->flashdata('error') ?>
        </div>
    <?php endif; ?>

    <form action="<?= site_url('pendaftaran/submit_kelompok') ?>" method="post" enctype="multipart/form-data">
        
        <div class="form-section">
            <div class="form-section-title">Identitas Lembaga</div>
            <div class="form-row">
                <div class="form-group">
                    <label for="nama_sanggar">Nama Sanggar <span class="required">*</span></label>
                    <input type="text" name="nama_sanggar" class="form-control" required value="<?= set_value('nama_sanggar') ?>">
                </div>
                <div class="form-group">
                    <label for="jenis_lembaga">Jenis Lembaga <span class="required">*</span></label>
                    <select name="jenis_lembaga" class="form-select" required>
                        <option value="">Pilih Jenis Lembaga</option>
                        <option value="Sanggar">Sanggar</option>
                        <option value="Kelompok">Kelompok</option>
                    </select>
                </div>
                <div class="form-group col-md-4 mb-3">
                <label class="form-label required-label d-block">Jenis Seni</label>
                <div class="form-check">
                    <?php foreach ($jenis_seni as $row): ?>
                        <input class="form-check-input" type="checkbox" name="jenis_seni[]" id="seni-<?= $row['id_seni'] ?>" value="<?= $row['id_seni'] ?>">
                        <label class="form-check-label" for="seni-<?= $row['id_seni'] ?>">
                            <?= $row['nama_seni'] ?>
                        </label>
                        <br>
                    <?php endforeach; ?>
                </div>
            </div>
                <div class="form-group">
                    <label for="status_hukum">Status Hukum <span class="required">*</span></label>
                    <select name="status_hukum" class="form-select" required>
                        <option value="">Pilih Status Hukum</option>
                        <option value="Berbadan Hukum">Berbadan Hukum</option>
                        <option value="Non-Berbadan Hukum">Non-Berbadan Hukum</option>
                    </select>
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="nomor_identitas">Nomor Identitas Lembaga</label>
                    <input type="text" name="nomor_identitas" class="form-control" value="<?= set_value('nomor_identitas') ?>">
                </div>
                <div class="form-group">
                    <label for="tanggal_berdiri">Tanggal Berdiri</label>
                    <input type="date" name="tanggal_berdiri" class="form-control" value="<?= set_value('tanggal_berdiri') ?>">
                </div>
            </div>
            <div class="form-group">
                <label for="tujuan">Tujuan Berdiri Lembaga</label>
                <textarea name="tujuan" class="form-control" rows="3"><?= set_value('tujuan') ?></textarea>
            </div>
            <div class="form-group">
                <label for="deskripsi">Deskripsi Lembaga</label>
                <textarea name="deskripsi" class="form-control" rows="3"><?= set_value('deskripsi') ?></textarea>
            </div>
        </div>

        <div class="form-section">
            <div class="form-section-title">Berkas Legalitas / Identitas</div>
            <div class="form-group">
                <label for="dokumen_legalitas">Unggah Berkas Legalitas / Identitas</label>
                <input type="file" name="dokumen_legalitas" class="form-control">
            </div>
        </div>
        
        <div class="form-section">
            <div class="form-section-title">Kontak Lembaga</div>
            <div class="form-row">
                <div class="form-group">
                    <label for="no_hp">Nomor HP (Min 7, Max 15) <span class="required">*</span></label>
                    <input type="text" name="no_hp" class="form-control" required value="<?= set_value('no_hp') ?>">
                </div>
                <div class="form-group">
                    <label for="alamat_email">Alamat Email</label>
                    <input type="email" name="alamat_email" class="form-control" value="<?= set_value('alamat_email') ?>">
                </div>
                <div class="form-group">
                    <label for="alamat_website">Alamat Website</label>
                    <input type="text" name="alamat_website" class="form-control" placeholder="http://..." value="<?= set_value('alamat_website') ?>">
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="akun_facebook">Akun Facebook</label>
                    <input type="text" name="akun_facebook" class="form-control" value="<?= set_value('akun_facebook') ?>">
                </div>
                <div class="form-group">
                    <label for="akun_twitter">Akun Twitter</label>
                    <input type="text" name="akun_twitter" class="form-control" value="<?= set_value('akun_twitter') ?>">
                </div>
                <div class="form-group">
                    <label for="akun_instagram">Akun Instagram</label>
                    <input type="text" name="akun_instagram" class="form-control" value="<?= set_value('akun_instagram') ?>">
                </div>
                <div class="form-group">
                    <label for="akun_youtube">Akun Youtube</label>
                    <input type="text" name="akun_youtube" class="form-control" value="<?= set_value('akun_youtube') ?>">
                </div>
            </div>
        </div>

        <div class="form-section">
            <div class="form-section-title">Kepemilikan & Kepengurusan</div>
            <div class="form-row">
                <div class="form-group">
                    <label for="status_kepemilikan">Status Kepemilikan <span class="required">*</span></label>
                    <select name="status_kepemilikan" class="form-select" required>
                        <option value="">Pilih Status Kepemilikan</option>
                        <option value="Milik Sendiri">Milik Sendiri</option>
                        <option value="Sewa">Sewa</option>
                        <option value="Pinjam Pakai">Pinjam Pakai</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="nama_pemilik">Nama Pemilik <span class="required">*</span></label>
                    <input type="text" name="nama_pemilik" class="form-control" required value="<?= set_value('nama_pemilik') ?>">
                </div>
            </div>
        </div>

        <div class="form-section">
            <div class="form-section-title">Media Foto</div>
            <div class="form-row">
                <div class="form-group">
                    <label for="logo">Logo Lembaga</label>
                    <input type="file" name="logo" class="form-control">
                </div>
                <div class="form-group">
                    <label for="foto_papan_nama">Foto Papan Nama</label>
                    <input type="file" name="foto_papan_nama" class="form-control">
                </div>
            </div>
            <div class="form-row">
                <div class="form-group">
                    <label for="foto_bangunan_dalam">Foto Bangunan - Tampak Dalam</label>
                    <input type="file" name="foto_bangunan_dalam" class="form-control">
                </div>
                <div class="form-group">
                    <label for="foto_bangunan_luar">Foto Bangunan - Tampak Luar</label>
                    <input type="file" name="foto_bangunan_luar" class="form-control">
                </div>
            </div>
        </div>

        <div class="form-section">
            <div class="form-section-title">Alamat Lembaga</div>
            <div class="form-row">
                <div class="form-group">
                    <label for="provinsi">Provinsi <span class="required">*</span></label>
                    <input type="text" name="provinsi" id="provinsi" class="form-control" required value="<?= set_value('provinsi') ?>">
                </div>
                <div class="form-group">
                    <label for="kabupaten">Kabupaten / Kota <span class="required">*</span></label>
                    <input type="text" name="kabupaten" id="kabupaten" class="form-control" required value="<?= set_value('kabupaten') ?>">
                </div>
                <div class="form-group">
                    <label for="kecamatan">Kecamatan <span class="required">*</span></label>
                    <input type="text" name="kecamatan" id="kecamatan" class="form-control" required value="<?= set_value('kecamatan') ?>">
                </div>
                <div class="form-group">
                    <label for="desa">Desa / Kelurahan <span class="required">*</span></label>
                    <input type="text" name="desa" id="desa" class="form-control" required value="<?= set_value('desa') ?>">
                </div>
            </div>
            <div class="form-row">
                <div class="form-group" style="flex: 2;">
                    <label for="alamat">Alamat <span class="required">*</span></label>
                    <input type="text" name="alamat" class="form-control" required value="<?= set_value('alamat') ?>">
                </div>
                <div class="form-group">
                    <label for="latitude">Latitude</label>
                    <input type="text" name="latitude" class="form-control" value="<?= set_value('latitude') ?>">
                </div>
                <div class="form-group">
                    <label for="longitude">Longitude</label>
                    <input type="text" name="longitude" class="form-control" value="<?= set_value('longitude') ?>">
                </div>
            </div>
        </div>

        <div class="form-section">
    <div class="form-section-title">Pengurus Lembaga</div>
    <div id="pengurus-form-container">
        <div class="form-row">
            <div class="form-group">
                <label>NIK <span class="required">*</span></label>
                <input type="text" id="pengurus_nik_input" class="form-control">
            </div>
            <div class="form-group">
                <label>Nama Pengurus <span class="required">*</span></label>
                <input type="text" id="pengurus_nama_input" class="form-control">
            </div>
            <div class="form-group">
                <label>Gelar Pendidikan</label>
                <input type="text" id="pengurus_gelar_pendidikan_input" class="form-control">
            </div>
            <div class="form-group">
                <label>Jenis Kelamin <span class="required">*</span></label>
                <select id="pengurus_jk_input" class="form-select">
                    <option value="">Pilih JK</option>
                    <option value="L">Laki-laki</option>
                    <option value="P">Perempuan</option>
                </select>
            </div>
        </div>
        <div class="form-row">
            <div class="form-group">
                <label>Tempat Lahir</label>
                <input type="text" id="pengurus_tempat_lahir_input" class="form-control">
            </div>
            <div class="form-group">
                <label>Tanggal Lahir</label>
                <input type="date" id="pengurus_tanggal_lahir_input" class="form-control">
            </div>
            <div class="form-group">
                <label>Kewarganegaraan</label>
                <select id="pengurus_kewarganegaraan_input" class="form-select">
                    <option value="">Pilih Kewarganegaraan</option>
                    <option value="WNI">Warga Negara Indonesia</option>
                    <option value="WNA">Warga Negara Asing</option>
                </select>
            </div>
            <div class="form-group">
                <label>Agama</label>
                <select id="pengurus_agama_input" class="form-select">
                    <option value="">Pilih Agama</option>
                    <option value="Islam">Islam</option>
                    <option value="Kristen">Kristen</option>
                    <option value="Katolik">Katolik</option>
                    <option value="Hindu">Hindu</option>
                    <option value="Buddha">Buddha</option>
                    <option value="Konghucu">Konghucu</option>
                </select>
            </div>
        </div>
        <div class="form-row">
            <div class="form-group">
                <label>Nomor HP</label>
                <input type="text" id="pengurus_hp_input" class="form-control">
            </div>
            <div class="form-group">
                <label>Peran <span class="required">*</span></label>
                <select id="pengurus_peran_input" class="form-select">
                    <option value="">Pilih Peran</option>
                    <?php foreach ($peran as $p): ?>
                        <option value="<?= $p['nama_peran'] ?>"><?= $p['nama_peran'] ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>
        <button type="button" class="btn-add-item" onclick="addPengurus()">Tambah Pengurus</button>
    </div>
            
            <table id="pengurus-table" style="width:100%; margin-top: 20px;">
                <thead>
                    <tr>
                        <th>NIK</th>
                        <th>Nama</th>
                        <th>Gelar</th>
                        <th>JK</th>
                        <th>Tempat Lahir</th>
                        <th>Tgl Lahir</th>
                        <th>Warga Negara</th>
                        <th>Agama</th>
                        <th>Nomor HP</th>
                        <th>Peran</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>
        
        <div class="form-section">
    <div class="form-section-title">Anggota Lembaga</div>
    <div id="anggota-form-container">
        <div class="form-row">
            <div class="form-group">
                <label>NIK <span class="required">*</span></label>
                <input type="text" id="anggota_nik_input" class="form-control">
            </div>
            <div class="form-group">
                <label>Nama Anggota <span class="required">*</span></label>
                <input type="text" id="anggota_nama_input" class="form-control">
            </div>
            <div class="form-group">
                <label>Jenis Kelamin <span class="required">*</span></label>
                <select id="anggota_jk_input" class="form-select">
                    <option value="">Pilih JK</option>
                    <option value="L">Laki-laki</option>
                    <option value="P">Perempuan</option>
                </select>
            </div>
            <div class="form-group">
                <label>Tempat Lahir</label>
                <input type="text" id="anggota_tempat_lahir_input" class="form-control">
            </div>
        </div>
        <div class="form-row">
            <div class="form-group">
                <label>Tanggal Lahir</label>
                <input type="date" id="anggota_tanggal_lahir_input" class="form-control">
            </div>
            <div class="form-group">
                <label>Kewarganegaraan</label>
                <select id="anggota_kewarganegaraan_input" class="form-select">
                    <option value="">Pilih Kewarganegaraan</option>
                    <option value="WNI">Warga Negara Indonesia</option>
                    <option value="WNA">Warga Negara Asing</option>
                </select>
            </div>
            <div class="form-group">
                <label>Agama</label>
                <select id="anggota_agama_input" class="form-select">
                    <option value="">Pilih Agama</option>
                    <option value="Islam">Islam</option>
                    <option value="Kristen">Kristen</option>
                    <option value="Katolik">Katolik</option>
                    <option value="Hindu">Hindu</option>
                    <option value="Buddha">Buddha</option>
                    <option value="Konghucu">Konghucu</option>
                </select>
            </div>
            <div class="form-group">
                <label>Nomor HP</label>
                <input type="text" id="anggota_hp_input" class="form-control">
            </div>
        </div>
        <div class="form-row">
            <div class="form-group">
                <label>Level <span class="required">*</span></label>
                <select id="anggota_level_input" class="form-select">
                    <option value="">Pilih Level</option>
                    <?php foreach ($level as $l): ?>
                        <option value="<?= $l['nama_level'] ?>"><?= $l['nama_level'] ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>
        <button type="button" class="btn-add-item" onclick="addAnggota()">Tambah Anggota</button>
    </div>
            
            <table id="anggota-table" style="width:100%; margin-top: 20px;">
                <thead>
                    <tr>
                        <th>NIK</th>
                        <th>Nama</th>
                        <th>Nomor HP</th>
                        <th>Jenis Kelamin</th>
                        <th>Agama</th>
                        <th>Tempat Lahir</th>
                        <th>Tanggal Lahir</th>
                        <th>Kewarganegaraan</th>
                        <th>Level</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                </tbody>
            </table>
        </div>

        <div class="form-section">
            <div class="form-section-title">Riwayat Kegiatan</div>
            <div id="kegiatan-container">
                <div class="repeatable-group">
                    <button type="button" class="btn-remove">&times;</button>
                    <div class="form-row">
                        <div class="form-group">
                            <label>Nama Kegiatan</label>
                            <input type="text" name="nama_kegiatan[]" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Jenis Kegiatan</label>
                            <input type="text" name="jenis_kegiatan[]" class="form-control">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label>Penyelenggara Kegiatan</label>
                            <input type="text" name="penyelenggara_kegiatan[]" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Tingkat Kegiatan</label>
                            <input type="text" name="tingkat_kegiatan[]" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Tahun Kegiatan</label>
                            <input type="text" name="tahun_kegiatan[]" class="form-control">
                        </div>
                    </div>
                </div>
            </div>
            <div class="button-group" style="text-align: left; margin-top: 10px;">
                <button type="button" class="btn-add-item" id="tambah-kegiatan">Tambah</button>
            </div>
        </div>
        
        <div class="form-section">
            <div class="form-section-title">Riwayat Penghargaan</div>
            <div id="penghargaan-container">
                <div class="repeatable-group">
                    <button type="button" class="btn-remove">&times;</button>
                    <div class="form-row">
                        <div class="form-group">
                            <label>Nama Penghargaan</label>
                            <input type="text" name="nama_penghargaan[]" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Pihak Pemberi Penghargaan</label>
                            <input type="text" name="pemberi_penghargaan[]" class="form-control">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group">
                            <label>Tahun Penghargaan</label>
                            <input type="text" name="tahun_penghargaan[]" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Tingkat Penghargaan</label>
                            <input type="text" name="tingkat_penghargaan[]" class="form-control">
                        </div>
                        <div class="form-group">
                            <label>Unggah Bukti Penghargaan</label>
                            <input type="file" name="bukti_penghargaan[]" class="form-control">
                        </div>
                    </div>
                </div>
            </div>
            <div class="button-group" style="text-align: left; margin-top: 10px;">
                <button type="button" class="btn-add-item" id="tambah-penghargaan">Tambah</button>
            </div>
        </div>

        <div class="button-group">
            <a href="<?php echo base_url('admin/pendaftar_kelompok'); ?>" class="btn btn-secondary mr-2">Batal</a>
            <button type="submit" class="btn btn-submit">Simpan Pendaftaran</button>
        </div>
    </form>
</div>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script>
    // Inisialisasi array untuk data sementara
    let pengurusList = [];
    let anggotaList = [];
    let editingPengurusIndex = -1;
    let editingAnggotaIndex = -1;

    // --- Fungsi untuk Pengurus ---
    function addPengurus() {
        const nik = $('#pengurus_nik_input').val();
        const nama = $('#pengurus_nama_input').val();
        const gelar_pendidikan = $('#pengurus_gelar_pendidikan_input').val();
        const jk = $('#pengurus_jk_input').val();
        const tempat_lahir = $('#pengurus_tempat_lahir_input').val();
        const tanggal_lahir = $('#pengurus_tanggal_lahir_input').val();
        const kewarganegaraan = $('#pengurus_kewarganegaraan_input').val();
        const agama = $('#pengurus_agama_input').val();
        const hp = $('#pengurus_hp_input').val();
        const peran = $('#pengurus_peran_input').val();

        if (!nik || !nama || !peran || !jk) {
            alert('NIK, Nama, Jenis Kelamin, dan Peran wajib diisi!');
            return;
        }

        const newPengurus = { nik, nama, gelar_pendidikan, jk, tempat_lahir, tanggal_lahir, kewarganegaraan, agama, hp, peran };

        if (editingPengurusIndex === -1) {
            pengurusList.push(newPengurus);
        } else {
            pengurusList[editingPengurusIndex] = newPengurus;
            editingPengurusIndex = -1;
            $('.btn-add-item:first').text('Tambah Pengurus');
        }

        renderPengurusTable();
        $('#pengurus-form-container input, #pengurus-form-container select').val('');
    }

    function renderPengurusTable() {
        const tableBody = $('#pengurus-table tbody');
        tableBody.empty();
        
        pengurusList.forEach((item, index) => {
            const row = `
                <tr>
                    <td>${item.nik} <input type="hidden" name="pengurus_nik[]" value="${item.nik}"></td>
                    <td>${item.nama} <input type="hidden" name="pengurus_nama[]" value="${item.nama}"></td>
                    <td>${item.gelar_pendidikan} <input type="hidden" name="pengurus_gelar_pendidikan[]" value="${item.gelar_pendidikan}"></td>
                    <td>${item.jk} <input type="hidden" name="pengurus_jk[]" value="${item.jk}"></td>
                    <td>${item.tempat_lahir} <input type="hidden" name="pengurus_tempat_lahir[]" value="${item.tempat_lahir}"></td>
                    <td>${item.tanggal_lahir} <input type="hidden" name="pengurus_tanggal_lahir[]" value="${item.tanggal_lahir}"></td>
                    <td>${item.kewarganegaraan} <input type="hidden" name="pengurus_kewarganegaraan[]" value="${item.kewarganegaraan}"></td>
                    <td>${item.agama} <input type="hidden" name="pengurus_agama[]" value="${item.agama}"></td>
                    <td>${item.hp} <input type="hidden" name="pengurus_hp[]" value="${item.hp}"></td>
                    <td>${item.peran} <input type="hidden" name="pengurus_peran[]" value="${item.peran}"></td>
                    <td>
                        <button type="button" class="btn-action btn-edit" onclick="editPengurus(${index})">Edit</button>
                        <button type="button" class="btn-action btn-delete" onclick="deletePengurus(${index})">Hapus</button>
                    </td>
                </tr>
            `;
            tableBody.append(row);
        });
    }

    function editPengurus(index) {
        const item = pengurusList[index];
        $('#pengurus_nik_input').val(item.nik);
        $('#pengurus_nama_input').val(item.nama);
        $('#pengurus_gelar_pendidikan_input').val(item.gelar_pendidikan);
        $('#pengurus_jk_input').val(item.jk);
        $('#pengurus_tempat_lahir_input').val(item.tempat_lahir);
        $('#pengurus_tanggal_lahir_input').val(item.tanggal_lahir);
        $('#pengurus_kewarganegaraan_input').val(item.kewarganegaraan);
        $('#pengurus_agama_input').val(item.agama);
        $('#pengurus_hp_input').val(item.hp);
        $('#pengurus_peran_input').val(item.peran);
        editingPengurusIndex = index;
        $('.btn-add-item:first').text('Update Pengurus');
    }

    function deletePengurus(index) {
        if (confirm('Apakah Anda yakin ingin menghapus pengurus ini?')) {
            pengurusList.splice(index, 1);
            renderPengurusTable();
        }
    }

    // --- Fungsi untuk Anggota ---
    function addAnggota() {
        const nik = $('#anggota_nik_input').val();
        const nama = $('#anggota_nama_input').val();
        const jk = $('#anggota_jk_input').val();
        const tempat_lahir = $('#anggota_tempat_lahir_input').val();
        const tanggal_lahir = $('#anggota_tanggal_lahir_input').val();
        const kewarganegaraan = $('#anggota_kewarganegaraan_input').val();
        const agama = $('#anggota_agama_input').val();
        const hp = $('#anggota_hp_input').val();
        const level = $('#anggota_level_input').val();

        if (!nik || !nama || !level || !jk) {
            alert('NIK, Nama, Jenis Kelamin, dan Level wajib diisi!');
            return;
        }

        const newAnggota = { nik, nama, jk, tempat_lahir, tanggal_lahir, kewarganegaraan, agama, hp, level };

        if (editingAnggotaIndex === -1) {
            anggotaList.push(newAnggota);
        } else {
            anggotaList[editingAnggotaIndex] = newAnggota;
            editingAnggotaIndex = -1;
            $('.btn-add-item:last').text('Update Anggota');
        }

        renderAnggotaTable();
        $('#anggota-form-container input, #anggota-form-container select').val('');
    }

    function renderAnggotaTable() {
        const tableBody = $('#anggota-table tbody');
        tableBody.empty();
        
        anggotaList.forEach((item, index) => {
            const row = `
                <tr>
                    <td>${item.nik} <input type="hidden" name="anggota_nik[]" value="${item.nik}"></td>
                    <td>${item.nama} <input type="hidden" name="anggota_nama[]" value="${item.nama}"></td>
                    <td>${item.hp} <input type="hidden" name="anggota_hp[]" value="${item.hp}"></td>
                    <td>${item.jk} <input type="hidden" name="anggota_jk[]" value="${item.jk}"></td>
                    <td>${item.agama} <input type="hidden" name="anggota_agama[]" value="${item.agama}"></td>
                    <td>${item.tempat_lahir} <input type="hidden" name="anggota_tempat_lahir[]" value="${item.tempat_lahir}"></td>
                    <td>${item.tanggal_lahir} <input type="hidden" name="anggota_tanggal_lahir[]" value="${item.tanggal_lahir}"></td>
                    <td>${item.kewarganegaraan} <input type="hidden" name="anggota_kewarganegaraan[]" value="${item.kewarganegaraan}"></td>
                    <td>${item.level} <input type="hidden" name="anggota_level[]" value="${item.level}"></td>
                    <td>
                        <button type="button" class="btn-action btn-edit" onclick="editAnggota(${index})">Edit</button>
                        <button type="button" class="btn-action btn-delete" onclick="deleteAnggota(${index})">Hapus</button>
                    </td>
                </tr>
            `;
            tableBody.append(row);
        });
    }

    function editAnggota(index) {
        const item = anggotaList[index];
        $('#anggota_nik_input').val(item.nik);
        $('#anggota_nama_input').val(item.nama);
        $('#anggota_jk_input').val(item.jk);
        $('#anggota_tempat_lahir_input').val(item.tempat_lahir);
        $('#anggota_tanggal_lahir_input').val(item.tanggal_lahir);
        $('#anggota_kewarganegaraan_input').val(item.kewarganegaraan);
        $('#anggota_agama_input').val(item.agama);
        $('#anggota_hp_input').val(item.hp);
        $('#anggota_level_input').val(item.level);
        editingAnggotaIndex = index;
        $('.btn-add-item:last').text('Update Anggota');
    }

    function deleteAnggota(index) {
        if (confirm('Apakah Anda yakin ingin menghapus anggota ini?')) {
            anggotaList.splice(index, 1);
            renderAnggotaTable();
        }
    }

    // --- Logika untuk Kegiatan dan Penghargaan (sudah ada) ---
    $(document).ready(function() {
        // Hapus elemen pertama karena ini template
        $('#kegiatan-container .repeatable-group').first().remove();
        $('#penghargaan-container .repeatable-group').first().remove();
        
        $('#tambah-kegiatan').on('click', function() {
            var newKegiatan = `
            <div class="repeatable-group">
                <button type="button" class="btn-remove">&times;</button>
                <div class="form-row">
                    <div class="form-group">
                        <label>Nama Kegiatan</label>
                        <input type="text" name="nama_kegiatan[]" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Jenis Kegiatan</label>
                        <input type="text" name="jenis_kegiatan[]" class="form-control">
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Penyelenggara Kegiatan</label>
                        <input type="text" name="penyelenggara_kegiatan[]" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Tingkat Kegiatan</label>
                        <input type="text" name="tingkat_kegiatan[]" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Tahun Kegiatan</label>
                        <input type="text" name="tahun_kegiatan[]" class="form-control">
                    </div>
                </div>
            </div>
            `;
            $('#kegiatan-container').append(newKegiatan);
        });

        $('#tambah-penghargaan').on('click', function() {
            var newPenghargaan = `
            <div class="repeatable-group">
                <button type="button" class="btn-remove">&times;</button>
                <div class="form-row">
                    <div class="form-group">
                        <label>Nama Penghargaan</label>
                        <input type="text" name="nama_penghargaan[]" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Pihak Pemberi Penghargaan</label>
                        <input type="text" name="pemberi_penghargaan[]" class="form-control">
                    </div>
                </div>
                <div class="form-row">
                    <div class="form-group">
                        <label>Tahun Penghargaan</label>
                        <input type="text" name="tahun_penghargaan[]" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Tingkat Penghargaan</label>
                        <input type="text" name="tingkat_penghargaan[]" class="form-control">
                    </div>
                    <div class="form-group">
                        <label>Unggah Bukti Penghargaan</label>
                        <input type="file" name="bukti_penghargaan[]" class="form-control">
                    </div>
                </div>
            </div>
            `;
            $('#penghargaan-container').append(newPenghargaan);
        });

        $(document).on('click', '.btn-remove', function() {
            $(this).closest('.repeatable-group').remove();
        });
    });
</script>
</body>
</html>