<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Edit Jenis Seni</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container mt-5">
    <div class="card shadow-lg border-0 rounded-4">
        <div class="card-header bg-success text-white text-center rounded-top-4">
            <h4 class="mb-0">🎭 Edit Jenis Seni: <?= htmlspecialchars($seni_saat_ini->nama_seni); ?></h4>
        </div>
        <div class="card-body p-4">

            <form method="post" action="<?= site_url('pendaftaran/update_jenis_seni_single/' . $sanggar->id_sanggar . '/' . $seni_saat_ini->id_seni) ?>">
                <div class="mb-3">
                    <label class="form-label fw-bold">Pilih Jenis Seni Baru</label>
                    <select name="jenis_seni_baru" class="form-select rounded-3" required>
                        <option value="">-- Pilih Jenis Seni --</option>
                        <?php foreach ($list_seni as $js): ?>
                            <option value="<?= $js->id_seni ?>" <?= ($seni_saat_ini->id_seni == $js->id_seni) ? 'selected' : '' ?>>
                                <?= $js->nama_seni ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="d-flex gap-2">
                    <button type="submit" class="btn btn-success flex-fill fw-bold rounded-3">💾 Simpan</button>
                    <a href="<?= site_url('pendaftaran/biodata') ?>" class="btn btn-secondary flex-fill fw-bold rounded-3">❌ Batal</a>
                </div>
            </form>

        </div>
    </div>
</div>
</body>
</html>