<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Edit Seni Perorangan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <style>
    .card-header-gradient {
        background: linear-gradient(45deg, #4f80e3, #6a11cb);
        color: white;
        border-radius: 1rem 1rem 0 0 !important;
    }
    .btn-gradient-primary {
        background: linear-gradient(45deg, #4f80e3, #6a11cb);
        border: none;
        color: white;
        transition: all 0.3s ease;
    }
    .btn-gradient-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 10px rgba(79, 128, 227, 0.4);
    }
    .form-control:focus, .form-select:focus {
        border-color: #6a11cb;
        box-shadow: 0 0 0 0.25rem rgba(106, 17, 203, 0.25);
    }
</style>


<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-7 col-lg-6">
            <div class="card border-0 shadow-lg rounded-4 overflow-hidden">
                <div class="card-header-gradient p-4 text-center">
                    <h4 class="mb-0 fw-bold">
                        <i class="fas fa-pencil-alt me-2"></i>Edit Informasi Seni
                    </h4>
                </div>
                <div class="card-body p-5">
                    <form method="post" action="<?= site_url('pendaftaran/update_seni_perorangan') ?>">
                        <input type="hidden" name="id_seni_sdm" value="<?= htmlspecialchars($seni->id ?? ''); ?>">

                        <div class="mb-4">
                            <label for="id_seni" class="form-label fw-bold text-muted">Pilih Jenis Seni</label>
                            <select name="id_seni" id="id_seni" class="form-select form-control-lg" required>
                                <option value="">-- Pilih Jenis Seni --</option>
                                <?php if (isset($jenis_seni) && !empty($jenis_seni)): ?>
                                    <?php foreach ($jenis_seni as $js): ?>
                                        <option value="<?= htmlspecialchars($js->id_seni) ?>"
                                            <?= ($js->id_seni == ($seni->id_seni ?? '')) ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($js->nama_seni) ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>

                        <div class="mb-4">
                            <label for="deskripsi" class="form-label fw-bold text-muted">Deskripsi Seni</label>
                            <textarea name="deskripsi" id="deskripsi" class="form-control" rows="5" placeholder="Jelaskan detail tentang seni yang Anda kuasai"><?= htmlspecialchars($seni->deskripsi ?? '') ?></textarea>
                        </div>
                        
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-lg btn-gradient-primary fw-bold">
                                <i class="fas fa-check me-2"></i>Simpan Perubahan
                            </button>
                            <a href="<?= site_url('pendaftaran/biodata') ?>" class="btn btn-light btn-lg fw-bold border">
                                <i class="fas fa-times me-2"></i>Batal
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>