<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Edit Profil Sanggar</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f4f7f9;
        }
        .card-header-custom {
            background-image: linear-gradient(45deg, #4c68d7, #6982e5);
            padding: 1.5rem 2rem;
            font-weight: 700;
            color: #fff;
            border-top-left-radius: 1rem;
            border-top-right-radius: 1rem;
        }
        .card {
            border-radius: 1rem;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            border: none;
        }
        .btn-success {
            background-color: #00b09b;
            border-color: #00b09b;
        }
        .btn-success:hover {
            background-color: #008f7b;
            border-color: #008f7b;
        }
        .form-control, .form-select {
            border-radius: 0.5rem;
        }
    </style>
</head>
<body class="bg-light">

<div class="container mt-5 mb-5">
    <div class="card shadow-lg border-0 rounded-4">
        <div class="card-header card-header-custom text-center">
            <h4 class="mb-0"><i class="fas fa-edit me-2"></i> Edit Profil Sanggar</h4>
        </div>
        <div class="card-body p-4">

            <form method="post" action="<?= site_url('pendaftaran/edit_sanggar/'.$sanggar->id_sanggar) ?>">
                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="nrk_sanggar" class="form-label fw-bold">NRK Sanggar</label>
                        <input type="text" id="nrk_sanggar" name="nrk_sanggar" class="form-control rounded-3" 
                            value="<?= htmlspecialchars($sanggar->nrk_sanggar) ?>" readonly>
                    </div>
                    <div class="col-md-6">
                        <label for="nama_sanggar" class="form-label fw-bold">Nama Sanggar</label>
                        <input type="text" id="nama_sanggar" name="nama_sanggar" class="form-control rounded-3" 
                            value="<?= htmlspecialchars($sanggar->nama_sanggar) ?>" required>
                    </div>
                    <div class="col-md-6">
                        <label for="jenis_lembaga" class="form-label fw-bold">Jenis Lembaga</label>
                        <input type="text" id="jenis_lembaga" name="jenis_lembaga" class="form-control rounded-3" 
                               value="<?= htmlspecialchars($sanggar->jenis_lembaga) ?>" required>
                    </div>
                    
                    <div class="col-md-6">
                        <label for="status_hukum" class="form-label fw-bold">Status Hukum</label>
                        <input type="text" id="status_hukum" name="status_hukum" class="form-control rounded-3" 
                               value="<?= htmlspecialchars($sanggar->status_hukum) ?>" required>
                    </div>
                    <div class="col-md-6">
                        <label for="tanggal_berdiri" class="form-label fw-bold">Tanggal Berdiri</label>
                        <input type="date" id="tanggal_berdiri" name="tanggal_berdiri" class="form-control rounded-3" 
                               value="<?= htmlspecialchars($sanggar->tanggal_berdiri) ?>" required>
                    </div>

                    <div class="col-md-6">
                        <label for="status_kepemilikan" class="form-label fw-bold">Status Kepemilikan</label>
                        <input type="text" id="status_kepemilikan" name="status_kepemilikan" class="form-control rounded-3" 
                               value="<?= htmlspecialchars($sanggar->status_kepemilikan) ?>" required>
                    </div>
                    <div class="col-md-6">
                        <label for="nama_pemilik" class="form-label fw-bold">Nama Pemilik</label>
                        <input type="text" id="nama_pemilik" name="nama_pemilik" class="form-control rounded-3" 
                               value="<?= htmlspecialchars($sanggar->nama_pemilik) ?>" required>
                    </div>

                    <div class="col-md-6">
                        <label for="nomor_identitas" class="form-label fw-bold">Nomor Identitas</label>
                        <input type="text" id="nomor_identitas" name="nomor_identitas" class="form-control rounded-3" 
                               value="<?= htmlspecialchars($sanggar->nomor_identitas) ?>" required>
                    </div>
                    <div class="col-md-6">
                        <label for="no_hp" class="form-label fw-bold">No. HP</label>
                        <input type="text" id="no_hp" name="no_hp" class="form-control rounded-3" 
                            value="<?= htmlspecialchars($alamat_kontak->no_hp) ?>" required>
                    </div>

                    <div class="col-md-12">
                        <label for="tujuan" class="form-label fw-bold">Tujuan</label>
                        <textarea id="tujuan" name="tujuan" class="form-control rounded-3" rows="3" required><?= htmlspecialchars($sanggar->tujuan) ?></textarea>
                    </div>

                    <div class="col-md-12">
                        <label for="deskripsi" class="form-label fw-bold">Deskripsi</label>
                        <textarea id="deskripsi" name="deskripsi" class="form-control rounded-3" rows="4"><?= htmlspecialchars($sanggar->deskripsi) ?></textarea>
                    </div>

                    <div class="col-md-12">
                        <label for="alamat" class="form-label fw-bold">Alamat Sanggar</label>
                        <textarea id="alamat" name="alamat" class="form-control rounded-3" rows="3" required><?= htmlspecialchars($alamat_kontak->alamat) ?></textarea>
                    </div>
                </div>

                <div class="d-flex gap-2 mt-4">
                    <button type="submit" class="btn btn-success flex-fill fw-bold rounded-3">
                        💾 Simpan Perubahan
                    </button>
                    <a href="<?= site_url('pendaftaran/biodata') ?>" class="btn btn-secondary flex-fill fw-bold rounded-3">
                        ❌ Batal
                    </a>
                </div>
            </form>

        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>