<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Edit Pengurus Sanggar</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f4f7f9;
        }
        .card-header-custom {
            background-image: linear-gradient(45deg, #f7971e, #ff8c00);
            padding: 1.5rem 2rem;
            font-weight: 700;
            color: #fff;
            border-top-left-radius: 1rem;
            border-top-right-radius: 1rem;
        }
        .card {
            border-radius: 1rem;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            border: none;
        }
        .btn-success {
            background-color: #00b09b;
            border-color: #00b09b;
        }
        .btn-success:hover {
            background-color: #008f7b;
            border-color: #008f7b;
        }
        .btn-secondary {
            background-color: #6c757d;
            border-color: #6c757d;
        }
        .btn-secondary:hover {
            background-color: #5a6268;
            border-color: #5a6268;
        }
        .form-control, .form-select {
            border-radius: 0.5rem;
        }
    </style>
</head>
<body class="bg-light">

<div class="container mt-5">
    <div class="card shadow-lg border-0 rounded-4">
        <div class="card-header card-header-custom text-center">
            <h4 class="mb-0">✏ Edit Pengurus Sanggar</h4>
        </div>
        <div class="card-body p-4">
            
            <form method="post" action="<?= site_url('pendaftaran/edit_pengurus/'.$pengurus->id_pengurus) ?>">
                <div class="mb-3">
                    <label class="form-label fw-bold">Nama Lengkap</label>
                    <input type="text" name="nama_lengkap" class="form-control rounded-3" value="<?= htmlspecialchars($sdm->nama_lengkap) ?>" readonly>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-bold">NRK Perorangan</label>
                    <input type="text" name="nrk_perorangan" class="form-control rounded-3" value="<?= htmlspecialchars($sdm->nrk_perorangan) ?>" readonly>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-bold">Peran</label>
                    <select name="id_peran" class="form-select rounded-3" required>
                        <?php foreach ($master_peran as $peran): ?>
                            <option value="<?= $peran->id_peran ?>" <?= ($pengurus->id_peran == $peran->id_peran) ? 'selected' : '' ?>>
                                <?= htmlspecialchars($peran->nama_peran) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="mb-3">
                    <label for="status" class="form-label">Status</label>
                    <select class="form-control" id="status" name="status">
                        <option value="aktif" <?= ($pengurus->status == 'aktif') ? 'selected' : ''; ?>>Aktif</option>
                        <option value="nonaktif" <?= ($pengurus->status == 'nonaktif') ? 'selected' : ''; ?>>Nonaktif</option>
                    </select>
                </div>

                <div class="d-flex gap-2">
                    <button type="submit" class="btn btn-success flex-fill fw-bold rounded-3">
                        💾 Simpan
                    </button>
                    <a href="<?= site_url('pendaftaran/biodata') ?>" class="btn btn-secondary flex-fill fw-bold rounded-3">
                        ❌ Batal
                    </a>
                </div>
            </form>

        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>