<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Edit Data Diri</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #5A7EFC;
            --secondary-color: #f0f2f5;
            --text-color: #343a40;
            --card-bg: #ffffff;
        }
        
        body {
            background-color: var(--secondary-color);
            font-family: 'Poppins', sans-serif;
            color: var(--text-color);
        }

        .edit-form-container {
            max-width: 900px;
            margin-top: 5rem;
            margin-bottom: 5rem;
        }

        .card-custom {
            border-radius: 1.5rem;
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1);
            overflow: hidden;
            border: none;
        }

        .card-header-custom {
            background-color: var(--primary-color);
            padding: 1.5rem;
            color: white;
            font-weight: 600;
            font-size: 1.2rem;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .profile-image-container {
            width: 180px;
            height: 180px;
            position: relative;
            margin: 0 auto;
        }

        .profile-image-container .profile-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 50%;
            border: 5px solid #fff;
            box-shadow: 0 10px 20px rgba(0,0,0,0.1);
            z-index: 2;
        }

        .image-upload-icon {
            position: absolute;
            bottom: 0;
            right: 0;
            background-color: #fff;
            color: var(--primary-color);
            border-radius: 50%;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            box-shadow: 0 2px 5px rgba(0,0,0,0.2);
            cursor: pointer;
            transition: all 0.3s ease;
            z-index: 10;
        }
        
        .image-upload-icon:hover {
            background-color: var(--primary-color);
            color: white;
            transform: scale(1.1);
        }

        .form-label {
            font-weight: 600;
            color: #555;
            margin-bottom: 0.5rem;
        }
        
        .form-control, .form-select {
            border-radius: 0.75rem;
            padding: 0.75rem 1rem;
        }

        .btn-custom {
            font-weight: 600;
            border-radius: 50px;
            padding: 0.75rem 2rem;
            transition: all 0.3s ease;
        }
        
        .btn-custom:hover {
            transform: translateY(-3px);
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
        }
        
        .profile-placeholder {
            width: 100%;
            height: 100%;
            background-color: #e9ecef;
            color: #adb5bd;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 4rem;
        }
    </style>
</head>
<body>

<div class="container edit-form-container">
    <div class="card card-custom">
        <div class="card-header-custom">
            <i class="fas fa-user-edit me-2"></i>
            <h4 class="mb-0">Edit Data Diri</h4>
        </div>
        <div class="card-body p-5">
            <form method="post" action="<?= site_url('pendaftaran/update_pendaftar/'.$pendaftar->id_sdm) ?>" enctype="multipart/form-data">
                <input type="hidden" name="id_sdm" value="<?= $pendaftar->id_sdm ?>">
                
                <div class="text-center mb-4">
                    <div class="profile-image-container">
                        <?php if (!empty($pendaftar->pas_foto) && file_exists('assets/uploads/foto_sdm/' . $pendaftar->pas_foto)): ?>
                            <img src="<?= base_url('assets/uploads/foto_sdm/' . htmlspecialchars($pendaftar->pas_foto)); ?>" 
                                 alt="Pas Foto" class="profile-image" id="preview-image">
                        <?php else: ?>
                            <div class="profile-image profile-placeholder" id="preview-image">
                                <i class="fas fa-user-circle"></i>
                            </div>
                        <?php endif; ?>
                        <label for="pas_foto" class="image-upload-icon">
                            <i class="fas fa-camera"></i>
                        </label>
                    </div>
                    <input type="file" name="pas_foto" id="pas_foto" class="d-none" accept="image/*">
                    <small class="text-muted">Klik ikon kamera untuk mengganti foto</small>
                </div>

                <div class="row g-4">
                    <div class="col-md-6">
                        <label class="form-label">Nama Lengkap</label>
                        <input type="text" name="nama_lengkap" class="form-control" 
                               value="<?= isset($pendaftar->nama_lengkap) ? htmlspecialchars($pendaftar->nama_lengkap) : '' ?>" required>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Gelar Pendidikan</label>
                        <input type="text" name="gelar_pendidikan" class="form-control" 
                               value="<?= isset($pendaftar->gelar_pendidikan) ? htmlspecialchars($pendaftar->gelar_pendidikan) : '' ?>">
                    </div>

                    <div class="col-md-6">
                        <label class="form-label">Jenis Kelamin</label>
                        <select name="jenis_kelamin" class="form-select" required>
                            <option value="">-- Pilih --</option>
                            <option value="L" <?= ($pendaftar->jenis_kelamin == 'L') ? 'selected' : '' ?>>Laki-laki</option>
                            <option value="P" <?= ($pendaftar->jenis_kelamin == 'P') ? 'selected' : '' ?>>Perempuan</option>
                        </select>
                    </div>
                    
                    <div class="col-md-6">
                        <label class="form-label">Tempat Lahir</label>
                        <input type="text" name="tempat_lahir" class="form-control" 
                               value="<?= isset($pendaftar->tempat_lahir) ? htmlspecialchars($pendaftar->tempat_lahir) : '' ?>">
                    </div>
                    
                    <div class="col-md-6">
                        <label class="form-label">Tanggal Lahir</label>
                        <input type="date" name="tanggal_lahir" class="form-control" 
                               value="<?= isset($pendaftar->tanggal_lahir) ? htmlspecialchars($pendaftar->tanggal_lahir) : '' ?>">
                    </div>
                    
                    <div class="col-md-6">
                        <label class="form-label">Alamat</label>
                        <input type="text" name="alamat" class="form-control" 
                               value="<?= isset($pendaftar->alamat) ? htmlspecialchars($pendaftar->alamat) : '' ?>">
                    </div>
                </div>

                <div class="d-flex gap-3 mt-4 justify-content-end">
                    <button type="submit" class="btn btn-success btn-custom">
                        <i class="fas fa-save me-2"></i> Simpan Perubahan
                    </button>
                    <a href="<?= site_url('pendaftaran/biodata') ?>" class="btn btn-secondary btn-custom">
                        <i class="fas fa-times me-2"></i> Batal
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script>
    document.getElementById('pas_foto').addEventListener('change', function(event) {
        const file = event.target.files[0];
        if (file) {
            const reader = new FileReader();
            reader.onload = function(e) {
                const previewElement = document.getElementById('preview-image');
                if (previewElement.tagName === 'IMG') {
                    previewElement.src = e.target.result;
                } else {
                    const newImage = document.createElement('img');
                    newImage.src = e.target.result;
                    newImage.alt = "Pas Foto Preview";
                    newImage.classList.add('profile-image');
                    previewElement.replaceWith(newImage);
                }
            };
            reader.readAsDataURL(file);
        }
    });
</script>
</body>
</html>