<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Edit Anggota Kelompok</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container mt-5">
    <div class="card shadow-lg border-0 rounded-4">
        <div class="card-header bg-primary text-white text-center rounded-top-4">
            <h4 class="mb-0">👥 Edit Anggota Kelompok</h4>
        </div>
        <div class="card-body p-4">
            <form method="post" action="<?= site_url('pendaftaran/edit_anggota/'.$anggota->id_anggota) ?>">

                <div class="mb-3">
                    <label class="form-label fw-bold">NIK</label>
                    <input type="text" name="nik" class="form-control rounded-3" 
                           value="<?= $anggota->nik ?>" required>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-bold">Nama Anggota</label>
                    <input type="text" name="nama" class="form-control rounded-3" 
                           value="<?= $anggota->nama_anggota ?>" required>
                </div>
                <div class="mb-3">
                    <label class="form-label fw-bold">Level / Peran</label>
                    <select name="id_level" class="form-select rounded-3" required>
                        <?php foreach ($master_level as $level): ?>
                            <option value="<?= $level->id_level ?>" <?= ($anggota->id_level == $level->id_level) ? 'selected' : '' ?>>
                                <?= htmlspecialchars($level->nama_level) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-bold">No HP</label>
                    <input type="text" name="no_hp" class="form-control rounded-3" 
                           value="<?= $anggota->nomor_hp ?>" required>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-bold">Jenis Kelamin</label>
                    <select name="jk" class="form-select rounded-3" required>
                        <option value="L" <?= $anggota->jenis_kelamin == 'L' ? 'selected' : '' ?>>Laki-laki</option>
                        <option value="P" <?= $anggota->jenis_kelamin == 'P' ? 'selected' : '' ?>>Perempuan</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="status" class="form-label">Status</label>
                    <select class="form-control" id="status" name="status">
                        <option value="aktif" <?= ($anggota->status == 'aktif') ? 'selected' : ''; ?>>Aktif</option>
                        <option value="nonaktif" <?= ($anggota->status == 'nonaktif') ? 'selected' : ''; ?>>Nonaktif</option>
                    </select>
                </div>

                <div class="d-flex gap-2">
                    <button type="submit" class="btn btn-success flex-fill fw-bold rounded-3">
                        💾 Simpan Perubahan
                    </button>
                    <a href="<?= site_url('pendaftaran/biodata'); ?>" 
                       class="btn btn-secondary flex-fill fw-bold rounded-3">
                        ❌ Batal
                    </a>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>