<?php $this->load->view('templates/header_user', ['title' => 'Dashboard Perorangan']); ?>

<style>
/* CSS Tambahan untuk Desain yang Lebih Baik */

body {
    background: #f0f2f5; /* Latar belakang abu-abu muda yang lembut */
    font-family: 'Poppins', sans-serif; /* Font modern yang mudah dibaca */
}

.dashboard-container {
    padding-top: 5rem;
    padding-bottom: 5rem;
}

.dashboard-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: #212529; /* Warna teks gelap */
}

.dashboard-subtitle {
    font-size: 1.1rem;
    color: #6c757d; /* Warna teks abu-abu */
}

.card-dashboard {
    background: #ffffff;
    border-radius: 1.5rem; /* Sudut lebih melengkung */
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08); /* Bayangan yang elegan */
    transition: transform 0.3s ease-in-out;
}

.card-dashboard:hover {
    transform: translateY(-5px); /* Efek melayang saat dihover */
}

.card-header-gradient {
    background: linear-gradient(135deg, #1A75FF, #00C4FF); /* Gradient warna biru */
    color: #ffffff;
    border-radius: 1.5rem 1.5rem 0 0;
    padding: 2rem;
    text-align: center;
}

.card-header-gradient h4 {
    margin-bottom: 0;
    font-weight: 600;
}

.card-icon-lg {
    font-size: 4rem;
    margin-bottom: 1rem;
    text-shadow: 2px 2px 5px rgba(0, 0, 0, 0.1);
}

.card-body-dashboard {
    padding: 2.5rem;
}

.status-badge {
    padding: 0.5rem 1.25rem;
    border-radius: 50px;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.8rem;
    letter-spacing: 1px;
    display: inline-block;
}

.status-terdaftar {
    background-color: #e6f7e9;
    color: #28a745;
}

.status-belum-terdaftar {
    background-color: #ffebe6;
    color: #dc3545;
}

.info-row {
    margin-bottom: 1.5rem;
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1rem 0;
    border-bottom: 1px solid #e9ecef;
}

.info-label {
    font-weight: 500;
    color: #6c757d;
}

.info-value {
    font-weight: 700;
    color: #343a40;
}

/* Penyesuaian untuk tampilan jenis seni */
.seni-list {
    display: flex;
    flex-wrap: wrap;
    gap: 0.5rem;
}

.seni-badge {
    background-color: #e6f7ff;
    color: #007bff;
    font-weight: 500;
    padding: 0.5rem 1rem;
    border-radius: 50px;
    font-size: 0.9rem;
}


.btn-dashboard {
    padding: 0.75rem 1.5rem;
    font-weight: 600;
    border-radius: 50px;
    transition: all 0.3s ease;
}

.btn-primary-custom {
    background: #007bff;
    border-color: #007bff;
    color: #fff;
}

.btn-primary-custom:hover {
    background: #0056b3;
    border-color: #004085;
    transform: translateY(-2px);
}

.btn-secondary-custom {
    background: #6c757d;
    border-color: #6c757d;
    color: #fff;
}

.btn-secondary-custom:hover {
    background: #5a6268;
    border-color: #545b62;
    transform: translateY(-2px);
}
</style>
<div class="container dashboard-container">
    <div class="text-center mb-5">
        <h2 class="dashboard-title">Selamat Datang di Dashboard</h2>
        <p class="dashboard-subtitle">Halo, <strong><?= htmlspecialchars($user->nama_lengkap); ?></strong>! Berikut ringkasan pendaftaran Anda.</p>
    </div>
    <div class="row justify-content-center">
        <div class="col-md-9 col-lg-7">
            <div class="card card-dashboard">
                <div class="card-header-gradient">
                    <div class="card-icon-lg">✨</div>
                    <h4 class="mb-0">Pendaftaran Perorangan</h4>
                </div>
                <div class="card-body-dashboard">
                    <?php if ($pendaftar): ?>
                        <div class="text-center mb-5">
                            <h3 class="text-success fw-bold">Anda Telah Terdaftar!</h3>
                            <span class="status-badge status-terdaftar">Status Aktif ✅</span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">NIK</span>
                            <span class="info-value"><?= htmlspecialchars($pendaftar->nik); ?></span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">NRK</span>
                            <span class="info-value"><?= htmlspecialchars($pendaftar->nrk_perorangan ?? '-'); ?></span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">Jenis Seni</span>
                            <span class="info-value">
                                <?php if (!empty($seni)): ?>
                                    <div class="seni-list">
                                        <?php foreach ($seni as $s): ?>
                                            <span class="seni-badge"><?= htmlspecialchars($s->nama_seni); ?></span>
                                        <?php endforeach; ?>
                                    </div>
                                        <?php else: ?>
                                            -
                                        <?php endif; ?>
                            </span>
                        </div>
                        <div class="d-flex justify-content-between mt-4">
                            <a href="<?= base_url('pendaftaran/biodata'); ?>" class="btn btn-secondary-custom btn-dashboard w-48">
                                Lihat Detail</a>
                            </a>
                            <a href="<?= base_url('pendaftaran/cetak_bukti'); ?>" class="btn btn-primary-custom btn-dashboard w-48">
                                🖨 Cetak Bukti
                            </a>
                        </div>
                        <?php else: ?>
                            <div class="text-center mb-5">
                                <h3 class="text-danger fw-bold">Pendaftaran Belum Lengkap!</h3>
                                <span class="status-badge status-belum-terdaftar">Status Belum Terdaftar ❌</span>
                            </div>
                            <p class="text-center text-muted mb-4">Mohon lengkapi formulir pendaftaran Anda untuk mendapatkan Nomor Registrasi Kesenian (NRK).</p> 
                            <div class="d-grid gap-2 mt-4">
                                <a href="<?= base_url('pendaftaran/form_perorangan'); ?>" class="btn btn-primary-custom btn-dashboard">Isi Formulir Pendaftaran Sekarang</a>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $this->load->view('templates/footer_user'); ?>