<?php $this->load->view('templates/header_user', ['title' => 'Dashboard Kelompok']); ?>

<style>
/* CSS Tambahan untuk Desain Dashboard Sanggar */

body {
    background: #e9f5ff; /* Latar belakang biru muda yang cerah */
    font-family: 'Poppins', sans-serif;
}

.dashboard-container {
    padding-top: 5rem;
    padding-bottom: 5rem;
}

.dashboard-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: #0d47a1; /* Warna biru gelap */
}

.dashboard-subtitle {
    font-size: 1.1rem;
    color: #4a657e; /* Warna abu-abu kebiruan */
}

.card-dashboard {
    background: #ffffff;
    border-radius: 1.5rem;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
    transition: transform 0.3s ease-in-out, box-shadow 0.3s ease-in-out;
}

.card-dashboard:hover {
    transform: translateY(-8px);
    box-shadow: 0 15px 40px rgba(0, 0, 0, 0.12);
}

.card-header-gradient {
    background: linear-gradient(135deg, #FF5F6D, #FFC371); /* Gradient warna cerah (oranye-merah) */
    color: #ffffff;
    border-radius: 1.5rem 1.5rem 0 0;
    padding: 2.5rem 2rem;
    text-align: center;
}

.card-header-gradient h4 {
    margin-bottom: 0;
    font-weight: 600;
}

.card-icon-lg {
    font-size: 4rem;
    margin-bottom: 1rem;
    text-shadow: 2px 2px 5px rgba(0, 0, 0, 0.1);
}

.card-body-dashboard {
    padding: 2.5rem;
}

.status-badge {
    padding: 0.5rem 1.25rem;
    border-radius: 50px;
    font-weight: 600;
    text-transform: uppercase;
    font-size: 0.8rem;
    letter-spacing: 1px;
    display: inline-block;
}

.status-terdaftar {
    background-color: #e8f5e9;
    color: #4caf50;
}

.status-belum-terdaftar {
    background-color: #ffebee;
    color: #f44336;
}

.info-item {
    padding: 1rem 0;
    border-bottom: 1px solid #eceff1;
}
.info-item:last-child {
    border-bottom: none;
}
.info-label {
    font-weight: 500;
    color: #616161;
}
.info-value {
    font-weight: 700;
    color: #212121;
}

.btn-dashboard {
    padding: 0.8rem 2rem;
    font-weight: 600;
    border-radius: 50px;
    transition: all 0.3s ease;
}

.btn-primary-custom {
    background: linear-gradient(45deg, #1A75FF, #4D91FF);
    border: none;
    color: #fff;
    box-shadow: 0 4px 15px rgba(26, 117, 255, 0.3);
}
.btn-primary-custom:hover {
    box-shadow: 0 6px 20px rgba(26, 117, 255, 0.4);
    transform: translateY(-2px);
}

.btn-secondary-custom {
    background: linear-gradient(45deg, #6c757d, #9e9e9e);
    border: none;
    color: #fff;
    box-shadow: 0 4px 15px rgba(108, 117, 125, 0.3);
}
.btn-secondary-custom:hover {
    box-shadow: 0 6px 20px rgba(108, 117, 125, 0.4);
    transform: translateY(-2px);
}
</style>

<div class="container dashboard-container">
    <div class="text-center mb-5">
        <h2 class="dashboard-title">Dashboard Sanggar Seni</h2>
        <p class="dashboard-subtitle">Halo, <strong><?= htmlspecialchars($user->nama_lengkap); ?></strong>! Berikut ringkasan pendaftaran sanggar Anda.</p>
    </div>

    <div class="row justify-content-center">
        <div class="col-md-9 col-lg-7">
            <div class="card card-dashboard">
                <div class="card-header-gradient">
                    <div class="card-icon-lg">🎭</div>
                    <h4 class="mb-0">Pendaftaran Kelompok Seni</h4>
                </div>

                <div class="card-body-dashboard">
                    <?php if ($sanggar): ?>
                        <div class="text-center mb-5">
                            <h3 class="text-success fw-bold">Sanggar Anda Sudah Terdaftar!</h3>
                            <span class="status-badge status-terdaftar">Status Aktif ✅</span>
                        </div>
                        <div class="list-group list-group-flush">
                            <div class="list-group-item info-item">
                                <span class="info-label">Nama Sanggar:</span> <strong class="info-value"><?= htmlspecialchars($sanggar->nama_sanggar); ?></strong>
                            </div>
                            <div class="list-group-item info-item">
                                <span class="info-label">Jenis Seni:</span> <strong class="info-value"><?= htmlspecialchars($seni[0]->nama_seni ?? '-'); ?></strong>
                            </div>
                            <div class="list-group-item info-item">
                                <span class="info-label">Jumlah Anggota:</span> <strong class="info-value"><?= (count($anggota) ?? 0) + (count($pengurus) ?? 0); ?> orang</strong>
                            </div>
                        </div>
                        <div class="d-grid gap-2 mt-4">
                            <a href="<?= base_url('pendaftaran/biodata'); ?>" class="btn btn-secondary-custom btn-dashboard">
                                Lihat Profil & Cetak Bukti
                            </a>
                        </div>
                    <?php else: ?>
                        <div class="text-center mb-5">
                            <h3 class="text-danger fw-bold">Sanggar Belum Terdaftar!</h3>
                            <span class="status-badge status-belum-terdaftar">Status Belum Terdaftar ❌</span>
                        </div>
                        <p class="text-center text-muted mb-4">Mohon lengkapi formulir pendaftaran sanggar untuk mendapatkan Nomor Pokok Organisasi (NPO).</p>
                        <div class="d-grid gap-2 mt-4">
                            <a href="<?= base_url('pendaftaran/form_kelompok'); ?>" class="btn btn-primary-custom btn-dashboard">
                                Isi Formulir Pendaftaran Sanggar
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $this->load->view('templates/footer_user'); ?>