<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Bukti Pendaftaran Seni</title>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: #f8f9fa;
            margin: 0;
            padding: 20px;
            color: #212529;
        }
        .container {
            max-width: 900px;
            margin: auto;
            background: #fff;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 8px 25px rgba(0,0,0,0.1);
        }
        h1, h2 {
            color: #5A7EFC;
            margin-bottom: 15px;
        }
        h1 {
            font-size: 28px;
            text-align: center;
            margin-bottom: 30px;
        }
        p.subtitle {
            text-align: center;
            color: #6c757d;
            margin-bottom: 40px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 30px;
        }
        table th, table td {
            border: 1px solid #dee2e6;
            padding: 10px 14px;
            text-align: left;
        }
        table th {
            background: #f1f3f5;
            font-weight: 600;
            color: #343a40;
            width: 200px;
        }
        .signature {
            text-align: right;
            margin-top: 40px;
            font-size: 14px;
        }
        .actions {
            text-align: center;
            margin-top: 40px;
        }
        .btn {
            display: inline-block;
            padding: 12px 24px;
            margin: 5px;
            border-radius: 8px;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s ease;
        }
        .btn-primary {
            background: #5A7EFC;
            color: #fff;
        }
        .btn-primary:hover {
            background: #0c56d6;
        }
        .btn-secondary {
            background: #28a745;
            color: #fff;
        }
        .btn-secondary:hover {
            background: #1e7e34;
        }
        @media print {
            .actions { display: none; }
            body { background: #fff; }
            .container { box-shadow: none; border: none; }
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Bukti Pendaftaran Seni</h1>
        <p class="subtitle">Dokumen resmi sebagai bukti pendaftaran</p>
        
        <?php if (!empty($sanggar)): ?>
        <h2>Detail Sanggar</h2>
        <table>
            <tr><th>Nama Sanggar</th><td><?= htmlspecialchars($sanggar->nama_sanggar) ?></td></tr>
            <tr><th>NRK Sanggar</th><td><?= htmlspecialchars($sanggar->nrk_sanggar) ?></td></tr>
            <tr><th>Alamat Sanggar</th><td><?= htmlspecialchars($sanggar->alamat) ?></td></tr>
            
            <tr>
                <th>Jenis Seni</th>
                <td>
                    <?php if (!empty($jenis_seni_list)): ?>
                        <ul>
                            <?php foreach ($jenis_seni_list as $seni): ?>
                                <li><?= htmlspecialchars($seni->nama_seni); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    <?php else: ?>
                        Tidak ada data jenis seni.
                    <?php endif; ?>
                </td>
            </tr>
            <tr><th>Deskripsi Sanggar</th><td><?= htmlspecialchars($sanggar->deskripsi) ?></td></tr>
            <tr><th>Tanggal Pendaftaran</th><td><?= date('d M Y H:i:s', strtotime($sanggar->created_at)) ?></td></tr>
        </table>

        <h2>Daftar Pengurus</h2>
        <table>
            <thead>
                <tr>
                    <th>Nama</th>
                    <th>NRK</th>
                    <th>NIK</th>
                    <th>Peran</th>
                    <th>No. HP</th>
                    <th>Jenis Kelamin</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($pengurus)): ?>
                    <?php foreach ($pengurus as $p): ?>
                    <tr>
                        <td><?= htmlspecialchars($p->nama_lengkap) ?></td>
                        <td><?= htmlspecialchars($p->nrk_perorangan) ?></td>
                        <td><?= htmlspecialchars($p->nik) ?></td>
                        <td><?= htmlspecialchars($p->nama_peran) ?></td>
                        <td><?= htmlspecialchars($p->no_hp) ?></td>
                        <td><?= htmlspecialchars($p->jenis_kelamin) ?></td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="6" style="text-align:center;">Tidak ada data pengurus.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>

        <h2>Daftar Anggota</h2>
        <table>
            <thead>
                <tr>
                    <th>Nama</th>
                    <th>NIK</th>
                    <th>Level</th>
                    <th>No. HP</th>
                    <th>Jenis Kelamin</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($anggota)): ?>
                    <?php foreach ($anggota as $a): ?>
                    <tr>
                        <td><?= htmlspecialchars($a->nama_anggota) ?></td>
                        <td><?= htmlspecialchars($a->nik) ?></td>
                        <td><?= htmlspecialchars($a->nama_level) ?></td>
                        <td><?= htmlspecialchars($a->nomor_hp) ?></td>
                        <td><?= htmlspecialchars($a->jenis_kelamin) ?></td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="5" style="text-align:center;">Tidak ada data anggota.</td></tr>
                <?php endif; ?>
            </tbody>
        </table>

        <?php elseif (!empty($pendaftar)): ?>
    <h2>Detail Pendaftar</h2>
    <table>
        <tr><th>Nama Pendaftar</th><td><?= htmlspecialchars($pendaftar->nama_lengkap) ?></td></tr>
        <tr><th>NRK</th><td><?= htmlspecialchars($pendaftar->nrk_perorangan) ?></td></tr>
        <tr><th>NIK</th><td><?= htmlspecialchars($pendaftar->nik) ?></td></tr>
        <tr><th>Alamat</th><td><?= htmlspecialchars($pendaftar->alamat) ?></td></tr>
        <tr><th>No. HP</th><td><?= htmlspecialchars($pendaftar->no_hp) ?></td></tr>
        <tr><th>Jenis Kelamin</th><td><?= htmlspecialchars($pendaftar->jenis_kelamin) ?></td></tr>
        
        <tr>
            <th>Jenis Seni</th>
            <td>
                <?php if (!empty($jenis_seni_list)): ?>
                    <ul>
                        <?php foreach ($jenis_seni_list as $seni): ?>
                            <li><?= htmlspecialchars($seni->nama_seni) ?></li>
                        <?php endforeach; ?>
                    </ul>
                <?php else: ?>
                    <p>Tidak ada jenis seni yang dipilih.</p>
                <?php endif; ?>
            </td>
        </tr>
        <tr><th>Tanggal Pendaftaran</th><td><?= date('d M Y H:i:s', strtotime($pendaftar->created_at)) ?></td></tr>
    </table>
<?php endif; ?>

<div class="signature">
    <p><?= date('d M Y') ?></p>
    <p><strong>(Panitia Pendaftaran)</strong></p>
</div>

<div class="actions">
    <p>Simpan bukti ini sebagai referensi resmi</p>
    <a href="#" class="btn btn-secondary" onclick="window.print()">🖨 Cetak / Simpan PDF</a>
    <a href="<?= base_url('pendaftaran/dashboard'); ?>" class="btn btn-primary">⬅ Kembali ke Halaman Utama</a>
</div>
</div>
</body>
</html>