<?php $this->load->view('templates/header_user'); ?>

<style>
    :root {
        --primary-color: #5A7EFC;
        --secondary-color: #28a745;
        --info-color: #17a2b8;
        --warning-color: #ffc107;
        --danger-color: #dc3545;
        --light-bg: #f8f9fa;
        --card-bg: #ffffff;
        --text-color: #343a40;
    }

    body {
        background-color: var(--light-bg);
        font-family: 'Poppins', sans-serif;
    }

    .biodata-container {
        max-width: 1000px;
        margin: auto;
    }

    .main-card {
        background-color: var(--card-bg);
        border-radius: 25px;
        box-shadow: 0 12px 25px rgba(0, 0, 0, 0.08);
        padding: 40px;
        margin-top: 20px;
    }

    .card-section {
        margin-bottom: 30px;
        border-radius: 20px;
        overflow: hidden;
        border: 1px solid #e9ecef;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        transition: transform 0.3s ease;
    }

    .card-section:hover {
        transform: translateY(-5px);
    }

    .card-header-custom {
        padding: 18px 30px;
        font-weight: 700;
        font-size: 1.1rem;
        display: flex;
        align-items: center;
        gap: 12px;
        color: white;
    }

    .header-profile {
        background-image: linear-gradient(135deg, var(--primary-color), #4a6bff);
    }
    
    .header-seni {
        background-image: linear-gradient(135deg, #6f42c1, #8f6ed5);
    }

    .header-riwayat {
        background-image: linear-gradient(135deg, var(--secondary-color), #4cd154);
    }
    
    .header-pendidikan {
        background-image: linear-gradient(135deg, #17a2b8, #42a9b3);
    }

    .header-pekerjaan {
        background-image: linear-gradient(135deg, #ffc107, #ffcf40);
        color: var(--text-color);
    }
    
    .header-aktivitas {
        background-image: linear-gradient(135deg, #dc3545, #e35a63);
    }
    
    .header-penghargaan {
        background-image: linear-gradient(135deg, #20c997, #4ee3be);
    }


    .card-body-custom {
        padding: 30px;
    }

    .btn-sm-custom {
        font-size: 0.85rem;
        padding: 8px 16px;
        border-radius: 50px;
        font-weight: 500;
        transition: all 0.3s ease;
    }
    
    .btn-custom {
        font-size: 0.9rem;
        padding: 10px 20px;
        border-radius: 50px;
        font-weight: 500;
        transition: all 0.3s ease;
    }

    .profile-info-grid {
        display: grid;
        grid-template-columns: 1fr 3fr;
        gap: 40px;
        align-items: center;
    }

    .profile-image-container {
        width: 180px;
        height: 180px;
        justify-self: center;
    }
    
    .profile-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
        border-radius: 50%;
        border: 5px solid #fff;
        box-shadow: 0 6px 15px rgba(0, 0, 0, 0.15);
    }
    
    .profile-placeholder {
        width: 100%;
        height: 100%;
        border-radius: 50%;
        background-color: #e9ecef;
        color: #adb5bd;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 5rem;
        border: 4px dashed #ced4da;
    }

    .profile-details-list {
        display: grid;
        grid-template-columns: 1fr 2fr;
        gap: 15px;
    }
    
    .profile-details-list dt {
        font-weight: 600;
        color: #555;
    }

    .list-group-item {
        border-radius: 12px;
        transition: background-color 0.3s ease;
        padding: 15px 20px;
    }

    .list-group-item:hover {
        background-color: var(--light-bg);
    }
    
    .form-card {
        border-radius: 12px;
        border: 1px solid #e9ecef;
        background-color: #fefefe;
    }
</style>

<div class="container py-5 biodata-container">
    <h2 class="fw-bold text-center mb-5 text-primary">Biodata Perorangan</h2>
    

    <?php if ($this->session->flashdata('success')): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <?= $this->session->flashdata('success'); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php elseif ($this->session->flashdata('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <?= $this->session->flashdata('error'); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="main-card">
        <?php if (!$pendaftar): ?>
            <div class="alert alert-warning text-center">
                Kamu belum melakukan pendaftaran.
                <a href="<?= site_url('pendaftaran'); ?>" class="btn btn-sm-custom btn-primary ms-2">Daftar Sekarang</a>
            </div>
        <?php else: ?>

            <div class="card-section">
                <div class="card-header-custom header-profile">
                    <i class="fas fa-user-circle"></i><span>Profil</span>
                </div>
                <div class="card-body-custom">
                    <div class="profile-info-grid">
                        <div class="profile-image-container">
                            <?php if (!empty($pendaftar->pas_foto)): ?>
                                <img src="<?= base_url('assets/uploads/foto_sdm/' . htmlspecialchars($pendaftar->pas_foto)); ?>" 
                                     alt="Pas Foto" class="profile-image">
                            <?php else: ?>
                                <div class="profile-placeholder"><i class="fas fa-user"></i></div>
                            <?php endif; ?>
                        </div>
                        <div class="profile-details-list">
                            <dt>Nama Lengkap</dt><dd><?= htmlspecialchars($pendaftar->nama_lengkap); ?></dd>
                            <dt>Alias</dt><dd><?= htmlspecialchars($pendaftar->nama_alias); ?></dd>
                            <dt>NIK</dt><dd><?= htmlspecialchars($pendaftar->nik); ?></dd>
                            <dt>NRK</dt><dd><?= htmlspecialchars($pendaftar->nrk_perorangan); ?></dd>
                            <dt>Jenis Kelamin</dt><dd><?= $pendaftar->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan'; ?></dd>
                            <dt>Agama</dt><dd><?= htmlspecialchars($pendaftar->agama); ?></dd>
                            <dt>TTL</dt><dd><?= htmlspecialchars($pendaftar->tempat_lahir); ?>, <?= date('d M Y', strtotime($pendaftar->tanggal_lahir)); ?></dd>
                            <dt>Kewarganegaraan</dt><dd><?= htmlspecialchars($pendaftar->kewarganegaraan); ?></dd>
                            <dt>Gelar Pendidikan</dt><dd><?= htmlspecialchars($pendaftar->gelar_pendidikan); ?></dd>
                            <dt>No HP</dt><dd><?= htmlspecialchars($pendaftar->no_hp); ?></dd>
                            <dt>Email</dt><dd><?= htmlspecialchars($pendaftar->email); ?></dd>
                            <dt>Alamat</dt><dd><?= htmlspecialchars($pendaftar->alamat); ?></dd>
                        </div>
                    </div>
                    <div class="mt-4 d-flex justify-content-end">
                        <a href="<?= site_url('pendaftaran/edit_pendaftar/'.$pendaftar->id_sdm); ?>" class="btn btn-warning btn-custom me-2"><i class="fas fa-edit me-2"></i>Edit Profil</a>
                        <a href="<?= site_url('pendaftaran/hapus_pendaftar/'.$pendaftar->id_sdm); ?>" 
                           class="btn btn-danger btn-custom" onclick="return confirm('Hapus semua data biodata ini?')"><i class="fas fa-trash me-2"></i>Hapus Profil</a>
                    </div>
                </div>
            </div>

            <div class="card-section">
                <div class="card-header-custom header-seni">
                    <i class="fas fa-palette"></i><span>Seni yang Didaftarkan</span>
                </div>
                <div class="card-body-custom">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h6 class="mb-0 fw-bold text-primary">Daftar Seni</h6>
                        <a href="<?= site_url('pendaftaran/tambah_seni_perorangan/' . $pendaftar->id_sdm); ?>" class="btn btn-primary btn-sm-custom">➕ Tambah Seni</a>
                    </div>
                    <?php if (!empty($seni)): ?>
                        <ul class="list-group list-group-flush">
                            <?php foreach ($seni as $s): ?>
                                <li class="list-group-item d-flex justify-content-between align-items-center mb-2 rounded shadow-sm">
                                    <div>
                                        <h5 class="mb-0 text-dark"><?= htmlspecialchars($s->nama_seni ?? '-'); ?></h5>
                                        <?php if (!empty($s->deskripsi)): ?>
                                            <p class="mb-0 text-muted small"><?= htmlspecialchars($s->deskripsi); ?></p>
                                        <?php endif; ?>
                                    </div>
                                    <div class="d-flex flex-nowrap gap-2">
                                        <a href="<?= site_url('pendaftaran/edit_seni/' . ($s->id ?? 0)); ?>" class="btn btn-warning btn-sm-custom"><i class="fas fa-edit"></i></a>
                                        <a href="<?= site_url('pendaftaran/hapus_seni/' . ($s->id ?? 0)); ?>" 
                                           class="btn btn-danger btn-sm-custom"
                                           onclick="return confirm('Hapus seni ini?')"><i class="fas fa-trash"></i></a>
                                    </div>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    <?php else: ?>
                        <div class="alert alert-info mb-0">Belum ada seni yang didaftarkan.</div>
                    <?php endif; ?>
                </div>
            </div>

            <div class="card-section">
                <div class="card-header-custom header-riwayat">
                    <i class="fas fa-history"></i><span>Riwayat</span>
                </div>
                <div class="card-body-custom">

                    <div class="card-section mb-4">
                        <div class="card-header-custom header-pendidikan">
                            <i class="fas fa-graduation-cap"></i><span>Pendidikan</span>
                        </div>
                        <div class="card-body-custom">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h6 class="mb-0 fw-bold text-info">Daftar Pendidikan</h6>
                                <button type="button" 
                                        class="btn btn-info btn-sm-custom tambah-riwayat" 
                                        data-riwayat="pendidikan">
                                    ➕ Tambah Pendidikan
                                </button>
                            </div>
                            <div id="pendidikan-form-list"></div>
                            <?php if (!empty($pendidikan)): ?>
                                <ul class="list-group mt-3 list-group-flush">
                                    <?php foreach ($pendidikan as $p): ?>
                                        <li class="list-group-item d-flex justify-content-between align-items-center rounded shadow-sm">
                                            <div>
                                                <h5 class="mb-0 text-dark"><?= htmlspecialchars($p->nama_sekolah ?? '-'); ?></h5>
                                                <p class="mb-0 text-muted small">
                                                    Jenjang: <?= htmlspecialchars($p->jenjang ?? '-'); ?> | Program Studi: <?= htmlspecialchars($p->program_studi ?? '-'); ?><br>
                                                    Tahun Lulus: <?= htmlspecialchars($p->tahun_lulus ?? '-'); ?>
                                                </p>
                                            </div>
                                            <div class="d-flex flex-nowrap gap-2">
                                                <a href="<?= site_url('pendaftaran/hapus_pendidikan/' . ($p->id ?? 0)); ?>" 
                                                   class="btn btn-danger btn-sm-custom" onclick="return confirm('Hapus riwayat ini?')"><i class="fas fa-trash"></i></a>
                                            </div>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php else: ?>
                                <div class="alert alert-info mb-0">Belum ada data pendidikan.</div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="card-section mb-4">
                        <div class="card-header-custom header-pekerjaan">
                            <i class="fas fa-chalkboard-teacher"></i><span>Pelatihan</span>
                        </div>
                        <div class="card-body-custom">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h6 class="mb-0 fw-bold text-warning">Daftar Pelatihan</h6>
                                <button type="button" class="btn btn-warning btn-sm-custom tambah-riwayat" data-riwayat="pelatihan">
                                    ➕ Tambah Pelatihan
                                </button>
                            </div>
                            <div id="pelatihan-form-list"></div>
                            <?php if (!empty($pelatihan)): ?>
                                <ul class="list-group mt-3 list-group-flush">
                                    <?php foreach ($pelatihan as $pl): ?>
                                        <li class="list-group-item d-flex justify-content-between align-items-center rounded shadow-sm">
                                            <div>
                                                <h5 class="mb-0 text-dark"><?= htmlspecialchars($pl->nama_pelatihan ?? '-'); ?></h5>
                                                <p class="mb-0 text-muted small">
                                                    Tingkat: <?= htmlspecialchars($pl->tingkat_pelatihan ?? '-'); ?> | Tahun: <?= htmlspecialchars($pl->tahun ?? '-'); ?><br>
                                                    Penyelenggara: <?= htmlspecialchars($pl->penyelenggara ?? '-'); ?> | Peran: <?= htmlspecialchars($pl->peran ?? '-'); ?>
                                                </p>
                                                <?php if (!empty($pl->bukti_sertifikat)): ?>
                                                    <div class="mt-2">
                                                        <a href="<?= base_url('assets/uploads/pelatihan/' . htmlspecialchars($pl->bukti_sertifikat)); ?>" target="_blank" class="btn btn-sm-custom btn-info text-white">Lihat Sertifikat</a>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                            <div class="d-flex flex-nowrap gap-2">
                                                <a href="<?= site_url('pendaftaran/hapus_pelatihan/' . ($pl->id ?? 0)); ?>" class="btn btn-danger btn-sm-custom" onclick="return confirm('Hapus riwayat ini?')"><i class="fas fa-trash"></i></a>
                                            </div>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php else: ?>
                                <div class="alert alert-warning mb-0">Belum ada data pelatihan.</div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="card-section mb-4">
                        <div class="card-header-custom header-pekerjaan">
                            <i class="fas fa-briefcase"></i><span>Pekerjaan</span>
                        </div>
                        <div class="card-body-custom">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h6 class="mb-0 fw-bold text-warning">Daftar Pekerjaan</h6>
                                <button type="button" class="btn btn-warning btn-sm-custom tambah-riwayat" data-riwayat="pekerjaan">
                                    ➕ Tambah Pekerjaan
                                </button>
                            </div>
                            <div id="pekerjaan-form-list"></div>
                            <?php if (!empty($pekerjaan)): ?>
                                <ul class="list-group mt-3 list-group-flush">
                                    <?php foreach ($pekerjaan as $pk): ?>
                                        <li class="list-group-item d-flex justify-content-between align-items-center rounded shadow-sm">
                                            <div>
                                                <h5 class="mb-0 text-dark"><?= htmlspecialchars($pk->nama_tempat_kerja ?? '-'); ?></h5>
                                                <p class="mb-0 text-muted small">
                                                    Pekerjaan: <?= htmlspecialchars($pk->pekerjaan ?? '-'); ?> | Jabatan: <?= htmlspecialchars($pk->jabatan ?? '-'); ?><br>
                                                    Status: <?= htmlspecialchars($pk->status ?? '-'); ?> | Periode: <?= htmlspecialchars($pk->mulai_kerja ?? '-'); ?> - <?= htmlspecialchars($pk->selesai_kerja ?? 'Sekarang'); ?>
                                                </p>
                                            </div>
                                            <div class="d-flex flex-nowrap gap-2">
                                                <a href="<?= site_url('pendaftaran/hapus_pekerjaan/' . ($pk->id ?? 0)); ?>" class="btn btn-danger btn-sm-custom" onclick="return confirm('Hapus riwayat ini?')"><i class="fas fa-trash"></i></a>
                                            </div>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php else: ?>
                                <div class="alert alert-warning mb-0">Belum ada data pekerjaan.</div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="card-section mb-4">
                        <div class="card-header-custom header-aktivitas">
                            <i class="fas fa-running"></i><span>Aktivitas</span>
                        </div>
                        <div class="card-body-custom">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h6 class="mb-0 fw-bold text-danger">Daftar Aktivitas</h6>
                                <button type="button" class="btn btn-danger btn-sm-custom tambah-riwayat" data-riwayat="aktivitas">
                                    ➕ Tambah Aktivitas
                                </button>
                            </div>
                            <div id="aktivitas-form-list"></div>
                            <?php if (!empty($aktivitas)): ?>
                                <ul class="list-group mt-3 list-group-flush">
                                    <?php foreach ($aktivitas as $a): ?>
                                        <li class="list-group-item d-flex justify-content-between align-items-center rounded shadow-sm">
                                            <div>
                                                <h5 class="mb-0 text-dark"><?= htmlspecialchars($a->nama_kegiatan ?? '-'); ?></h5>
                                                <p class="mb-0 text-muted small">
                                                    Peran: <?= htmlspecialchars($a->peran ?? '-'); ?> | Penyelenggara: <?= htmlspecialchars($a->penyelenggara ?? '-'); ?><br>
                                                    Tingkat: <?= htmlspecialchars($a->tingkat ?? '-'); ?> | Tahun: <?= htmlspecialchars($a->tahun ?? '-'); ?>
                                                </p>
                                            </div>
                                            <div class="d-flex flex-nowrap gap-2">
                                                <a href="<?= site_url('pendaftaran/hapus_aktivitas/' . ($a->id ?? 0)); ?>" class="btn btn-danger btn-sm-custom" onclick="return confirm('Hapus riwayat ini?')"><i class="fas fa-trash"></i></a>
                                            </div>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php else: ?>
                                <div class="alert alert-danger-light mb-0">Belum ada data aktivitas.</div>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="card-section mb-4">
                        <div class="card-header-custom header-penghargaan">
                            <i class="fas fa-award"></i><span>Penghargaan</span>
                        </div>
                        <div class="card-body-custom">
                            <div class="d-flex justify-content-between align-items-center mb-3">
                                <h6 class="mb-0 fw-bold text-success">Daftar Penghargaan</h6>
                                <button type="button" class="btn btn-success btn-sm-custom tambah-riwayat" data-riwayat="penghargaan">
                                    ➕ Tambah Penghargaan
                                </button>
                            </div>
                            <div id="penghargaan-form-list"></div>
                            <?php if (!empty($penghargaan)): ?>
                                <ul class="list-group mt-3 list-group-flush">
                                    <?php foreach ($penghargaan as $ph): ?>
                                        <li class="list-group-item d-flex justify-content-between align-items-center rounded shadow-sm">
                                            <div>
                                                <h5 class="mb-0 text-dark"><?= htmlspecialchars($ph->nama_penghargaan ?? '-'); ?></h5>
                                                <p class="mb-0 text-muted small">
                                                    Tahun: <?= htmlspecialchars($ph->tahun ?? '-'); ?> | Peran: <?= htmlspecialchars($ph->peran ?? '-'); ?><br>
                                                    Pemberi: <?= htmlspecialchars($ph->pemberi ?? '-'); ?> | Tingkat: <?= htmlspecialchars($ph->tingkat ?? '-'); ?>
                                                </p>
                                                <?php if (!empty($ph->bukti_penghargaan)): ?>
                                                    <div class="mt-2">
                                                        <a href="<?= base_url('assets/uploads/penghargaan/' . htmlspecialchars($ph->bukti_penghargaan)); ?>" target="_blank" class="btn btn-sm-custom btn-info text-white">Lihat Bukti</a>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                            <div class="d-flex flex-nowrap gap-2">
                                                <a href="<?= site_url('pendaftaran/hapus_penghargaan/' . ($ph->id ?? 0)); ?>" class="btn btn-danger btn-sm-custom" onclick="return confirm('Hapus riwayat ini?')"><i class="fas fa-trash"></i></a>
                                            </div>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php else: ?>
                                <div class="alert alert-success-light mb-0">Belum ada data penghargaan.</div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
    var base_url = "<?= base_url(); ?>"; // untuk CodeIgniter
</script>

<script>
$(document).ready(function() {
    // template form dinamis
    function getFormTemplate(type) {
        const id_sdm = "<?= $pendaftar->id_sdm; ?>";
        switch(type) {
            case 'pendidikan':
                return `
                <div class="form-card card p-4 mb-3 shadow-sm">
                    <h6 class="fw-bold mb-3">Tambah Riwayat Pendidikan</h6>
                    <input type="text" name="jenjang" class="form-control mb-3" placeholder="Jenjang" required>
                    <input type="text" name="program_studi" class="form-control mb-3" placeholder="Program Studi" required>
                    <input type="text" name="nama_sekolah" class="form-control mb-3" placeholder="Nama Sekolah" required>
                    <input type="text" name="tahun_lulus" class="form-control mb-3" placeholder="Tahun Lulus" required>
                    <div class="d-flex justify-content-end gap-2 mt-3">
                        <button type="button" class="btn btn-success btn-sm-custom simpan-form" data-type="pendidikan">Simpan</button>
                        <button type="button" class="btn btn-danger btn-sm-custom hapus-form">Batal</button>
                    </div>
                </div>`;
            case 'pelatihan':
                return `
                <div class="form-card card p-4 mb-3 shadow-sm">
                    <h6 class="fw-bold mb-3">Tambah Riwayat Pelatihan</h6>
                    <input type="text" name="nama_pelatihan" class="form-control mb-3" placeholder="Nama Pelatihan" required>
                    <input type="text" name="tingkat_pelatihan" class="form-control mb-3" placeholder="Tingkat Pelatihan" required>
                    <input type="text" name="tahun" class="form-control mb-3" placeholder="Tahun" required>
                    <input type="text" name="jenis_pelatihan" class="form-control mb-3" placeholder="Jenis Pelatihan" required>
                    <input type="text" name="peran" class="form-control mb-3" placeholder="Peran" required>
                    <input type="text" name="penyelenggara" class="form-control mb-3" placeholder="Penyelenggara" required>
                    <label class="form-label mt-2"><strong>Bukti Sertifikat</strong></label>
                    <input type="file" name="bukti_sertifikat" class="form-control mb-3" accept="image/*,application/pdf">
                    <div class="d-flex justify-content-end gap-2 mt-3">
                        <button type="button" class="btn btn-success btn-sm-custom simpan-form" data-type="pelatihan">Simpan</button>
                        <button type="button" class="btn btn-danger btn-sm-custom hapus-form">Batal</button>
                    </div>
                </div>`;
            case 'pekerjaan':
                return `
                <div class="form-card card p-4 mb-3 shadow-sm">
                    <h6 class="fw-bold mb-3">Tambah Riwayat Pekerjaan</h6>
                    <input type="text" name="nama_pekerjaan" class="form-control mb-3" placeholder="Pekerjaan" required>
                    <input type="text" name="jabatan" class="form-control mb-3" placeholder="Jabatan" required>
                    <input type="text" name="nama_tempat_kerja" class="form-control mb-3" placeholder="Nama Tempat Kerja" required>
                    <input type="text" name="status" class="form-control mb-3" placeholder="Status" required>
                    <label class="form-label mt-2"><strong>Periode Kerja</strong></label>
                    <div class="d-flex gap-2">
                        <input type="date" name="mulai_kerja" class="form-control mb-3" placeholder="Mulai Kerja" required>
                        <input type="date" name="selesai_kerja" class="form-control mb-3" placeholder="Selesai Kerja (Opsional)">
                    </div>
                    <div class="d-flex justify-content-end gap-2 mt-3">
                        <button type="button" class="btn btn-success btn-sm-custom simpan-form" data-type="pekerjaan">Simpan</button>
                        <button type="button" class="btn btn-danger btn-sm-custom hapus-form">Batal</button>
                    </div>
                </div>`;
            case 'aktivitas':
                return `
                <div class="form-card card p-4 mb-3 shadow-sm">
                    <h6 class="fw-bold mb-3">Tambah Riwayat Aktivitas</h6>
                    <input type="text" name="nama_kegiatan" class="form-control mb-3" placeholder="Nama Aktivitas" required>
                    <input type="text" name="peran" class="form-control mb-3" placeholder="Peran" required>
                    <input type="text" name="penyelenggara" class="form-control mb-3" placeholder="Penyelenggara" required>
                    <input type="text" name="tingkat" class="form-control mb-3" placeholder="Tingkat" required>
                    <input type="text" name="tahun" class="form-control mb-3" placeholder="Tahun" required>
                    <div class="d-flex justify-content-end gap-2 mt-3">
                        <button type="button" class="btn btn-success btn-sm-custom simpan-form" data-type="aktivitas">Simpan</button>
                        <button type="button" class="btn btn-danger btn-sm-custom hapus-form">Batal</button>
                    </div>
                </div>`;
            case 'penghargaan':
                return `
                <div class="form-card card p-4 mb-3 shadow-sm">
                    <h6 class="fw-bold mb-3">Tambah Riwayat Penghargaan</h6>
                    <input type="text" name="nama_penghargaan" class="form-control mb-3" placeholder="Nama Penghargaan" required>
                    <input type="text" name="tahun" class="form-control mb-3" placeholder="Tahun" required>
                    <input type="text" name="peran" class="form-control mb-3" placeholder="Peran" required>
                    <input type="text" name="pemberi" class="form-control mb-3" placeholder="Pemberi Penghargaan" required>
                    <input type="text" name="tingkat" class="form-control mb-3" placeholder="Tingkat" required>
                    <label class="form-label mt-2"><strong>Bukti Penghargaan</strong></label>
                    <input type="file" name="bukti_penghargaan" class="form-control mb-3" accept=".jpg,.jpeg,.png,.pdf">
                    <div class="d-flex justify-content-end gap-2 mt-3">
                        <button type="button" class="btn btn-success btn-sm-custom simpan-form" data-type="penghargaan">Simpan</button>
                        <button type="button" class="btn btn-danger btn-sm-custom hapus-form">Batal</button>
                    </div>
                </div>`;
        }
    }

    // tombol tambah
    $(".tambah-riwayat").on("click", function() {
        const jenis = $(this).data("riwayat");
        $(`#${jenis}-form-list`).append(getFormTemplate(jenis));
    });

    // tombol hapus form
    $(document).on("click", ".hapus-form", function() {
        $(this).closest(".form-card").remove();
    });

    // tombol simpan form
    $(document).on("click", ".simpan-form", function() {
        const formCard = $(this).closest(".form-card");
        const type = $(this).data("type");
        const id_sdm = "<?= $pendaftar->id_sdm; ?>";

        let formData = new FormData();
        formData.append("id_sdm", id_sdm);

        let isValid = true;
        // ambil semua input
        formCard.find("input[required]").each(function() {
            if ($(this).val() === "") {
                isValid = false;
                $(this).addClass("is-invalid");
            } else {
                $(this).removeClass("is-invalid");
            }
        });

        if (!isValid) {
            alert("Harap lengkapi semua data yang wajib diisi!");
            return;
        }

        formCard.find("input").each(function() {
            const name = $(this).attr("name");
            if ($(this).attr("type") === "file") {
                if (this.files[0]) {
                    formData.append(name, this.files[0]);
                }
            } else {
                formData.append(name, $(this).val());
            }
        });

        // Tampilkan loading saat request
        const simpanButton = $(this);
        const originalButtonText = simpanButton.html();
        simpanButton.attr("disabled", true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> Loading...');

        $.ajax({
            url: base_url + "pendaftaran/simpan_" + type,
            method: "POST",
            data: formData,
            processData: false,
            contentType: false,
            success: function(res) {
                alert("Data " + type + " berhasil disimpan!");
                location.reload();
            },
            error: function(xhr) {
                console.log(xhr.responseText);
                alert("Gagal menyimpan data " + type);
                simpanButton.attr("disabled", false).html(originalButtonText);
            }
        });
    });
});
</script>
<?php $this->load->view('templates/footer_user'); ?>