<?php $this->load->view('templates/header_user'); ?>

<style>
/* --- STYLING BARU UNTUK BIODATA SANGGAR --- */
body {
    background-color: #f4f7f9; /* Latar belakang abu-abu kebiruan muda */
    font-family: 'Inter', sans-serif; /* Font modern */
}

.biodata-container { 
    max-width: 1100px; 
    margin: auto; 
    padding: 3rem 1rem;
}

.main-card {
    background-color: #fff; 
    border-radius: 25px;
    box-shadow: 0 15px 45px rgba(0,0,0,0.1); 
    padding: 2.5rem;
}

.card-section {
    margin-bottom: 2.5rem; 
    border-radius: 18px; 
    overflow: hidden; /* Penting untuk header gradient */
    border: none;
    box-shadow: 0 5px 20px rgba(0,0,0,0.05);
}

.card-header-custom { 
    padding: 1.5rem 2rem; 
    font-weight: 700; 
    display: flex; 
    align-items: center; 
    gap: 12px; 
    font-size: 1.25rem;
    color: #fff;
    /* Menambahkan Justify Content untuk memisahkan judul dan tombol */
    justify-content: space-between;
}
/* Menambahkan styling untuk tombol di header */
.card-header-buttons {
    display: flex;
    gap: 10px;
}
/* Menambahkan styling untuk aksi di tabel */
.btn-action {
    display: flex;
    gap: 5px;
}

/* Gradient Colors */
.header-sanggar { 
    background-image: linear-gradient(45deg, #4c68d7, #6982e5); 
}
.header-pengurus { 
    background-image: linear-gradient(45deg, #00b09b, #96c93d); 
}
.header-anggota { 
    background-image: linear-gradient(45deg, #ef476f, #ffd166); 
}
/* Menambahkan gradient untuk Jenis Seni */
.header-seni {
    background-image: linear-gradient(45deg, #f7971e, #ff8c00);
}


.card-body-custom { 
    padding: 2rem; 
    background-color: #fff;
}

/* Mengubah .data-row agar lebih rapi */
.data-item {
    display: flex;
    justify-content: space-between;
    padding: 0.75rem 0;
    border-bottom: 1px solid #eef1f3;
}

.data-item:last-child {
    border-bottom: none;
}
.data-label {
    font-weight: 500;
    color: #555;
    flex-basis: 35%; /* Memberikan lebar tetap untuk label */
}
.data-value {
    font-weight: 600;
    color: #222;
    flex-grow: 1; /* Nilai akan mengisi sisa ruang */
}

.table-responsive {
    border-radius: 15px;
    overflow: hidden;
}

.table-custom {
    font-size: 0.9rem;
}

.table-custom thead {
    background-color: #f8f9fa;
    color: #495057;
}

.table-custom tbody tr:nth-child(even) {
    background-color: #fcfdfe;
}
.table-custom tbody tr:hover {
    background-color: #e9f5ff;
}

.badge-status {
    padding: 0.5em 1em;
    border-radius: 20px;
    font-weight: 600;
}
</style>

<div class="container biodata-container">
    <h2 class="fw-bold text-center mb-5" style="color: #333;">Biodata Sanggar Seni</h2>

    <?php if ($this->session->flashdata('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?= $this->session->flashdata('success'); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php elseif ($this->session->flashdata('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?= $this->session->flashdata('error'); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <div class="main-card">
        <div class="card-section">
            <div class="card-header-custom header-sanggar">
                <div class="d-flex align-items-center gap-2">
                    <i class="fas fa-landmark"></i><span>Profil Sanggar</span>
                </div>
                <div class="card-header-buttons">
                    <?php if ($sanggar): ?>
                        <a href="<?= base_url('pendaftaran/edit_sanggar/' . $sanggar->id_sanggar); ?>" class="btn btn-sm btn-outline-light d-flex align-items-center" title="Edit Profil">
                            <i class="fas fa-edit me-1"></i> Edit
                        </a>
                        <a href="<?= base_url('sanggar/hapus_profil/' . $sanggar->id_sanggar); ?>" class="btn btn-sm btn-outline-light d-flex align-items-center" title="Hapus Profil" onclick="return confirm('Apakah Anda yakin ingin menghapus profil sanggar ini?');">
                            <i class="fas fa-trash-alt me-1"></i> Hapus
                        </a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="card-body-custom">
                <?php if ($sanggar): ?>
                    <div class="data-item"><span class="data-label">NRK Sanggar:</span> <strong class="data-value"><?= htmlspecialchars($sanggar->nrk_sanggar ?? '-'); ?></strong></div>
                    <div class="data-item"><span class="data-label">Nama Sanggar:</span> <strong class="data-value"><?= htmlspecialchars($sanggar->nama_sanggar); ?></strong></div>
                    <div class="data-item"><span class="data-label">Jenis Lembaga:</span> <strong class="data-value"><?= htmlspecialchars($sanggar->jenis_lembaga ?? '-'); ?></strong></div>
                    <div class="data-item"><span class="data-label">Status Hukum:</span> <strong class="data-value"><?= htmlspecialchars($sanggar->status_hukum ?? '-'); ?></strong></div>
                    <div class="data-item"><span class="data-label">Nomor Identitas:</span> <strong class="data-value"><?= htmlspecialchars($sanggar->nomor_identitas ?? '-'); ?></strong></div>
                    <div class="data-item"><span class="data-label">Tanggal Berdiri:</span> <strong class="data-value"><?= $sanggar->tanggal_berdiri ? date('d M Y', strtotime($sanggar->tanggal_berdiri)) : '-'; ?></strong></div>
                    <div class="data-item"><span class="data-label">Tujuan:</span> <strong class="data-value"><?= htmlspecialchars($sanggar->tujuan ?? '-'); ?></strong></div>
                    <div class="data-item"><span class="data-label">Deskripsi:</span> <strong class="data-value"><?= htmlspecialchars($sanggar->deskripsi ?? '-'); ?></strong></div>
                    <div class="data-item"><span class="data-label">Status Kepemilikan:</span> <strong class="data-value"><?= htmlspecialchars($sanggar->status_kepemilikan ?? '-'); ?></strong></div>
                    <div class="data-item"><span class="data-label">Nama Pemilik:</span> <strong class="data-value"><?= htmlspecialchars($sanggar->nama_pemilik ?? '-'); ?></strong></div>
                    <div class="data-item"><span class="data-label">No. HP:</span> <strong class="data-value"><?= htmlspecialchars($sanggar->no_hp ?? '-'); ?></strong></div>
                    <div class="data-item"><span class="data-label">Alamat:</span> <strong class="data-value"><?= htmlspecialchars($sanggar->alamat ?? '-'); ?></strong></div>
                <?php else: ?>
                    <div class="alert alert-warning mb-0">Data sanggar belum ada.</div>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="card-section">
    <div class="card-header-custom header-seni">
        <div class="d-flex align-items-center gap-2">
            <i class="fas fa-palette"></i><span>Jenis Seni</span>
        </div>
        <div class="card-header-buttons">
            <a href="<?= base_url('pendaftaran/tambah_seni_sanggar/' . ($sanggar->id_sanggar ?? '')); ?>" class="btn btn-sm btn-outline-light d-flex align-items-center" title="Tambah Jenis Seni">
                <i class="fas fa-plus-circle me-1"></i> Tambah
            </a>
        </div>
    </div>
    <div class="card-body-custom">
        <?php if (!empty($seni)): ?>
            <div class="table-responsive">
                <table class="table table-bordered table-custom">
                    <thead>
                        <tr>
                            <th>Nama Seni</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($seni as $s): ?>
                            <tr>
                                <td><?= htmlspecialchars($s->nama_seni); ?></td>
                                <td>
                                    <div class="btn-action">
                                    <a href="<?= base_url('pendaftaran/edit_jenis_seni_single/' . $sanggar->id_sanggar . '/' . $s->id_seni); ?>" class="btn btn-sm btn-info">Edit</a>
                                    <a href="<?= base_url('pendaftaran/hapus_seni_sanggar/' . $sanggar->id_sanggar . '/' . $s->id_seni); ?>" class="btn btn-sm btn-danger" title="Hapus" onclick="return confirm('Apakah Anda yakin ingin menghapus jenis seni ini?');"><i class="fas fa-trash-alt"></i></a>
                                </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="alert alert-info mb-0">Belum ada jenis seni yang terdaftar.</div>
        <?php endif; ?>
    </div>
</div>
        <div class="card-section">
            <div class="card-header-custom header-pengurus">
                <div class="d-flex align-items-center gap-2">
                    <i class="fas fa-user-tie"></i><span>Pengurus Sanggar</span>
                </div>
                <div class="card-header-buttons">
                    <a href="<?= base_url('pendaftaran/tambah_pengurus/' . ($sanggar->id_sanggar ?? '')); ?>" class="btn btn-sm btn-outline-light d-flex align-items-center" title="Tambah Pengurus">
                        <i class="fas fa-user-plus me-1"></i> Tambah
                    </a>
                </div>
            </div>
            <div class="card-body-custom">
                <?php if (!empty($pengurus)): ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-custom">
                            <thead class="table-light">
                                <tr>
                                    <th>NRK</th>
                                    <th>NIK</th>
                                    <th>Nama Lengkap</th>
                                    <th>Tempat, Tanggal Lahir</th>
                                    <th>Jenis Kelamin</th>
                                    <th>Peran</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($pengurus as $p): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($p->nrk_perorangan ?? '-'); ?></td>
                                        <td><?= htmlspecialchars($p->nik ?? '-'); ?></td>
                                        <td><?= htmlspecialchars($p->nama_lengkap ?? '-'); ?></td>
                                        <td><?= htmlspecialchars($p->tempat_lahir ?? '-'); ?>, <?= !empty($p->tanggal_lahir) ? date('d M Y', strtotime($p->tanggal_lahir)) : '-'; ?></td>
                                        <td><?= $p->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan'; ?></td>
                                        <td><span class="badge bg-primary"><?= htmlspecialchars($p->nama_peran ?? '-'); ?></span></td>
                                        <td>
                                            <div class="btn-action">
                                                <a href="<?= base_url('pendaftaran/edit_pengurus/' . $p->id_pengurus); ?>" class="btn btn-sm btn-primary" title="Edit"><i class="fas fa-edit"></i></a>
                                                <a href="<?= base_url('pendaftaran/hapus_pengurus/' . $p->id_pengurus); ?>" class="btn btn-sm btn-danger" title="Hapus" onclick="return confirm('Apakah Anda yakin ingin menghapus pengurus ini?');"><i class="fas fa-trash-alt"></i></a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="alert alert-info mb-0">Belum ada pengurus yang terdaftar.</div>
                <?php endif; ?>
            </div>
        </div>

        <div class="card-section">
            <div class="card-header-custom header-anggota">
                <div class="d-flex align-items-center gap-2">
                    <i class="fas fa-users"></i><span>Anggota Sanggar</span>
                </div>
                <div class="card-header-buttons">
                    <a href="<?= base_url('pendaftaran/tambah_anggota/' . ($sanggar->id_sanggar ?? '')); ?>" class="btn btn-sm btn-outline-light d-flex align-items-center" title="Tambah Anggota">
                        <i class="fas fa-user-plus me-1"></i> Tambah
                    </a>
                </div>
            </div>
            <div class="card-body-custom">
                <?php if (!empty($anggota)): ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-custom">
                            <thead class="table-light">
                                <tr>
                                    <th>NIK</th>
                                    <th>Nama Anggota</th>
                                    <th>Jenis Kelamin</th>
                                    <th>Tempat, Tanggal Lahir</th>
                                    <th>Level</th>
                                    <th>Status</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($anggota as $a): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($a->nik ?? '-'); ?></td>
                                        <td><?= htmlspecialchars($a->nama_anggota ?? '-'); ?></td>
                                        <td><?= $a->jenis_kelamin == 'L' ? 'Laki-laki' : 'Perempuan'; ?></td>
                                        <td><?= htmlspecialchars($a->tempat_lahir ?? '-'); ?>, <?= !empty($a->tanggal_lahir) ? date('d M Y', strtotime($a->tanggal_lahir)) : '-'; ?></td>
                                        <td><span class="badge bg-secondary"><?= htmlspecialchars($a->nama_level ?? '-'); ?></span></td>
                                        <td>
                                            <?php if ($a->status == 'aktif'): ?>
                                                <span class="badge badge-status bg-success">Aktif</span>
                                            <?php else: ?>
                                                <span class="badge badge-status bg-danger">Nonaktif</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="btn-action">
                                                <a href="<?= base_url('pendaftaran/edit_anggota/' . $a->id_anggota); ?>" class="btn btn-sm btn-primary" title="Edit"><i class="fas fa-edit"></i></a> 
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <div class="alert alert-info mb-0">Belum ada anggota yang terdaftar.</div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php $this->load->view('templates/footer_user'); ?>