<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title><?= $title ?? 'Admin Panel'; ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { min-height: 100vh; display: flex; background: #f8f9fa; transition: .3s; }
    .sidebar { width: 250px; background: #212529; color: #fff; flex-shrink: 0; transition: .3s; }
    .sidebar .nav-link { color: #adb5bd; margin: 3px 0; border-radius: 8px; }
    .sidebar .nav-link.active, .sidebar .nav-link:hover { color: #fff; background-color: #495057; }
    .content { flex-grow: 1; display: flex; flex-direction: column; }
    .topbar { background: #fff; border-bottom: 1px solid #dee2e6; padding: 15px 20px; display: flex; justify-content: space-between; align-items: center; transition: .3s; }

    /* DARK MODE */
    body.dark-mode { background: #181a1b; color: #e0e0e0; }
    body.dark-mode .topbar { background: #212529; color: #fff; border-color: #333; }
    body.dark-mode .sidebar { background: #343a40; }
    body.dark-mode .sidebar .nav-link { color: #e0e0e0; }
    body.dark-mode .sidebar .nav-link.active, body.dark-mode .sidebar .nav-link:hover { background-color: rgba(255,255,255,0.2); }
    body.dark-mode .card { background: #212529; color: #e0e0e0; }
    body.dark-mode thead.table-light { background: #343a40; color: #fff; }
  </style>
</head>
<body>
  <!-- Sidebar -->
  <div class="sidebar d-flex flex-column p-3">
    <h4 class="text-white mb-4">Admin Panel</h4>
    <ul class="nav nav-pills flex-column mb-auto">
      <li><a href="<?= base_url('admin/dashboard'); ?>" class="nav-link <?= ($active=='dashboard'?'active':''); ?>">📊 Dashboard</a></li>
      <li><a href="<?= base_url('admin/users'); ?>" class="nav-link <?= ($active=='users'?'active':''); ?>">👥 Kelola User</a></li>
      <li><a href="<?= base_url('admin/seni'); ?>" class="nav-link <?= ($active=='seni'?'active':''); ?>">🎭 Data Seni</a></li>
      <li><a href="<?= base_url('admin/settings'); ?>" class="nav-link <?= ($active=='settings'?'active':''); ?>">⚙ Pengaturan</a></li>
      <li><a href="<?= base_url('auth/logout'); ?>" class="nav-link text-danger">🚪 Logout</a></li>
    </ul>
  </div>

  <!-- Content -->
  <div class="content">
    <!-- Topbar -->
    <div class="topbar">
      <h5 class="mb-0"><?= $title ?? 'Dashboard'; ?></h5>
      <div>
        <span class="me-3">👋 Halo, <b><?= $this->session->userdata('nama'); ?></b></span>
        <button id="toggleDark" class="btn btn-sm btn-outline-secondary">🌙 Mode Gelap</button>
      </div>
    </div>

    <!-- Body dari tiap halaman -->
    <div class="p-4">
      <?= $content; ?>
    </div>
  </div>

  <script>
    // Load preference dark mode
    if(localStorage.getItem('darkMode') === 'enabled'){
      document.body.classList.add('dark-mode');
      document.getElementById('toggleDark').textContent = '☀ Mode Terang';
    }

    document.getElementById('toggleDark').addEventListener('click', function(){
      document.body.classList.toggle('dark-mode');
      if(document.body.classList.contains('dark-mode')){
        localStorage.setItem('darkMode','enabled');
        this.textContent = '☀ Mode Terang';
      } else {
        localStorage.setItem('darkMode','disabled');
        this.textContent = '🌙 Mode Gelap';
      }
    });
  </script>
</body>
</html>