<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pendaftaran Berhasil</title>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-color: #5A7EFC;
            --secondary-color: #28a745;
            --text-dark: #212529;
            --text-light: #F8F9FA;
            --card-bg: #FFFFFF;
            --success-color: #4CAF50;
            --button-hover: #0c56d6;
            --download-hover: #1e7e34;
        }

        body {
            font-family: 'Poppins', sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            padding: 20px;
            background: linear-gradient(135deg, #A8C0FF 0%, #3F72AF 100%);
            color: var(--text-dark);
        }

        .container {
            width: 100%;
            max-width: 550px;
            background: var(--card-bg);
            padding: 50px 40px;
            border-radius: 20px;
            box-shadow: 0 25px 50px rgba(0, 0, 0, 0.2);
            text-align: center;
            animation: fadeIn 0.8s ease-in-out;
            border: 2px solid var(--primary-color);
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: scale(0.9); }
            to { opacity: 1; transform: scale(1); }
        }

        .icon-success {
            font-size: 72px;
            color: var(--success-color);
            margin-bottom: 20px;
            animation: bounceIn 1s ease-out;
        }

        @keyframes bounceIn {
            0%, 20%, 50%, 80%, 100% {
                transform: translateY(0);
            }
            40% {
                transform: translateY(-30px);
            }
            60% {
                transform: translateY(-15px);
            }
        }

        h2 {
            font-size: 2.5rem;
            color: var(--primary-color);
            margin-bottom: 10px;
            font-weight: 700;
        }

        p {
            color: #6c757d;
            font-size: 1.1rem;
            line-height: 1.6;
            margin-bottom: 30px;
        }

        .btn-group {
            display: flex;
            flex-direction: column;
            gap: 15px;
        }

        .btn {
            padding: 15px 30px;
            border: none;
            border-radius: 12px;
            font-size: 1rem;
            font-weight: 600;
            text-decoration: none;
            transition: all 0.3s ease;
            cursor: pointer;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }

        .btn-primary {
            background-color: var(--primary-color);
            color: var(--text-light);
        }

        .btn-primary:hover {
            background-color: var(--button-hover);
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(90, 126, 252, 0.4);
        }

        .btn-secondary {
            background-color: var(--secondary-color);
            color: var(--text-light);
        }

        .btn-secondary:hover {
            background-color: var(--download-hover);
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(40, 167, 69, 0.4);
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="icon-success">&#10003;</div>
        
        <h2>Pendaftaran Berhasil!</h2>
        <p>Selamat! Data Anda telah berhasil disimpan. Anda dapat mencetak bukti pendaftaran sebagai arsip pribadi.</p>

        <div class="btn-group">
            <a href="<?= base_url('pendaftaran/cetak_bukti/' . $id); ?>" class="btn btn-secondary" target="_blank">
                <i class="fas fa-download"></i> Cetak Bukti Pendaftaran
            </a>
            <a href="<?= base_url('pendaftaran/dashboard'); ?>" class="btn btn-primary">
                Kembali ke Dashboard
            </a>
        </div>
    </div>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
</body>
</html>