<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Login Admin</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {
      margin: 0;
      height: 100vh;
      font-family: 'Poppins', sans-serif;
      display: flex;
      justify-content: center;
      align-items: center;
      overflow: hidden;
      color: #fff;
    }

    /* Background slideshow */
    .bg-slideshow {
      position: fixed;
      top: 0; left: 0;
      width: 100%; height: 100%;
      z-index: -1;
      background-size: cover;
      background-position: center;
      transition: background-image 1s ease-in-out;
      filter: brightness(0.6);
    }

    /* Glass effect card */
    .glass-card {
      background: rgba(255, 255, 255, 0.15);
      backdrop-filter: blur(10px);
      border-radius: 20px;
      padding: 35px;
      width: 400px;
      box-shadow: 0 8px 25px rgba(0,0,0,0.4);
      animation: fadeIn 1s ease-in-out;
    }

    .glass-card h3 {
      text-align: center;
      margin-bottom: 20px;
      font-weight: 700;
      color: #fff;
    }

    .form-control {
      border-radius: 12px;
    }

    /* Neon button */
    .btn-custom {
      border-radius: 50px;
      padding: 12px;
      font-size: 16px;
      font-weight: 600;
      color: #fff;
      border: none;
      background: linear-gradient(135deg, #ff4e50, #f9d423);
      background-size: 300% 300%;
      animation: gradientMove 6s infinite alternate;
      transition: transform 0.3s ease-in-out, box-shadow 0.3s ease-in-out;
    }
    .btn-custom:hover {
      transform: scale(1.05);
      box-shadow: 0 0 20px rgba(255,255,255,0.8);
    }

    @keyframes gradientMove {
      0% { background-position: 0% 50%; }
      100% { background-position: 100% 50%; }
    }

    @keyframes fadeIn {
      from {opacity: 0; transform: translateY(20px);}
      to {opacity: 1; transform: translateY(0);}
    }
  </style>
</head>
<body>

  <div id="bg-slideshow" class="bg-slideshow"></div>

  <div class="glass-card">
    <h3>🛡 Login Admin</h3>

    <?php if($this->session->flashdata('error')): ?>
      <div class="alert alert-danger"><?= $this->session->flashdata('error'); ?></div>
    <?php endif; ?>

    <?php if($this->session->flashdata('success')): ?>
      <div class="alert alert-success"><?= $this->session->flashdata('success'); ?></div>
    <?php endif; ?>

    <form method="post" action="<?= base_url('auth/login_admin'); ?>">
      <!-- Input Email -->
      <div class="mb-3 input-group">
        <span class="input-group-text bg-white border-0">
          <i class="bi bi-envelope-fill text-secondary"></i>
        </span>
        <input type="email" name="email" class="form-control" placeholder="Masukkan Email Admin" required>
      </div>

      <!-- Input Password -->
      <div class="mb-3 input-group">
        <span class="input-group-text bg-white border-0">
          <i class="bi bi-lock-fill text-secondary"></i>
        </span>
        <input type="password" name="password" id="password" class="form-control" placeholder="Masukkan Password" required>
        <span class="input-group-text bg-white border-0" style="cursor:pointer;" onclick="togglePassword()">
          <i id="togglePasswordIcon" class="bi bi-eye-slash-fill text-secondary"></i>
        </span>
      </div>

      <button type="submit" class="btn btn-custom w-100">Login</button>
    </form>

    <!-- Tombol kembali -->
    <div class="text-center mt-3">
      <a href="<?= base_url('auth'); ?>" class="btn btn-custom">⬅ Kembali</a>
    </div>
  </div>

  <script>
    // Slideshow background
    const images = [
      "<?= base_url('assets/img/bg1.jpg') ?>",
      "<?= base_url('assets/img/bg2.jpg') ?>",
      "<?= base_url('assets/img/bg3.jpg') ?>",
      "<?= base_url('assets/img/bg4.jpg') ?>"
    ];

    let index = 0;
    const bg = document.getElementById("bg-slideshow");

    function changeBackground() {
      bg.style.backgroundImage = "url('" + images[index] + "')";
      index = (index + 1) % images.length;
    }

    changeBackground();
    setInterval(changeBackground, 5000);

    // Toggle password
    function togglePassword() {
      const passwordField = document.getElementById("password");
      const toggleIcon = document.getElementById("togglePasswordIcon");

      if (passwordField.type === "password") {
        passwordField.type = "text";
        toggleIcon.classList.remove("bi-eye-slash-fill");
        toggleIcon.classList.add("bi-eye-fill");
      } else {
        passwordField.type = "password";
        toggleIcon.classList.remove("bi-eye-fill");
        toggleIcon.classList.add("bi-eye-slash-fill");
      }
    }
    
  </script>


</body>
</html>