<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Pilih Login</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body {
      margin: 0;
      height: 100vh;
      font-family: 'Poppins', sans-serif;
      display: flex;
      justify-content: center;
      align-items: center;
      overflow: hidden;
      color: #fff;
    }

    /* Background slideshow */
    .bg-slideshow {
      position: fixed;
      top: 0; left: 0;
      width: 100%; height: 100%;
      z-index: -1;
      background-size: cover;
      background-position: center;
      transition: background-image 1s ease-in-out;
      filter: brightness(0.6);
    }

    /* Glass card */
    .glass-card {
      background: rgba(255, 255, 255, 0.15);
      backdrop-filter: blur(10px);
      border-radius: 20px;
      padding: 40px;
      width: 850px;
      box-shadow: 0 8px 25px rgba(0,0,0,0.4);
      animation: fadeIn 1s ease-in-out;
      text-align: center;
    }

    .glass-card h3 {
      font-weight: 700;
      margin-bottom: 25px;
      color: #fff;
    }

    /* Button Row */
    .btn-container {
      display: flex;
      justify-content: center;
      gap: 25px;
    }

    /* Custom Buttons */
    .btn-custom {
      flex: 1;
      min-width: 220px;
      padding: 18px 25px;
      font-size: 18px;
      font-weight: 600;
      border: none;
      border-radius: 50px;
      color: #fff;
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .btn-custom:hover {
      transform: translateY(-5px);
      box-shadow: 0 0 25px rgba(255,255,255,0.7);
    }

    .btn-admin { background: linear-gradient(135deg, #ff4e50, #f9d423); }
    .btn-perorangan { background: linear-gradient(135deg, #36d1dc, #5b86e5); }
    .btn-kelompok { background: linear-gradient(135deg, #00b09b, #96c93d); }
    .btn-register { background: linear-gradient(135deg, #9D50BB, #6E48AA); }

    /* Modal Styling */
    .modal-content {
      background: rgba(255, 255, 255, 0.15);
      backdrop-filter: blur(15px);
      border-radius: 20px;
      border: 1px solid rgba(255,255,255,0.3);
      color: #fff;
    }

    .modal-title { font-weight: bold; }
    .btn-modal {
      border-radius: 30px;
      padding: 12px 25px;
      font-weight: 600;
      border: none;
      margin: 5px;
    }
    .btn-modal-ok {
      background: linear-gradient(135deg, #00b09b, #96c93d);
      color: #fff;
    }
    .btn-modal-cancel {
      background: linear-gradient(135deg, #ff4e50, #f9d423);
      color: #fff;
    }
  </style>
</head>
<body>

  <!-- Background -->
  <div id="bg-slideshow" class="bg-slideshow"></div>

  <!-- Main Card -->
  <div class="glass-card">
    <h3>🔑 Pilih Login</h3>
    <div class="btn-container">
      <button class="btn btn-custom btn-perorangan" data-bs-toggle="modal" data-bs-target="#modalPerorangan">
        <i class="bi bi-person-fill me-2"></i> Perorangan
      </button>
      <button class="btn btn-custom btn-kelompok" data-bs-toggle="modal" data-bs-target="#modalKelompok">
        <i class="bi bi-people-fill me-2"></i> Kelompok
      </button>
      <button class="btn btn-custom btn-admin" data-bs-toggle="modal" data-bs-target="#modalAdmin">
        <i class="bi bi-shield-lock-fill me-2"></i> Admin
      </button>
    </div>
  </div>

  <!-- Modal Perorangan -->
  <div class="modal fade" id="modalPerorangan" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content text-center">
        <div class="modal-header border-0">
          <h5 class="modal-title w-100">Perorangan</h5>
          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <a href="<?= base_url('auth/login_perorangan'); ?>" class="btn btn-custom btn-perorangan mb-2">
            <i class="bi bi-box-arrow-in-right me-2"></i> Login
          </a>
          <a href="<?= base_url('auth/register_perorangan'); ?>" class="btn btn-custom btn-register">
            <i class="bi bi-person-plus-fill me-2"></i> Register
          </a>
        </div>
      </div>
    </div>
  </div>

  <!-- Modal Kelompok -->
  <div class="modal fade" id="modalKelompok" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content text-center">
        <div class="modal-header border-0">
          <h5 class="modal-title w-100">Kelompok</h5>
          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <p class="mb-3">Untuk login / register kelompok, Anda harus sudah daftar perorangan dan punya NRK.</p>
          <a href="<?= base_url('auth/register_perorangan'); ?>" class="btn btn-modal btn-modal-cancel">Belum, Daftar Perorangan</a>
          <div class="mt-3">
            <a href="<?= base_url('auth/login_kelompok'); ?>" class="btn btn-modal btn-modal-ok">Login Kelompok</a>
            <a href="<?= base_url('auth/register_kelompok'); ?>" class="btn btn-modal btn-register">Register Kelompok</a>
          </div>
        </div>
      </div>
    </div>
  </div>

  <!-- Modal Admin -->
  <div class="modal fade" id="modalAdmin" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content text-center">
        <div class="modal-header border-0">
          <h5 class="modal-title w-100">Admin</h5>
          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <a href="<?= base_url('auth/login_admin'); ?>" class="btn btn-custom btn-admin mb-2">
            <i class="bi bi-box-arrow-in-right me-2"></i> Login
          </a>
          <a href="<?= base_url('auth/register_admin'); ?>" class="btn btn-custom btn-register">
            <i class="bi bi-person-plus-fill me-2"></i> Register
          </a>
        </div>
      </div>
    </div>
  </div>

  <!-- Scripts -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script>
    const images = [
      "<?= base_url('assets/img/bg1.jpg') ?>",
      "<?= base_url('assets/img/bg2.jpg') ?>",
      "<?= base_url('assets/img/bg3.jpg') ?>",
      "<?= base_url('assets/img/bg4.jpg') ?>"
    ];
    let index = 0;
    const bg = document.getElementById("bg-slideshow");
    function changeBackground() {
      bg.style.backgroundImage = "url('" + images[index] + "')";
      index = (index + 1) % images.length;
    }
    changeBackground();
    setInterval(changeBackground, 5000);
  </script>
</body>
</html>