<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tambah Pendaftar Kelompok</title>
    <style>
        body { font-family: sans-serif; background: #f0f2f5; margin: 0; padding: 20px; }
        .container { max-width: 900px; margin: auto; background: #fff; padding: 30px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        h1, h2 { text-align: center; color: #333; }
        .form-section { border: 1px solid #e0e0e0; border-radius: 8px; padding: 20px; margin-bottom: 20px; }
        .form-section-title { font-size: 1.2em; font-weight: bold; margin-bottom: 15px; color: #555; }
        .form-group { margin-bottom: 15px; }
        .form-group label { display: block; margin-bottom: 5px; font-weight: bold; }
        .form-group label span.required { color: red; }
        .form-control, .form-select { width: 100%; padding: 8px; box-sizing: border-box; border: 1px solid #ccc; border-radius: 4px; }
        .form-row { display: flex; flex-wrap: wrap; gap: 20px; }
        .form-row .form-group { flex: 1; min-width: 200px; }
        .button-group { text-align: right; margin-top: 20px; }
        .button-group .btn { padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; }
        .button-group .btn-submit { background-color: #28a745; color: white; }
        .button-group .btn-danger { background-color: #6c757d; color: white; }
    </style>
</head>
<body>

<div class="container">
    <h1>➕ Tambah Pendaftar Kelompok</h1>

    <form action="<?= base_url('admin/simpan_kelompok'); ?>" method="post">

        <!-- Identitas Lembaga -->
        <div class="form-section">
            <div class="form-section-title">🏢 Identitas Lembaga</div>
            <div class="form-row">
                <div class="form-group">
                    <label>NRK Sanggar</label>
                    <input type="text" name="nrk_sanggar" class="form-control">
                </div>
                <div class="form-group">
                    <label>Nama Sanggar <span class="required">*</span></label>
                    <input type="text" name="nama_sanggar" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Jenis Lembaga <span class="required">*</span></label>
                    <select name="jenis_lembaga" class="form-select" required>
                        <option value="">Pilih</option>
                        <option value="Sanggar">Sanggar</option>
                        <option value="Kelompok">Kelompok</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Jenis Seni <span class="required">*</span></label>
                    <select name="jenis_seni" class="form-select" required>
                        <option value="">Pilih Jenis Seni</option>
                        <?php foreach ($jenis_seni as $s): ?>
                            <option value="<?= $s['id_seni']; ?>"><?= $s['nama_seni']; ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label>Status Hukum <span class="required">*</span></label>
                    <select name="status_hukum" class="form-select" required>
                        <option value="">Pilih</option>
                        <option value="Berbadan Hukum">Berbadan Hukum</option>
                        <option value="Non-Berbadan Hukum">Non-Berbadan Hukum</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Nomor Identitas</label>
                    <input type="text" name="nomor_identitas" class="form-control">
                </div>
                <div class="form-group">
                    <label>Tanggal Berdiri</label>
                    <input type="date" name="tanggal_berdiri" class="form-control">
                </div>
            </div>
            <div class="form-group">
                <label>Tujuan</label>
                <textarea name="tujuan" class="form-control"></textarea>
            </div>
            <div class="form-group">
                <label>Deskripsi</label>
                <textarea name="deskripsi" class="form-control"></textarea>
            </div>
        </div>

        <!-- Kontak -->
        <div class="form-section">
            <div class="form-section-title">📞 Kontak</div>
            <div class="form-row">
                <div class="form-group">
                    <label>No HP <span class="required">*</span></label>
                    <input type="text" name="no_hp" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Email</label>
                    <input type="email" name="alamat_email" class="form-control">
                </div>
                <div class="form-group">
                    <label>Website</label>
                    <input type="text" name="alamat_website" class="form-control">
                </div>
                <div class="form-group">
                    <label>Facebook</label>
                    <input type="text" name="akun_facebook" class="form-control">
                </div>
                <div class="form-group">
                    <label>Twitter</label>
                    <input type="text" name="akun_twitter" class="form-control">
                </div>
                <div class="form-group">
                    <label>Instagram</label>
                    <input type="text" name="akun_instagram" class="form-control">
                </div>
                <div class="form-group">
                    <label>Youtube</label>
                    <input type="text" name="akun_youtube" class="form-control">
                </div>
            </div>
        </div>

        <!-- Alamat -->
        <div class="form-section">
            <div class="form-section-title">📍 Alamat</div>
            <div class="form-row">
                <div class="form-group">
                    <label>Provinsi <span class="required">*</span></label>
                    <input type="text" name="provinsi" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Kabupaten <span class="required">*</span></label>
                    <input type="text" name="kabupaten" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Kecamatan <span class="required">*</span></label>
                    <input type="text" name="kecamatan" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Desa <span class="required">*</span></label>
                    <input type="text" name="desa" class="form-control" required>
                </div>
            </div>
            <div class="form-row">
                <div class="form-group" style="flex:2;">
                    <label>Alamat Lengkap <span class="required">*</span></label>
                    <input type="text" name="alamat" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Latitude</label>
                    <input type="text" name="latitude" class="form-control">
                </div>
                <div class="form-group">
                    <label>Longitude</label>
                    <input type="text" name="longitude" class="form-control">
                </div>
            </div>
        </div>

        <!-- Tombol -->
        <div class="button-group">
            <a href="<?= base_url('admin/pendaftar_kelompok'); ?>" class="btn btn-danger">⬅ Batal</a>
            <button type="submit" class="btn btn-submit">💾 Simpan</button>
        </div>

    </form>
</div>

</body>
</html>