<div class="container-fluid">
    <h2 class="mb-4 text-primary fw-bold">👤 Data Pendaftar Perorangan</h2>

    <!-- Filter + Export -->
<div class="card shadow-sm rounded-3 mb-3 p-3">
    <form method="get" action="<?= base_url('admin/pendaftar_perorangan'); ?>">
        <div class="row g-2 align-items-center">
            <div class="col-md-3">
                <select name="jenis_kelamin" class="form-select form-select-sm">
                    <option value="">Pilih Jenis Kelamin</option>
                    <option value="L" <?= ($jk == 'L') ? 'selected' : ''; ?>>Laki-laki</option>
                    <option value="P" <?= ($jk == 'P') ? 'selected' : ''; ?>>Perempuan</option>
                </select>
            </div>
            <div class="col-md-3">
                <select name="status" class="form-select form-select-sm">
                    <option value="">Pilih Status</option>
                    <option value="valid" <?= ($status == 'valid') ? 'selected' : ''; ?>>Valid</option>
                    <option value="draft" <?= ($status == 'draft') ? 'selected' : ''; ?>>Draft</option>
                </select>
            </div>
            <div class="col-md-3">
                <input type="number" name="tahun" class="form-control form-control-sm" 
                       placeholder="Tahun" value="<?= $tahun ?? ''; ?>">
            </div>
            <div class="col-md-3 text-end">
                <button type="submit" class="btn btn-primary btn-sm">🔍 Filter</button>
                <a href="<?= base_url('admin/pendaftar_perorangan'); ?>" class="btn btn-secondary btn-sm">Reset</a>
            </div>
        </div>
    </form>
</div>


    <!-- Search + Tambah -->
    <div class="d-flex justify-content-between mb-3">
        <form class="d-flex" method="get" action="<?= base_url('admin/pendaftar_perorangan') ?>">
            <input type="text" name="keyword" class="form-control form-control-sm me-2"
                   placeholder="Search..." value="<?= $keyword ?? '' ?>">
            <button type="submit" class="btn btn-outline-primary btn-sm">🔍 Cari</button>
        </form>
        <a href="<?= base_url('admin/tambah_perorangan'); ?>" class="btn btn-success btn-sm">
            ➕ Tambah Pendaftar
        </a>
    </div>
<div class="col-md-3 text-end">
    <!-- Export sesuai filter -->
    <a href="<?= base_url('admin/export_perorangan_excel_filter?'.http_build_query($_GET)); ?>" 
       class="btn btn-primary btn-sm">📊 Excel Filter</a>
    <a href="<?= base_url('admin/export_perorangan_pdf_filter?'.http_build_query($_GET)); ?>" 
       class="btn btn-danger btn-sm" target="_blank">📄 PDF Filter</a>

    <!-- Export semua -->
    <a href="<?= base_url('admin/export_perorangan_excel_all'); ?>" 
       class="btn btn-success btn-sm">📊 Excel Semua</a>
    <a href="<?= base_url('admin/export_perorangan_pdf_all'); ?>" 
       class="btn btn-warning btn-sm" target="_blank">📄 PDF Semua</a>
</div>


    <!-- Table -->
    <div class="card shadow-sm rounded-3 p-3">
        <div class="table-responsive">
            <table class="table table-bordered table-hover align-middle">
               <thead class="table-light text-center">
    <tr>
        <th>NRK</th>
        <th>Level</th>
        <th>Nama</th>
        <th>Jenis Kelamin</th>
        <th>Nomor HP</th>
        <th>Status</th>
        <th>Action</th>
    </tr>
</thead>
<tbody>
<?php if (!empty($pendaftaran)): ?>
    <?php foreach ($pendaftaran as $p): ?>
        <tr>
            <!-- NRK -->
            <td class="text-center"><?= $p->nrk_perorangan ?: '-'; ?></td>

            <!-- Level -->
            <td>kabupaten</td>

            <!-- Nama -->
            <td><?= $p->nama_lengkap; ?></td>

            <!-- Jenis Kelamin -->
            <td><?= $p->jenis_kelamin; ?></td>

            <!-- Nomor HP -->
            <td><?= $p->no_hp ?? '-'; ?></td>

            <!-- STATUS -->
            <td class="text-center">
                <span class="badge <?= $p->status == 'valid' ? 'bg-success' : 'bg-secondary'; ?>">
                    <?= ucfirst($p->status); ?>
                </span>
            </td>

            <!-- ACTION -->
<td class="text-center">
    <?php if (!empty($p->nrk_perorangan)): ?>
        <!-- Ada NRK → cuma lihat -->
        <a href="<?= base_url('admin/detail_perorangan/'.$p->id_sdm); ?>" 
           class="btn btn-info btn-sm">👁</a>
    <?php else: ?>
        <!-- NRK kosong → bisa edit + hapus -->
        <a href="<?= base_url('admin/edit_perorangan/'.$p->id_sdm); ?>" 
           class="btn btn-warning btn-sm">✏</a>
        <a href="<?= base_url('admin/hapus_perorangan/'.$p->id_sdm); ?>" 
           onclick="return confirm('Yakin hapus data ini?')" 
           class="btn btn-danger btn-sm">🗑</a>
    <?php endif; ?>
</td>

        </tr>
    <?php endforeach; ?>
<?php else: ?>
    <tr>
        <td colspan="7" class="text-center">Belum ada pendaftar perorangan</td>
    </tr>
<?php endif; ?>
</tbody>

            </table>
        </div>

        <!-- Pagination -->
        <?php if ($total_rows > $limit): ?>
        <nav>
            <ul class="pagination justify-content-center">
                <?php for ($i = 0; $i < ceil($total_rows / $limit); $i++): ?>
                    <li class="page-item <?= ($page/$limit == $i) ? 'active' : ''; ?>">
                        <a class="page-link" href="<?= base_url('admin/pendaftar_perorangan/'.($i*$limit)); ?>">
                            <?= $i+1; ?>
                        </a>
                    </li>
                <?php endfor; ?>
            </ul>
        </nav>
        <?php endif; ?>
    </div>
</div>