<div class="container-fluid">
    <h2 class="mb-4 text-success fw-bold">👥 Data Pendaftar Kelompok</h2>

    <!-- Filter -->
    <div class="card shadow-sm rounded-3 mb-3 p-3">
        <form method="get" action="<?= base_url('admin/pendaftar_kelompok'); ?>">
            <div class="row g-2 align-items-center">
                <div class="col-md-3">
                    <select name="status" class="form-select form-select-sm">
                        <option value="">Pilih Status</option>
                        <option value="valid" <?= ($status == 'valid') ? 'selected' : ''; ?>>Valid</option>
                        <option value="draft" <?= ($status == 'draft') ? 'selected' : ''; ?>>Draft</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <input type="number" name="tahun" class="form-control form-control-sm" 
                           placeholder="Tahun" value="<?= $tahun ?? ''; ?>">
                </div>
                <div class="col-md-3 text-end">
                    <button type="submit" class="btn btn-primary btn-sm">🔍 Filter</button>
                    <a href="<?= base_url('admin/pendaftar_kelompok'); ?>" class="btn btn-secondary btn-sm">Reset</a>
                </div>
            </div>
        </form>
    </div>

    <!-- Search + Tambah + Export -->
    <div class="d-flex justify-content-between mb-3">
        <form class="d-flex" method="get" action="<?= base_url('admin/pendaftar_kelompok') ?>">
            <input type="text" name="keyword" class="form-control form-control-sm me-2"
                   placeholder="Cari NRK / Nama Sanggar / Seni..." value="<?= $keyword ?? '' ?>">
            <button type="submit" class="btn btn-outline-primary btn-sm">🔍 Cari</button>
        </form>
      <div class="d-flex gap-2">
    <a href="<?= base_url('admin/tambah_kelompok'); ?>" class="btn btn-success btn-sm">
        ➕ Tambah Pendaftar Kelompok
    </a>

    <!-- Export sesuai filter -->
    <a href="<?= base_url('admin/export_kelompok_excel_filter?'.http_build_query($_GET)); ?>" 
       class="btn btn-primary btn-sm">📊 Excel Filter</a>
    <a href="<?= base_url('admin/export_kelompok_pdf_filter?'.http_build_query($_GET)); ?>" 
       class="btn btn-danger btn-sm" target="_blank">📄 PDF Filter</a>

    <!-- Export semua -->
    <a href="<?= base_url('admin/export_kelompok_excel'); ?>" class="btn btn-success btn-sm">📊 Excel Semua</a>
    <a href="<?= base_url('admin/export_kelompok_pdf'); ?>" class="btn btn-warning btn-sm" target="_blank">📄 PDF Semua</a>
</div>


    </div>

    <!-- Table -->
    <div class="card shadow-sm rounded-3 p-3">
        <div class="table-responsive">
            <table class="table table-bordered table-hover align-middle">
                <thead class="table-success text-center">
                    <tr>
                        <th>NRK</th>
                        <th>Level</th>
                        <th>Nama Sanggar</th>
                        <th>Jenis Seni</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                <?php if (!empty($sanggar_list)): ?>
                    <?php foreach ($sanggar_list as $sg): ?>
                        <?php 
                            $is_valid = !empty($sg->nrk_sanggar);
                            $row_status = $is_valid ? 'valid' : 'draft'; // biar ga numpuk sama filter
                        ?>
                        <tr>
                            <!-- NRK -->
                            <td class="text-center"><?= $sg->nrk_sanggar ?: '-'; ?></td>

                            <!-- Level -->
                            <td>kabupaten</td>

                            <!-- Nama Sanggar -->
                            <td><?= htmlspecialchars($sg->nama_sanggar, ENT_QUOTES, 'UTF-8'); ?></td>

                            <!-- Jenis Seni -->
                            <td><?= $sg->jenis_seni_list ?? '-'; ?></td>

                            <!-- STATUS -->
                            <td class="text-center">
                                <span class="badge <?= $is_valid ? 'bg-success' : 'bg-secondary'; ?>">
                                    <?= ucfirst($row_status); ?>
                                </span>
                            </td>

                            <!-- ACTION -->
                            <td class="text-center">
                                <?php if ($is_valid): ?>
                                    <!-- kalau ada NRK = hanya lihat -->
                                    <a href="<?= base_url('admin/detail_kelompok/'.$sg->id_sanggar); ?>" 
                                       class="btn btn-info btn-sm">👁</a>
                                <?php else: ?>
                                    <!-- kalau draft = bisa edit & hapus -->
                                    <a href="<?= base_url('admin/edit_kelompok/'.$sg->id_sanggar); ?>" 
                                       class="btn btn-warning btn-sm">✏</a>
                                    <a href="<?= base_url('admin/hapus_kelompok/'.$sg->id_sanggar); ?>" 
                                       onclick="return confirm('Yakin hapus data ini?')" 
                                       class="btn btn-danger btn-sm">🗑</a>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6" class="text-center">Belum ada pendaftar kelompok</td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if ($total_rows > $limit): ?>
        <nav>
            <ul class="pagination justify-content-center">
                <?php for ($i = 0; $i < ceil($total_rows / $limit); $i++): ?>
                    <li class="page-item <?= ($page/$limit == $i) ? 'active' : ''; ?>">
                        <a class="page-link" href="<?= base_url('admin/pendaftar_kelompok/'.($i*$limit)); ?>">
                            <?= $i+1; ?>
                        </a>
                    </li>
                <?php endfor; ?>
            </ul>
        </nav>
        <?php endif; ?>
    </div>
</div>