<div class="container-fluid px-4">
    <h3 class="mt-4">Jenis Seni</h3>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item active">Jenis Seni</li>
    </ol>

    <div class="card mb-4">
        <div class="card-header bg-warning text-dark d-flex justify-content-between align-items-center">
            <span><i class="fas fa-paint-brush"></i> Daftar Jenis Seni</span>
            <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#modalTambah">
                ➕ Tambah Jenis Seni
            </button>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-striped">
                    <thead class="table-warning">
                        <tr>
                            <th>No</th>
                            <th>Nama Seni</th>
                            <th style="width: 150px;">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (!empty($jenis_seni)) : ?>
                            <?php $no = 1; foreach ($jenis_seni as $seni) : ?>
                                <tr>
                                    <td><?= $no++; ?></td>
                                    <td><?= $seni->nama_seni; ?></td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#modalEdit<?= $seni->id_seni; ?>">✏ Edit</button>
                                        <a href="<?= base_url('admin/hapus_jenis_seni/'.$seni->id_seni); ?>" class="btn btn-sm btn-danger" onclick="return confirm('Yakin hapus data ini?')">🗑 Hapus</a>
                                    </td>
                                </tr>

                                <!-- Modal Edit -->
                                <div class="modal fade" id="modalEdit<?= $seni->id_seni; ?>" tabindex="-1">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <form method="post" action="<?= base_url('admin/edit_jenis_seni/'.$seni->id_seni); ?>">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Edit Jenis Seni</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <div class="form-group">
                                                        <label>Nama Seni</label>
                                                        <input type="text" name="nama_seni" class="form-control" value="<?= $seni->nama_seni; ?>" required>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="submit" class="btn btn-success">Simpan</button>
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php else : ?>
                            <tr>
                                <td colspan="3" class="text-center">Belum ada data.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal Tambah -->
<div class="modal fade" id="modalTambah" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="post" action="<?= base_url('admin/tambah_jenis_seni'); ?>">
                <div class="modal-header">
                    <h5 class="modal-title">Tambah Jenis Seni</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label>Nama Seni</label>
                        <input type="text" name="nama_seni" class="form-control" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Simpan</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                </div>
            </form>
        </div>
    </div>
</div>