<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($sdm) ? 'Edit Pendaftar Perorangan' : 'Tambah Pendaftar Perorangan'; ?></title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        .card-header {
            font-weight: bold;
            background-color: #f7f7f7;
        }
        .required-label::after {
            content: "*";
            color: red;
            margin-left: 4px;
        }
    </style>
</head>
<body>

<div class="container-xl mt-5 mb-5">
    <div class="row">
        <div class="col-md-12">

            <form method="post" enctype="multipart/form-data"
                  action="<?= isset($sdm) ? base_url('admin/update_perorangan/'.$sdm->id_sdm) : base_url('admin/simpan_perorangan'); ?>">

            <!-- Identitas -->
            <div class="card shadow-sm mb-4">
                <div class="card-header">Identitas Tenaga Budaya</div>
                <div class="card-body">
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label class="required-label">Nama Lengkap (Tanpa Gelar)</label>
                            <input type="text" class="form-control" name="nama_lengkap"
                                   value="<?= $sdm->nama_lengkap ?? ''; ?>" required>
                        </div>
                        <div class="form-group col-md-4">
                            <label>Gelar Pendidikan</label>
                            <input type="text" class="form-control" name="gelar_pendidikan"
                                   value="<?= $sdm->gelar_pendidikan ?? ''; ?>">
                        </div>
                        <div class="form-group col-md-4">
                            <label>Nama Alias</label>
                            <input type="text" class="form-control" name="nama_alias"
                                   value="<?= $sdm->nama_alias ?? ''; ?>">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label class="required-label">Jenis Identitas</label>
                            <select name="jenis_identitas" class="form-control" required>
                                <option value="">Pilih Jenis Identitas</option>
                                <option value="KTP" <?= (isset($sdm) && $sdm->jenis_identitas == 'KTP') ? 'selected' : ''; ?>>KTP</option>
                                <option value="SIM" <?= (isset($sdm) && $sdm->jenis_identitas == 'SIM') ? 'selected' : ''; ?>>SIM</option>
                                <option value="Paspor" <?= (isset($sdm) && $sdm->jenis_identitas == 'Paspor') ? 'selected' : ''; ?>>Paspor</option>
                            </select>
                        </div>
                        <div class="form-group col-md-4">
                            <label class="required-label">NIK</label>
                            <input type="text" class="form-control" name="nik"
                                   value="<?= $sdm->nik ?? ''; ?>" required>
                        </div>
                        <div class="form-group col-md-4">
                            <label class="required-label">Tempat Lahir</label>
                            <input type="text" class="form-control" name="tempat_lahir"
                                   value="<?= $sdm->tempat_lahir ?? ''; ?>" required>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label class="required-label">Tanggal Lahir</label>
                            <input type="date" class="form-control" name="tanggal_lahir"
                                   value="<?= $sdm->tanggal_lahir ?? ''; ?>" required>
                        </div>
                        <div class="form-group col-md-4">
                            <label class="required-label">Jenis Kelamin</label>
                            <select name="jenis_kelamin" class="form-control" required>
                                <option value="">Pilih Jenis Kelamin</option>
                                <option value="L" <?= (isset($sdm) && $sdm->jenis_kelamin == 'L') ? 'selected' : ''; ?>>Laki-laki</option>
                                <option value="P" <?= (isset($sdm) && $sdm->jenis_kelamin == 'P') ? 'selected' : ''; ?>>Perempuan</option>
                            </select>
                        </div>
                        <div class="form-group col-md-4">
                            <label class="required-label">Agama</label>
                            <select name="agama" class="form-control" required>
                                <option value="">Pilih Agama</option>
                                <option value="Islam" <?= (isset($sdm) && $sdm->agama == 'Islam') ? 'selected' : ''; ?>>Islam</option>
                                <option value="Kristen" <?= (isset($sdm) && $sdm->agama == 'Kristen') ? 'selected' : ''; ?>>Kristen</option>
                                <option value="Katolik" <?= (isset($sdm) && $sdm->agama == 'Katolik') ? 'selected' : ''; ?>>Katolik</option>
                                <option value="Hindu" <?= (isset($sdm) && $sdm->agama == 'Hindu') ? 'selected' : ''; ?>>Hindu</option>
                                <option value="Buddha" <?= (isset($sdm) && $sdm->agama == 'Buddha') ? 'selected' : ''; ?>>Buddha</option>
                                <option value="Konghucu" <?= (isset($sdm) && $sdm->agama == 'Konghucu') ? 'selected' : ''; ?>>Konghucu</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label class="required-label">Kewarganegaraan</label>
                            <select name="kewarganegaraan" class="form-control" required>
                                <option value="">Pilih Kewarganegaraan</option>
                                <option value="WNI" <?= (isset($sdm) && $sdm->kewarganegaraan == 'WNI') ? 'selected' : ''; ?>>WNI</option>
                                <option value="WNA" <?= (isset($sdm) && $sdm->kewarganegaraan == 'WNA') ? 'selected' : ''; ?>>WNA</option>
                            </select>
                        </div>
                        <div class="form-group col-md-4">
                            <label>Nama Ayah</label>
                            <input type="text" class="form-control" name="nama_ayah"
                                   value="<?= $sdm->nama_ayah ?? ''; ?>">
                        </div>
                        <div class="form-group col-md-4">
                            <label>Nama Ibu</label>
                            <input type="text" class="form-control" name="nama_ibu"
                                   value="<?= $sdm->nama_ibu ?? ''; ?>">
                        </div>
                        <div class="form-group col-md-4">
                            <label class="required-label">Jenis Seni</label>
                            <select name="jenis_seni" class="form-control" required>
                                <option value="">Pilih Jenis Seni</option>
                                <?php foreach ($jenis_seni as $row): ?>
                                    <option value="<?= $row['id_seni']; ?>" <?= (isset($sdm) && $sdm->id_seni == $row['id_seni']) ? 'selected' : ''; ?>>
                                        <?= $row['nama_seni']; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Media Foto -->
            <div class="card shadow-sm mb-4">
                <div class="card-header">Media Foto</div>
                <div class="card-body">
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label class="required-label">Foto Kartu Identitas</label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" name="foto_identitas">
                                <label class="custom-file-label">Pilih file</label>
                            </div>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Pas Foto</label>
                            <div class="custom-file">
                                <input type="file" class="custom-file-input" name="pas_foto">
                                <label class="custom-file-label">Pilih file</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Alamat -->
            <div class="card shadow-sm mb-4">
                <div class="card-header">Alamat</div>
                <div class="card-body">
                    <div class="form-row">
                        <div class="form-group col-md-3">
                            <label class="required-label">Provinsi</label>
                            <input type="text" class="form-control" name="provinsi"
                                   value="<?= $alamat->provinsi ?? ''; ?>" required>
                        </div>
                        <div class="form-group col-md-3">
                            <label class="required-label">Kabupaten/Kota</label>
                            <input type="text" class="form-control" name="kabupaten"
                                   value="<?= $alamat->kabupaten ?? ''; ?>" required>
                        </div>
                        <div class="form-group col-md-3">
                            <label>Kecamatan</label>
                            <input type="text" class="form-control" name="kecamatan"
                                   value="<?= $alamat->kecamatan ?? ''; ?>">
                        </div>
                        <div class="form-group col-md-3">
                            <label>Desa/Kelurahan</label>
                            <input type="text" class="form-control" name="desa"
                                   value="<?= $alamat->desa ?? ''; ?>">
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Alamat Lengkap</label>
                        <textarea class="form-control" name="alamat" rows="3"><?= $alamat->alamat ?? ''; ?></textarea>
                    </div>
                </div>
            </div>

            <!-- Kontak -->
            <div class="card shadow-sm mb-4">
                <div class="card-header">Kontak</div>
                <div class="card-body">
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label class="required-label">Nomor HP</label>
                            <input type="text" class="form-control" name="no_hp"
                                   value="<?= $alamat->no_hp ?? ''; ?>" required>
                        </div>
                        <div class="form-group col-md-6">
                            <label>Email</label>
                            <input type="email" class="form-control" name="email"
                                   value="<?= $alamat->email ?? ''; ?>">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Facebook</label>
                            <input type="text" class="form-control" name="facebook"
                                   value="<?= $alamat->facebook ?? ''; ?>">
                        </div>
                        <div class="form-group col-md-6">
                            <label>Youtube</label>
                            <input type="text" class="form-control" name="youtube"
                                   value="<?= $alamat->youtube ?? ''; ?>">
                        </div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label>Website</label>
                            <input type="text" class="form-control" name="website"
                                   value="<?= $alamat->website ?? ''; ?>">
                        </div>
                        <div class="form-group col-md-6">
                            <label>Twitter</label>
                            <input type="text" class="form-control" name="twitter"
                                   value="<?= $alamat->twitter ?? ''; ?>">
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Instagram</label>
                        <input type="text" class="form-control" name="instagram"
                               value="<?= $alamat->instagram ?? ''; ?>">
                    </div>
                </div>
            </div>

            <!-- Riwayat (Pendidikan, Pelatihan, Pekerjaan, Aktivitas, Penghargaan) -->
            <div id="riwayat-container">
                <div class="card shadow-sm mb-4">
                    <div class="card-header">
                        Riwayat Pendidikan
                        <button type="button" class="btn btn-sm btn-success float-right tambah-riwayat" data-riwayat="pendidikan">+</button>
                    </div>
                    <div class="card-body">
                        <div id="pendidikan-form-list"></div>
                    </div>
                </div>
                <div class="card shadow-sm mb-4">
                    <div class="card-header">
                        Riwayat Pelatihan
                        <button type="button" class="btn btn-sm btn-success float-right tambah-riwayat" data-riwayat="pelatihan">+</button>
                    </div>
                    <div class="card-body">
                        <div id="pelatihan-form-list"></div>
                    </div>
                </div>
                <div class="card shadow-sm mb-4">
                    <div class="card-header">
                        Riwayat Pekerjaan
                        <button type="button" class="btn btn-sm btn-success float-right tambah-riwayat" data-riwayat="pekerjaan">+</button>
                    </div>
                    <div class="card-body">
                        <div id="pekerjaan-form-list"></div>
                    </div>
                </div>
                <div class="card shadow-sm mb-4">
                    <div class="card-header">
                        Riwayat Aktivitas Kebudayaan
                        <button type="button" class="btn btn-sm btn-success float-right tambah-riwayat" data-riwayat="aktivitas">+</button>
                    </div>
                    <div class="card-body">
                        <div id="aktivitas-form-list"></div>
                    </div>
                </div>
                <div class="card shadow-sm mb-4">
                    <div class="card-header">
                        Riwayat Penghargaan
                        <button type="button" class="btn btn-sm btn-success float-right tambah-riwayat" data-riwayat="penghargaan">+</button>
                    </div>
                    <div class="card-body">
                        <div id="penghargaan-form-list"></div>
                    </div>
                </div>
            </div>

            <!-- Tombol -->
            <div class="d-flex justify-content-end mt-4">
                <a href="<?= base_url('admin/pendaftar_perorangan'); ?>" class="btn btn-secondary mr-2">Batal</a>
                <button type="submit" class="btn btn-primary"><?= isset($sdm) ? 'Update' : 'Simpan'; ?></button>
            </div>

            </form>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.5.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
$(document).ready(function() {
    // Tambah riwayat (sama kayak form user)
    $('.tambah-riwayat').on('click', function() {
        var riwayatType = $(this).data('riwayat');
        var container = $('#' + riwayatType + '-form-list');
        var formIndex = container.children('.riwayat-item').length;
        var formHtml = '';

        if (riwayatType === 'pendidikan') {
            formHtml = `
                <div class="riwayat-item border p-3 mb-2 rounded">
                    <div class="form-row">
                        <div class="form-group col-md-6"><label>Jenjang</label><input type="text" class="form-control" name="pendidikan[${formIndex}][jenjang]"></div>
                        <div class="form-group col-md-6"><label>Nama Sekolah</label><input type="text" class="form-control" name="pendidikan[${formIndex}][nama_sekolah]"></div>
                    </div>
                    <div class="form-row">
                        <div class="form-group col-md-6"><label>Program Studi</label><input type="text" class="form-control" name="pendidikan[${formIndex}][program_studi]"></div>
                        <div class="form-group col-md-6"><label>Tahun Lulus</label><input type="number" class="form-control" name="pendidikan[${formIndex}][tahun_lulus]"></div>
                    </div>
                    <button type="button" class="btn btn-sm btn-danger hapus-riwayat">Hapus</button>
                </div>`;
        }
        // ...lanjutin sama kayak user untuk pelatihan, pekerjaan, aktivitas, penghargaan
        container.append(formHtml);
    });

    // Hapus riwayat
    $(document).on('click', '.hapus-riwayat', function() {
        $(this).closest('.riwayat-item').remove();
    });

    // Ganti label file
    $(document).on('change', '.custom-file-input', function() {
        var fileName = $(this).val().split('\\').pop();
        $(this).next('.custom-file-label').html(fileName);
    });
});
</script>
</body>
</html>