<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Laporan Pendaftar Perorangan</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        h2 { text-align: center; margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #000; padding: 6px; text-align: left; }
        th { background: #f2f2f2; }
        .footer { margin-top: 15px; text-align: right; font-style: italic; font-size: 11px; }
    </style>
</head>
<body>
    <h2>LAPORAN PENDAFTAR PERORANGAN</h2>

    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>Nama Lengkap</th>
                <th>Alamat</th>
                <th>NIK</th>
                <th>Tanggal Daftar</th>
            </tr>
        </thead>
        <tbody>
            <?php $no=1; foreach($perorangan as $p): ?>
            <tr>
                <td><?= $no++; ?></td>
                <td><?= $p->nama_lengkap; ?></td>
                <td><?= $p->alamat; ?></td>
                <td><?= $p->nik; ?></td>
                <td><?= date('d-m-Y H:i', strtotime($p->created_at)); ?></td>
            </tr>
            <?php endforeach; ?>
            <?php if(empty($perorangan)): ?>
            <tr><td colspan="3" style="text-align:center;">Belum ada data</td></tr>
            <?php endif; ?>
        </tbody>
    </table>

    <div class="footer">
        Dicetak pada: <?= date('d-m-Y H:i'); ?>
    </div>
</body>
</html>