<!DOCTYPE html>
<html>
<head>
    <style>
        table { border-collapse: collapse; width: 100%; font-size: 12px; }
        th, td { border: 1px solid #333; padding: 6px; text-align: center; }
        th { background: #f2f2f2; }
        h2 { text-align: center; margin-bottom: 20px; }
    </style>
</head>
<body>
    <h2>📑 Laporan Data Pendaftar Perorangan</h2>
    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>NIK</th>
                <th>NRK</th>
                <th>Nama</th>
                <th>Jenis Kelamin</th>
                <th>No HP</th>
                <th>Status</th>
                <th>Tanggal Daftar</th>
            </tr>
        </thead>
        <tbody>
            <?php $no=1; foreach ($perorangan as $p): ?>
            <tr>
                <td><?= $no++; ?></td>
                <td><?= $p->nik; ?></td>
                <td><?= $p->nrk_perorangan ?: '-'; ?></td>
                <td><?= $p->nama_lengkap; ?></td>
                <td><?= $p->jenis_kelamin; ?></td>
                <td><?= $p->no_hp ?: '-'; ?></td>
                <td><?= ucfirst($p->status); ?></td>
                <td><?= date('d-m-Y', strtotime($p->created_at)); ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</body>
</html>