<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Laporan Pendaftar Kelompok</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        h2 { text-align: center; margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #000; padding: 6px; text-align: left; }
        th { background: #f2f2f2; text-align: center; }
        .sanggar-row { background: #ddd; font-weight: bold; }
        .footer { margin-top: 15px; text-align: right; font-style: italic; font-size: 11px; }
    </style>
</head>
<body>
    <h2>LAPORAN PENDAFTAR KELOMPOK</h2>

    <table>
        <thead>
            <tr>
                <th style="width:30px;">No</th>
                <th>NRK</th>
                <th>Nama Sanggar</th>
                <th>Jenis Seni</th>
                <th>Jenis Lembaga</th>
                <th>Status Hukum</th>
                <th>No HP</th>
                <th>Alamat</th>
                <th>Status</th>
                <th>Tanggal Daftar</th>
            </tr>
        </thead>
        <tbody>
            <?php $no=1; foreach($kelompok as $k): ?>
                <tr>
                    <td style="text-align:center;"><?= $no++; ?></td>
                    <td><?= htmlspecialchars($k->nrk_sanggar ?? '-'); ?></td>
                    <td><?= htmlspecialchars($k->nama_sanggar ?? '-'); ?></td>
                    <td><?= htmlspecialchars($k->jenis_lembaga ?? '-'); ?></td>
                    <td><?= htmlspecialchars($k->status_hukum ?? '-'); ?></td>
                    <td><?= htmlspecialchars($k->jenis_seni_list ?? '-'); ?></td>
                    <td><?= htmlspecialchars($k->no_hp ?? '-'); ?></td>
                    <td><?= htmlspecialchars($k->alamat ?? '-'); ?></td>
                    <td><?= htmlspecialchars($k->status ?? '-'); ?></td>
                    <td style="text-align:center;"><?= htmlspecialchars(date('d-m-Y', strtotime($k->created_at))); ?></td>
                </tr>
                <?php endforeach; ?>
                <?php if(empty($kelompok)): ?>
                    <tr><td colspan="10" style="text-align:center;">Belum ada data</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
            <div class="footer">
                Dicetak pada: <?= htmlspecialchars(date('d-m-Y H:i')); ?>
            </div>
        </body>
</html>







