<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Export Pendaftar Kelompok</title>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th, td { border: 1px solid #333; padding: 6px; text-align: left; }
        th { background-color: #f2f2f2; }
        h2 { text-align: center; margin-bottom: 20px; }
    </style>
</head>
<body>
    <h2>📑 Laporan Pendaftar Kelompok</h2>
    <table>
        <thead>
            <tr>
                <th>NRK</th>
                <th>Nama Sanggar</th>
                <th>Jenis Seni</th>
                <th>Jenis Lembaga</th>
                <th>Status Hukum</th>
                <th>No HP</th>
                <th>Provinsi</th>
                <th>Kabupaten</th>
                <th>Kecamatan</th>
                <th>Desa</th>
                <th>Alamat</th>
                <th>Status</th>
                <th>Tanggal Daftar</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($kelompok)): ?>
                <?php foreach ($kelompok as $k): ?>
                    <tr>
                        <td><?= $k->nrk_sanggar ?: '-'; ?></td>
                        <td><?= $k->nama_sanggar; ?></td>
                        <td><?= $k->nama_seni; ?></td>
                        <td><?= $k->jenis_lembaga; ?></td>
                        <td><?= $k->status_hukum; ?></td>
                        <td><?= $k->no_hp; ?></td>
                        <td><?= $k->provinsi; ?></td>
                        <td><?= $k->kabupaten; ?></td>
                        <td><?= $k->kecamatan; ?></td>
                        <td><?= $k->desa; ?></td>
                        <td><?= $k->alamat; ?></td>
                        <td><?= ucfirst($k->status); ?></td>
                        <td><?= date('d-m-Y', strtotime($k->created_at)); ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="13" class="text-center">Tidak ada data</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</body>
</html>