<div class="container-fluid">
    <h2 class="mb-4 text-warning fw-bold">✏ Edit Pendaftar Kelompok</h2>

    <form action="<?= base_url('admin/update_kelompok/'.$kelompok->id_sanggar); ?>" method="post">
        <div class="card shadow-sm rounded-3 p-3 mb-3">
            <h5 class="fw-bold text-secondary">🏢 Identitas Lembaga</h5>
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">NRK Sanggar</label>
                    <input type="text" name="nrk_sanggar" class="form-control" value="<?= $kelompok->nrk_sanggar; ?>">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Nama Sanggar *</label>
                    <input type="text" name="nama_sanggar" class="form-control" required value="<?= $kelompok->nama_sanggar; ?>">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Jenis Lembaga *</label>
                    <select name="jenis_lembaga" class="form-select" required>
                        <option value="Sanggar" <?= $kelompok->jenis_lembaga == 'Sanggar' ? 'selected' : ''; ?>>Sanggar</option>
                        <option value="Kelompok" <?= $kelompok->jenis_lembaga == 'Kelompok' ? 'selected' : ''; ?>>Kelompok</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Jenis Seni *</label>
                    <select name="jenis_seni" class="form-select" required>
                        <?php foreach ($jenis_seni as $s): ?>
                            <option value="<?= $s['id_seni']; ?>" <?= $s['id_seni'] == $kelompok->id_seni ? 'selected' : ''; ?>>
                                <?= $s['nama_seni']; ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Status Hukum *</label>
                    <select name="status_hukum" class="form-select" required>
                        <option value="Berbadan Hukum" <?= $kelompok->status_hukum == 'Berbadan Hukum' ? 'selected' : ''; ?>>Berbadan Hukum</option>
                        <option value="Non-Berbadan Hukum" <?= $kelompok->status_hukum == 'Non-Berbadan Hukum' ? 'selected' : ''; ?>>Non-Berbadan Hukum</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Nomor Identitas</label>
                    <input type="text" name="nomor_identitas" class="form-control" value="<?= $kelompok->nomor_identitas; ?>">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Tanggal Berdiri</label>
                    <input type="date" name="tanggal_berdiri" class="form-control" value="<?= $kelompok->tanggal_berdiri; ?>">
                </div>
                <div class="col-md-12">
                    <label class="form-label">Tujuan</label>
                    <textarea name="tujuan" class="form-control"><?= $kelompok->tujuan; ?></textarea>
                </div>
                <div class="col-md-12">
                    <label class="form-label">Deskripsi</label>
                    <textarea name="deskripsi" class="form-control"><?= $kelompok->deskripsi; ?></textarea>
                </div>
            </div>
        </div>

        <div class="card shadow-sm rounded-3 p-3 mb-3">
            <h5 class="fw-bold text-secondary">📞 Kontak</h5>
            <div class="row g-3">
                <div class="col-md-4"><label class="form-label">No HP *</label><input type="text" name="no_hp" class="form-control" value="<?= $kelompok->no_hp; ?>" required></div>
                <div class="col-md-4"><label class="form-label">Email</label><input type="email" name="alamat_email" class="form-control" value="<?= $kelompok->alamat_email; ?>"></div>
                <div class="col-md-4"><label class="form-label">Website</label><input type="text" name="alamat_website" class="form-control" value="<?= $kelompok->alamat_website; ?>"></div>
                <div class="col-md-4"><label class="form-label">Facebook</label><input type="text" name="akun_facebook" class="form-control" value="<?= $kelompok->akun_facebook; ?>"></div>
                <div class="col-md-4"><label class="form-label">Twitter</label><input type="text" name="akun_twitter" class="form-control" value="<?= $kelompok->akun_twitter; ?>"></div>
                <div class="col-md-4"><label class="form-label">Instagram</label><input type="text" name="akun_instagram" class="form-control" value="<?= $kelompok->akun_instagram; ?>"></div>
                <div class="col-md-4"><label class="form-label">Youtube</label><input type="text" name="akun_youtube" class="form-control" value="<?= $kelompok->akun_youtube; ?>"></div>
            </div>
        </div>

        <div class="card shadow-sm rounded-3 p-3 mb-3">
            <h5 class="fw-bold text-secondary">📍 Alamat</h5>
            <div class="row g-3">
                <div class="col-md-3"><label class="form-label">Provinsi *</label><input type="text" name="provinsi" class="form-control" value="<?= $kelompok->provinsi; ?>" required></div>
                <div class="col-md-3"><label class="form-label">Kabupaten *</label><input type="text" name="kabupaten" class="form-control" value="<?= $kelompok->kabupaten; ?>" required></div>
                <div class="col-md-3"><label class="form-label">Kecamatan *</label><input type="text" name="kecamatan" class="form-control" value="<?= $kelompok->kecamatan; ?>" required></div>
                <div class="col-md-3"><label class="form-label">Desa *</label><input type="text" name="desa" class="form-control" value="<?= $kelompok->desa; ?>" required></div>
                <div class="col-md-6"><label class="form-label">Alamat Lengkap *</label><input type="text" name="alamat" class="form-control" value="<?= $kelompok->alamat; ?>" required></div>
                <div class="col-md-3"><label class="form-label">Latitude</label><input type="text" name="latitude" class="form-control" value="<?= $kelompok->latitude; ?>"></div>
                <div class="col-md-3"><label class="form-label">Longitude</label><input type="text" name="longitude" class="form-control" value="<?= $kelompok->longitude; ?>"></div>
            </div>
        </div>

        <div class="mt-3">
            <a href="<?= base_url('admin/pendaftar_kelompok'); ?>" class="btn btn-secondary">⬅ Batal</a>
            <button type="submit" class="btn btn-warning">💾 Update</button>
        </div>
    </form>
</div>