<div class="container-fluid py-4">
    <h2 class="mb-4 text-primary fw-bold">👤 Detail Pendaftar Perorangan</h2>

    <div class="card shadow-sm border-0 rounded-4 mb-4">
        <div class="card-header bg-primary text-white d-flex align-items-center rounded-top-4">
            <i class="fas fa-id-card me-2"></i>
            <h5 class="m-0">Informasi Dasar</h5>
        </div>
        <div class="card-body">
            <div class="row g-3">
                <div class="col-md-6">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between align-items-center ps-0">
                            <strong>NIK</strong>
                            <span><?= $sdm->nik; ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center ps-0">
                            <strong>NRK</strong>
                            <span><?= $sdm->nrk_perorangan ?: '-'; ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center ps-0">
                            <strong>Nama Lengkap</strong>
                            <span><?= $sdm->nama_lengkap; ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center ps-0">
                            <strong>Nama Alias</strong>
                            <span><?= $sdm->nama_alias ?: '-'; ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center ps-0">
                            <strong>Gelar Pendidikan</strong>
                            <span><?= $sdm->gelar_pendidikan ?: '-'; ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center ps-0">
                            <strong>Jenis Kelamin</strong>
                            <span><?= ($sdm->jenis_kelamin == 'L') ? 'Pria' : (($sdm->jenis_kelamin == 'P') ? 'Wanita' : '-'); ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center ps-0">
                            <strong>Agama</strong>
                            <span><?= $sdm->agama ?: '-'; ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center ps-0">
                            <strong>Kewarganegaraan</strong>
                            <span><?= $sdm->kewarganegaraan ?: '-'; ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center ps-0">
                            <strong>Jenis Seni</strong>
                            <span><?= $sdm->jenis_seni_list ?: '-'; ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center ps-0">
                            <strong>Status</strong>
                            <span class="badge <?= $sdm->status == 'valid' ? 'bg-success' : 'bg-secondary'; ?>">
                                <?= ucfirst($sdm->status); ?>
                            </span>
                        </li>
                    </ul>
                </div>
                <div class="col-md-6">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex justify-content-between align-items-center ps-0">
                            <strong>Tempat, Tanggal Lahir</strong>
                            <span><?= $sdm->tempat_lahir ?: '-' ?>, <?= $sdm->tanggal_lahir ? date('d-m-Y', strtotime($sdm->tanggal_lahir)) : '-' ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center ps-0">
                            <strong>Nama Ayah</strong>
                            <span><?= $sdm->nama_ayah ?: '-'; ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center ps-0">
                            <strong>Nama Ibu</strong>
                            <span><?= $sdm->nama_ibu ?: '-'; ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center ps-0">
                            <strong>No. HP</strong>
                            <span><?= $sdm->no_hp ?: '-'; ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center ps-0">
                            <strong>Email</strong>
                            <span><?= $sdm->email ?: '-'; ?></span>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center ps-0">
                            <strong>Alamat</strong>
                            <p class="text-muted mb-0">
                                <?= $sdm->alamat ?: ''; ?><br>
                                <?= $sdm->desa ?: ''; ?>, <?= $sdm->kecamatan ?: ''; ?><br>
                                <?= $sdm->kabupaten ?: ''; ?>, <?= $sdm->provinsi ?: ''; ?>
                            </p>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center ps-0">
                            <strong>Koordinat</strong>
                            <span><?= $sdm->latitude ?: '-' ?> , <?= $sdm->longitude ?: '-' ?></span>
                        </li>
                        <li class="list-group-item ps-0">
                            <strong>Media Sosial</strong>
                            <p class="text-muted mb-0">
                                FB: <?= $sdm->facebook ?: '-' ?><br>
                                IG: <?= $sdm->instagram ?: '-' ?><br>
                                YT: <?= $sdm->youtube ?: '-' ?><br>
                                TW: <?= $sdm->twitter ?: '-' ?><br>
                                Website: <?= $sdm->website ?: '-' ?>
                            </p>
                        </li>
                        <li class="list-group-item d-flex justify-content-between align-items-center ps-0">
                            <strong>Tanggal Daftar</strong>
                            <span><?= date('d-m-Y H:i', strtotime($sdm->created_at)); ?></span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="card shadow-sm border-0 rounded-4 mb-4">
        <div class="card-header bg-secondary text-white d-flex align-items-center rounded-top-4">
            <i class="fas fa-graduation-cap me-2"></i>
            <h5 class="m-0">Riwayat Pendidikan</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover mb-0">
                    <thead>
                        <tr>
                            <th>Jenjang</th>
                            <th>Nama Sekolah</th>
                            <th>Program Studi</th>
                            <th>Tahun Lulus</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($pendidikan): foreach ($pendidikan as $p): ?>
                            <tr>
                                <td><?= $p->jenjang ?></td>
                                <td><?= $p->nama_sekolah ?></td>
                                <td><?= $p->program_studi ?></td>
                                <td><?= $p->tahun_lulus ?></td>
                            </tr>
                        <?php endforeach; else: ?>
                            <tr><td colspan="4" class="text-center text-muted">Belum ada data</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="card shadow-sm border-0 rounded-4 mb-4">
        <div class="card-header bg-info text-white d-flex align-items-center rounded-top-4">
            <i class="fas fa-briefcase me-2"></i>
            <h5 class="m-0">Riwayat Pekerjaan</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover mb-0">
                    <thead>
                        <tr>
                            <th>Nama Pekerjaan</th>
                            <th>Tempat Kerja</th>
                            <th>Jabatan</th>
                            <th>Status</th>
                            <th>Periode</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($pekerjaan): foreach ($pekerjaan as $pk): ?>
                            <tr>
                                <td><?= $pk->nama_pekerjaan ?></td>
                                <td><?= $pk->nama_tempat_kerja ?></td>
                                <td><?= $pk->jabatan ?></td>
                                <td><?= $pk->status ?></td>
                                <td><?= $pk->mulai_kerja ?> - <?= $pk->selesai_kerja ?: 'Sekarang' ?></td>
                            </tr>
                        <?php endforeach; else: ?>
                            <tr><td colspan="5" class="text-center text-muted">Belum ada data</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="card shadow-sm border-0 rounded-4 mb-4">
        <div class="card-header bg-warning text-white d-flex align-items-center rounded-top-4">
            <i class="fas fa-chalkboard-teacher me-2"></i>
            <h5 class="m-0">Riwayat Pelatihan</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover mb-0">
                    <thead>
                        <tr>
                            <th>Nama Pelatihan</th>
                            <th>Jenis</th>
                            <th>Tingkat</th>
                            <th>Peran</th>
                            <th>Tahun</th>
                            <th>Penyelenggara</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($pelatihan): foreach ($pelatihan as $pl): ?>
                            <tr>
                                <td><?= $pl->nama_pelatihan ?></td>
                                <td><?= $pl->jenis_pelatihan ?></td>
                                <td><?= $pl->tingkat_pelatihan ?></td>
                                <td><?= $pl->peran ?></td>
                                <td><?= $pl->tahun ?></td>
                                <td><?= $pl->penyelenggara ?></td>
                            </tr>
                        <?php endforeach; else: ?>
                            <tr><td colspan="6" class="text-center text-muted">Belum ada data</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="card shadow-sm border-0 rounded-4 mb-4">
        <div class="card-header bg-success text-white d-flex align-items-center rounded-top-4">
            <i class="fas fa-trophy me-2"></i>
            <h5 class="m-0">Penghargaan</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover mb-0">
                    <thead>
                        <tr>
                            <th>Nama Penghargaan</th>
                            <th>Peran</th>
                            <th>Pemberi</th>
                            <th>Tingkat</th>
                            <th>Tahun</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($penghargaan): foreach ($penghargaan as $ph): ?>
                            <tr>
                                <td><?= $ph->nama_penghargaan ?></td>
                                <td><?= $ph->peran ?></td>
                                <td><?= $ph->pemberi ?></td>
                                <td><?= $ph->tingkat ?></td>
                                <td><?= $ph->tahun ?></td>
                            </tr>
                        <?php endforeach; else: ?>
                            <tr><td colspan="5" class="text-center text-muted">Belum ada data</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="card shadow-sm border-0 rounded-4 mb-4">
        <div class="card-header bg-danger text-white d-flex align-items-center rounded-top-4">
            <i class="fas fa-theater-masks me-2"></i>
            <h5 class="m-0">Aktivitas</h5>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover mb-0">
                    <thead>
                        <tr>
                            <th>Nama Kegiatan</th>
                            <th>Peran</th>
                            <th>Penyelenggara</th>
                            <th>Tingkat</th>
                            <th>Tahun</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if ($aktivitas): foreach ($aktivitas as $a): ?>
                            <tr>
                                <td><?= $a->nama_kegiatan ?></td>
                                <td><?= $a->peran ?></td>
                                <td><?= $a->penyelenggara ?></td>
                                <td><?= $a->tingkat ?></td>
                                <td><?= $a->tahun ?></td>
                            </tr>
                        <?php endforeach; else: ?>
                            <tr><td colspan="5" class="text-center text-muted">Belum ada data</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="mt-4 text-center">
        <a href="<?= base_url('admin/pendaftar_perorangan'); ?>" class="btn btn-secondary btn-sm me-2">
            <i class="fas fa-arrow-left me-1"></i> Kembali
        </a>
        <a href="<?= base_url('admin/edit_perorangan/'.$sdm->id_sdm); ?>" class="btn btn-warning btn-sm me-2">
            <i class="fas fa-edit me-1"></i> Edit
        </a>
        <a href="<?= base_url('admin/hapus_perorangan/'.$sdm->id_sdm); ?>" 
           onclick="return confirm('Yakin hapus data ini?')" 
           class="btn btn-danger btn-sm">
            <i class="fas fa-trash-alt me-1"></i> Hapus
        </a>
    </div>
</div>