<div class="container-fluid">
    <h2 class="mb-4 text-success fw-bold">👥 Detail Pendaftar Kelompok</h2>

    <?php if ($kelompok): ?>
        <!-- Identitas Lembaga -->
        <div class="card shadow-sm rounded-3 p-3 mb-3">
            <h5 class="fw-bold text-secondary">🏢 Identitas Lembaga</h5>
            <div class="row g-3">
                <div class="col-md-4"><strong>NRK</strong><br><?= $kelompok->nrk_sanggar ?: '-'; ?></div>
                <div class="col-md-4"><strong>Nama Sanggar</strong><br><?= $kelompok->nama_sanggar; ?></div>
                <div class="col-md-4"><strong>Jenis Seni</strong><br><?= $kelompok->jenis_seni_list ?? '-'; ?></div>
                <div class="col-md-4"><strong>Jenis Lembaga</strong><br><?= $kelompok->jenis_lembaga ?? '-'; ?></div>
                <div class="col-md-4"><strong>Status Hukum</strong><br><?= $kelompok->status_hukum ?? '-'; ?></div>
                <div class="col-md-4"><strong>Nomor Identitas</strong><br><?= $kelompok->nomor_identitas ?? '-'; ?></div>
                <div class="col-md-4"><strong>Tanggal Berdiri</strong><br><?= $kelompok->tanggal_berdiri ?? '-'; ?></div>
                <div class="col-md-8"><strong>Tujuan</strong><br><?= $kelompok->tujuan ?? '-'; ?></div>
                <div class="col-md-12"><strong>Deskripsi</strong><br><?= $kelompok->deskripsi ?? '-'; ?></div>
            </div>
        </div>

        <!-- Kontak -->
        <div class="card shadow-sm rounded-3 p-3 mb-3">
            <h5 class="fw-bold text-secondary">📞 Kontak Lembaga</h5>
            <div class="row g-3">
                <div class="col-md-4"><strong>No HP</strong><br><?= $kelompok->no_hp ?? '-'; ?></div>
                <div class="col-md-4"><strong>Email</strong><br><?= $kelompok->email ?? '-'; ?></div>
                <div class="col-md-4"><strong>Website</strong><br><?= $kelompok->website ?? '-'; ?></div>
                <div class="col-md-4"><strong>Facebook</strong><br><?= $kelompok->facebook ?? '-'; ?></div>
                <div class="col-md-4"><strong>Instagram</strong><br><?= $kelompok->instagram ?? '-'; ?></div>
                <div class="col-md-4"><strong>Youtube</strong><br><?= $kelompok->youtube ?? '-'; ?></div>
                <div class="col-md-4"><strong>Twitter</strong><br><?= $kelompok->twitter ?? '-'; ?></div>
            </div>
        </div>

        <!-- Alamat -->
        <div class="card shadow-sm rounded-3 p-3 mb-3">
            <h5 class="fw-bold text-secondary">📍 Alamat Lembaga</h5>
            <div class="row g-3">
                <div class="col-md-3"><strong>Provinsi</strong><br><?= $kelompok->provinsi ?? '-'; ?></div>
                <div class="col-md-3"><strong>Kabupaten</strong><br><?= $kelompok->kabupaten ?? '-'; ?></div>
                <div class="col-md-3"><strong>Kecamatan</strong><br><?= $kelompok->kecamatan ?? '-'; ?></div>
                <div class="col-md-3"><strong>Desa</strong><br><?= $kelompok->desa ?? '-'; ?></div>
                <div class="col-md-12"><strong>Alamat Lengkap</strong><br><?= $kelompok->alamat ?? '-'; ?></div>
                <div class="col-md-3"><strong>Latitude</strong><br><?= $kelompok->latitude ?? '-'; ?></div>
                <div class="col-md-3"><strong>Longitude</strong><br><?= $kelompok->longitude ?? '-'; ?></div>
            </div>
        </div>
        <div class="card shadow-sm rounded-3 p-3 mb-3">
    <h5 class="fw-bold text-secondary">👥 Pengurus Lembaga</h5>
    <div class="table-responsive">
        <table class="table table-bordered table-hover align-middle">
            <thead class="table-info">
                <tr>
                    <th>Peran</th>
                    <th>NIK</th>
                    <th>Nama</th>
                    <th>Gelar</th>
                    <th>JK</th>
                    <th>Tempat Lahir</th>
                    <th>Tgl Lahir</th>
                    <th>Warga Negara</th>
                    <th>Agama</th>
                    <th>HP</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($pengurus)): ?>
                    <?php foreach ($pengurus as $p): ?>
                        <tr>
                            <td><?= htmlspecialchars($p->nama_peran ?? '-'); ?></td>
                            <td><?= htmlspecialchars($p->nik ?? '-'); ?></td>
                            <td><?= htmlspecialchars($p->nama_lengkap ?? '-'); ?></td>
                            <td><?= htmlspecialchars($p->gelar_pendidikan ?? '-'); ?></td>
                            <td><?= htmlspecialchars($p->jenis_kelamin ?? '-'); ?></td>
                            <td><?= htmlspecialchars($p->tempat_lahir ?? '-'); ?></td>
                            <td><?= htmlspecialchars($p->tanggal_lahir ?? '-'); ?></td>
                            <td><?= htmlspecialchars($p->kewarganegaraan ?? '-'); ?></td>
                            <td><?= htmlspecialchars($p->agama ?? '-'); ?></td>
                            <td><?= htmlspecialchars($p->no_hp ?? '-'); ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="10" class="text-center">Belum ada data pengurus.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<div class="card shadow-sm rounded-3 p-3 mb-3">
    <h5 class="fw-bold text-secondary">👥 Anggota Lembaga</h5>
    <div class="table-responsive">
        <table class="table table-bordered table-hover align-middle">
            <thead class="table-info">
                <tr>
                    <th>NIK</th>
                    <th>Nama Anggota</th>
                    <th>JK</th>
                    <th>Tempat Lahir</th>
                    <th>Tgl Lahir</th>
                    <th>Warga Negara</th>
                    <th>Agama</th>
                    <th>Nomor HP</th>
                    <th>Level</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($anggota)): ?>
                    <?php foreach ($anggota as $a): ?>
                        <tr>
                            <td><?= htmlspecialchars($a->nik ?? '-'); ?></td>
                            <td><?= htmlspecialchars($a->nama_anggota ?? '-'); ?></td>
                            <td><?= htmlspecialchars($a->jenis_kelamin ?? '-'); ?></td>
                            <td><?= htmlspecialchars($a->tempat_lahir ?? '-'); ?></td>
                            <td><?= htmlspecialchars($a->tanggal_lahir ?? '-'); ?></td>
                            <td><?= htmlspecialchars($a->kewarganegaraan ?? '-'); ?></td>
                            <td><?= htmlspecialchars($a->agama ?? '-'); ?></td>
                            <td><?= htmlspecialchars($a->nomor_hp ?? '-'); ?></td>
                            <td><?= htmlspecialchars($a->nama_level ?? '-'); ?></td>
                            <td><?= ucfirst(htmlspecialchars($a->status ?? '-')); ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="10" class="text-center">Belum ada data anggota.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

        <!-- Status -->
        <div class="card shadow-sm rounded-3 p-3 mb-3">
            <h5 class="fw-bold text-secondary">📌 Status</h5>
            <div>
                <span class="badge <?= $kelompok->status == 'valid' ? 'bg-success' : 'bg-secondary'; ?>">
                    <?= ucfirst($kelompok->status); ?>
                </span>
            </div>
        </div>

        <!-- Tombol -->
        <div class="mt-3">
            <a href="<?= base_url('admin/pendaftar_kelompok'); ?>" class="btn btn-secondary">⬅ Kembali</a>
        </div>
    <?php else: ?>
        <div class="alert alert-danger">Data tidak ditemukan</div>
    <?php endif; ?>
</div>