<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?= $title; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: #f4f7fc;
            color: #34495e;
            padding: 20px;
        }
        .dashboard-header {
            text-align: center;
            margin-bottom: 40px;
        }
        .dashboard-header h1 {
            font-size: 2.5rem;
            font-weight: 700;
            color: #0d6efd;
        }
        .card-stats {
            border: none;
            border-radius: 15px;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
            display: flex;
            align-items: center;
            padding: 20px;
            transition: all .3s;
        }
        .card-stats:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 30px rgba(0,0,0,.15);
        }
        .card-stats .icon-wrapper {
            width: 60px; height: 60px;
            border-radius: 50%;
            display: flex; justify-content: center; align-items: center;
            font-size: 1.8rem;
            margin-right: 20px;
        }
        .stat-primary .icon-wrapper { background: #e6f0ff; color: #0d6efd; }
        .stat-success .icon-wrapper { background: #eaf7f1; color: #198754; }
        .stat-warning .icon-wrapper { background: #fff8e6; color: #ffc107; }

        .card-chart, .card-table {
            border: none;
            border-radius: 15px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
            padding: 20px;
            margin-bottom: 30px;
        }
        table th {
            background: #0d6efd;
            color: #fff;
            text-align: center;
        }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="dashboard-header">
        <h1>Dashboard Admin</h1>
        <p>Selamat datang, admin! Berikut ringkasan data pendaftaran seni.</p>
    </div>

    <!-- Statistik -->
<div class="row mb-4">
    <div class="col-md-4">
        <div class="card-stats stat-primary">
            <div class="icon-wrapper">📑</div>
            <div>
                <h5>Total Pendaftaran</h5>
                <h3><?= $total_pendaftar; ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card-stats stat-success">
            <div class="icon-wrapper">👤</div>
            <div>
                <h5>Pendaftar Perorangan</h5>
                <h3><?= $total_perorangan; ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card-stats stat-warning">
            <div class="icon-wrapper">👥</div>
            <div>
                <h5>Pendaftar Kelompok</h5>
                <h3><?= $total_kelompok; ?></h3>
            </div>
        </div>
    </div>
</div>

<!-- Chart -->
<div class="row">
    <div class="col-md-6">
        <div class="card-chart">
            <h5>Distribusi Jenis Pendaftar</h5>
            <canvas id="pendaftarPieChart"></canvas>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card-chart">
            <h5>Jenis Seni Terpopuler (Top 5)</h5>
            <canvas id="seniBarChart"></canvas>
        </div>
    </div>
</div>

<!-- Tabel Perorangan -->
<div class="card-table">
    <h5>5 Pendaftar Perorangan Terbaru</h5>
    <table class="table table-bordered table-hover mt-3">
        <thead>
            <tr>
                <th>No</th>
                <th>Nama Lengkap</th>
                <th>Jenis Seni</th>
                <th>Tanggal Daftar</th>
            </tr>
        </thead>
        <tbody>
        <?php if (!empty($pendaftaran)): $no=1; foreach ($pendaftaran as $p): ?>
            <tr>
                <td class="text-center"><?= $no++; ?></td>
                <td><?= $p->nama_lengkap; ?></td>
                <td><?= $p->nama_seni ?? '-'; ?></td>
                <td><?= date('d-m-Y', strtotime($p->created_at)); ?></td>
            </tr>
        <?php endforeach; else: ?>
            <tr><td colspan="4" class="text-center">Belum ada data</td></tr>
        <?php endif; ?>
        </tbody>
    </table>
    <a href="<?= site_url('admin/pendaftar_perorangan'); ?>" class="btn btn-sm btn-primary">Lihat Semua</a>
</div>


<!-- Tabel Kelompok -->
<div class="card-table mt-4">
    <h5>5 Pendaftar Kelompok Terbaru</h5>
    <table class="table table-bordered table-hover mt-3">
        <thead>
            <tr>
                <th>No</th>
                <th>Nama Sanggar</th>
                <th>Deskripsi</th>
                <th>Tanggal Daftar</th>
            </tr>
        </thead>
        <tbody>
        <?php if (!empty($pendaftaran_kelompok)): $no=1; foreach ($pendaftaran_kelompok as $k): ?>
            <tr>
                <td class="text-center"><?= $no++; ?></td>
                <td><?= $k->nama_sanggar; ?></td>
                <td><?= $k->deskripsi ?? '-'; ?></td>
                <td><?= date('d-m-Y', strtotime($k->created_at)); ?></td>
            </tr>
        <?php endforeach; else: ?>
            <tr><td colspan="4" class="text-center">Belum ada data</td></tr>
        <?php endif; ?>
        </tbody>
    </table>
    <a href="<?= site_url('admin/pendaftar_kelompok'); ?>" class="btn btn-sm btn-primary">Lihat Semua</a>
</div>


<script>
// ==================== PIE CHART ====================
const pieCtx = document.getElementById('pendaftarPieChart').getContext('2d');
new Chart(pieCtx, {
    type: 'pie',
    data: {
        labels: ['Perorangan', 'Kelompok'],
        datasets: [{
            data: [
                <?= ($total_perorangan > 0 ? $total_perorangan : 0.001); ?>,
                <?= ($total_kelompok > 0 ? $total_kelompok : 0.001); ?>
            ],
            backgroundColor: ['#0d6efd', '#198754']
        }]
    },
    options: { responsive: true }
});

// ==================== BAR CHART ====================
const barCtx = document.getElementById('seniBarChart').getContext('2d');
new Chart(barCtx, {
    type: 'bar',
    data: {
        labels: <?= !empty($seni_labels) ? $seni_labels : '[]'; ?>,
        datasets: [{
            data: <?= !empty($seni_values) ? $seni_values : '[]'; ?>,
            backgroundColor: ['#0d6efd','#198754','#ffc107','#dc3545','#6c757d']
        }]
    },
    options: {
        responsive: true,
        plugins: { legend: { display: false } },
        scales: { y: { beginAtZero: true } }
    }
});
</script>

</body>
</html>