<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Pendaftaran_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

   
    public function get_all_jenis_seni()
{
    return $this->db->get('jenis_seni')->result_array(); // biar bisa dipanggil pakai $row['id_seni']
}


    public function get_all_peran() {
        return $this->db->get('master_peran')->result_array();
    }

    public function get_all_level() {
        return $this->db->get('master_level')->result_array();
    }

    
    public function create_sanggar($data) {
        $this->db->insert('sanggar', $data);
        return $this->db->insert_id();
    }

    
    public function create_sanggar_alamat_kontak($data) {
        return $this->db->insert('sanggar_alamat_kontak', $data);
    }

    
    public function create_sanggar_media_legalitas($data) {
        return $this->db->insert('sanggar_media_legalitas', $data);
    }

    
    public function create_sanggar_kegiatan($data) {
        if (!empty($data)) {
            return $this->db->insert_batch('sanggar_kegiatan', $data);
        }
        return 0;
    }

    
    public function create_sanggar_penghargaan($data) {
        if (!empty($data)) {
            return $this->db->insert_batch('sanggar_penghargaan', $data);
        }
        return 0;
    }
    
    /**
     * Menyimpan data pengurus sanggar ke tabel 'pengurus_sanggar'.
     * @param array $data
     * @return int Jumlah baris yang berhasil di-insert.
     */
    public function create_pengurus_sanggar($data) {
        if (!empty($data)) {
            return $this->db->insert_batch('pengurus_sanggar', $data);
        }
        return 0;
    }

    /**
     * Menyimpan data anggota kelompok ke tabel 'anggota_kelompok'.
     * @param array $data
     * @return int Jumlah baris yang berhasil di-insert.
     */
    public function create_anggota_kelompok($data) {
        if (!empty($data)) {
            return $this->db->insert_batch('anggota_kelompok', $data);
        }
        return 0;
    }

    /**
     * Mengecek apakah nama sanggar sudah ada di database.
     * @param string $nama_sanggar
     * @return bool
     */
    public function is_nama_sanggar_unique($nama_sanggar) {
        $this->db->where('nama_sanggar', $nama_sanggar);
        $query = $this->db->get('sanggar');
        return $query->num_rows() == 0;
    }
    
    /**
     * Mengambil data SDM dari tabel 'sdm' berdasarkan NIK.
     * @param string $nik
     * @return object|null
     */
    public function get_sdm_by_nik($nik) {
        return $this->db->get_where('sdm', ['nik' => $nik])->row();
    }

    /**
     * Menyimpan data SDM ke tabel 'sdm'.
     * @param array $data
     * @return int ID SDM yang baru dibuat.
     */
    public function create_sdm($data) {
        $this->db->insert('sdm', $data);
        return $this->db->insert_id();
    }

    /**
     * Memperbarui jenis SDM di tabel 'sdm'.
     * @param int $id_sdm
     * @param string $jenis_sdm
     * @return bool
     */
    public function update_sdm_type($id_sdm, $jenis_sdm) {
        return $this->db->update('sdm', ['jenis_sdm' => $jenis_sdm], ['id_sdm' => $id_sdm]);
    }
    
    /**
     * Mengambil ID peran dari tabel 'master_peran' berdasarkan nama peran.
     * @param string $nama_peran
     * @return int|null
     */
    public function get_peran_id($nama_peran) {
        $query = $this->db->get_where('master_peran', ['nama_peran' => $nama_peran])->row();
        return $query ? $query->id_peran : null;
    }

    /**
     * Mengambil ID level dari tabel 'master_level' berdasarkan nama level.
     * @param string $nama_level
     * @return int|null
     */
    public function get_level_id($nama_level) {
        $query = $this->db->get_where('master_level', ['nama_level' => $nama_level])->row();
        return $query ? $query->id_level : null;
    }

    /**
     * Mengambil data sanggar berdasarkan NIK SDM yang terdaftar sebagai pengurus.
     * @param string $nik
     * @return object|null
     */
    public function get_sanggar_by_pengurus_nik($nik) {
    // Select the necessary columns from the sanggar and sanggar_alamat_kontak tables
    $this->db->select('s.*, sak.alamat, sak.no_hp');
    $this->db->from('sdm');
    $this->db->join('pengurus_sanggar ps', 'ps.id_sdm = sdm.id_sdm');
    $this->db->join('sanggar s', 's.id_sanggar = ps.id_sanggar');
    $this->db->join('sanggar_alamat_kontak sak', 'sak.id_sanggar = s.id_sanggar', 'left');
    
    // Do NOT join directly to 'jenis_seni'. The list of art types is fetched separately.

    $this->db->where('sdm.nik', $nik);
    $this->db->order_by('s.created_at', 'DESC');
    $this->db->limit(1);
    
    return $this->db->get()->row();
}
    
    /**
     * Mengambil semua pengurus dari sebuah sanggar, dengan detail SDM.
     * @param int $id_sanggar
     * @return array
     */
    public function get_pengurus_sanggar($id_sanggar) {
    // Perbaikan: Hapus sdm.no_hp dan ganti dengan sak.no_hp
    $this->db->select('ps.*, sdm.nama_lengkap, sak.no_hp, master_peran.nama_peran');
    $this->db->from('pengurus_sanggar ps');
    $this->db->join('sdm', 'sdm.id_sdm = ps.id_sdm');
    // Perbaikan: Tambahkan JOIN ke tabel sdm_alamat_kontak
    $this->db->join('sdm_alamat_kontak sak', 'sak.id_sdm = sdm.id_sdm', 'left');
    $this->db->join('master_peran', 'master_peran.id_peran = ps.id_peran');
    $this->db->where('ps.id_sanggar', $id_sanggar);
    return $this->db->get()->result();
}

    

    public function get_anggota_by_sanggar($id_sanggar) {
    $this->db->select('ak.*, ml.nama_level');
    $this->db->from('anggota_kelompok ak');
    $this->db->join('master_level ml', 'ml.id_level = ak.id_level', 'left');
    $this->db->where('ak.id_sanggar', $id_sanggar);
    return $this->db->get()->result();
}


    public function get_sdm_seni($id_sdm) {
    $this->db->select('sdm_seni.*, jenis_seni.nama_seni');
    $this->db->from('sdm_seni');
    $this->db->join('jenis_seni', 'sdm_seni.id_seni = jenis_seni.id_seni', 'left');
    $this->db->where('sdm_seni.id_sdm', $id_sdm);
    $query = $this->db->get();
    return $query->result();
}
    
    /**
     * Mengambil data user berdasarkan ID user.
     * @param int $id_user
     * @return object
     */
    public function get_user_by_id($id_user) {
        return $this->db->get_where('users', ['id_user' => $id_user])->row();
    }

    // --- FUNGSI BARU UNTUK RIWAYAT PERORANGAN ---

    /**
     * Menyimpan data riwayat pendidikan.
     */
    public function create_sdm_pendidikan($data) {
        return $this->db->insert('sdm_pendidikan', $data);
    }
    
    /**
     * Menyimpan data riwayat pelatihan.
     */
    public function create_sdm_pelatihan($data) {
        return $this->db->insert('sdm_pelatihan', $data);
    }
    
    /**
     * Menyimpan data riwayat pekerjaan.
     */
    public function create_sdm_pekerjaan($data) {
        return $this->db->insert('sdm_pekerjaan', $data);
    }
    
    /**
     * Menyimpan data riwayat aktivitas.
     */
    public function create_sdm_aktivitas($data) {
        return $this->db->insert('sdm_aktivitas', $data);
    }
    
    /**
     * Menyimpan data riwayat penghargaan.
     */
    public function create_sdm_penghargaan($data) {
        return $this->db->insert('sdm_penghargaan', $data);
    }

    // --- FUNGSI BARU UNTUK GET RIWAYAT PERORANGAN ---
    public function get_riwayat_pendidikan_by_sdm($id_sdm) {
        return $this->db->get_where('sdm_pendidikan', ['id_sdm' => $id_sdm])->result();
    }

    public function get_riwayat_pelatihan_by_sdm($id_sdm) {
        return $this->db->get_where('sdm_pelatihan', ['id_sdm' => $id_sdm])->result();
    }

    public function get_riwayat_pekerjaan_by_sdm($id_sdm) {
        return $this->db->get_where('sdm_pekerjaan', ['id_sdm' => $id_sdm])->result();
    }

    public function get_riwayat_aktivitas_by_sdm($id_sdm) {
        return $this->db->get_where('sdm_aktivitas', ['id_sdm' => $id_sdm])->result();
    }

    public function get_riwayat_penghargaan_by_sdm($id_sdm) {
        return $this->db->get_where('sdm_penghargaan', ['id_sdm' => $id_sdm])->result();
    }
    
    // --- FUNGSI BARU UNTUK UPDATE DAN DELETE RIWAYAT PERORANGAN ---
    public function update_riwayat_pendidikan($id, $data) {
        return $this->db->update('sdm_pendidikan', $data, ['id_pendidikan' => $id]);
    }

    public function delete_riwayat_pendidikan($id) {
        return $this->db->delete('sdm_pendidikan', ['id_pendidikan' => $id]);
    }
    public function create_sdm_alamat_kontak($data) {
        return $this->db->insert('sdm_alamat_kontak', $data);
    }
    public function generate_nrk_sanggar($nik, $id_sanggar) {
        $tahun = date('y');
        $kategori = '02'; // Kode untuk sanggar
        $kode_lokasi = substr($nik, 4, 2);
        $nomor_urut = str_pad($id_sanggar, 4, '0', STR_PAD_LEFT);
        $nrk = $tahun . $kategori . $kode_lokasi . $nomor_urut;
        return $nrk;
    }
    public function generate_nrk_perorangan($nik, $id_sdm) {
        $tahun = date('y');
        $kategori = '01'; // Kode untuk perorangan
        $kode_lokasi = substr($nik, 4, 2);
        $nomor_urut = str_pad($id_sdm, 4, '0', STR_PAD_LEFT);
        $nrk = $tahun . $kategori . $kode_lokasi . $nomor_urut;
        return $nrk;
    }

    public function get_pengurus_by_sdm_nik($nik) {
        $this->db->select('ps.*');
        $this->db->from('pengurus_sanggar ps');
        $this->db->join('sdm', 'sdm.id_sdm = ps.id_sdm');
        $this->db->where('sdm.nik', $nik);
        return $this->db->get()->row();
    }
    public function update_nrk_sanggar($id_sanggar, $nrk) {
    return $this->db->update('sanggar', ['nrk_sanggar' => $nrk], ['id_sanggar' => $id_sanggar]);
}
public function update_nrk_perorangan($id_sdm, $nrk) {
    return $this->db->update('sdm', ['nrk_perorangan' => $nrk], ['id_sdm' => $id_sdm]);
}
public function get_seni_sanggar($id_sanggar) {
    // Tambahkan js.id_seni ke dalam select
    $this->db->select('js.nama_seni, js.id_seni');
    $this->db->from('sanggar_seni ss');
    $this->db->join('jenis_seni js', 'js.id_seni = ss.id_seni');
    $this->db->where('ss.id_sanggar', $id_sanggar);
    $query = $this->db->get();
    return $query->result();
}
    public function update_sdm_nrk($id_sdm, $nrk) {
    // Memperbarui kolom 'nrk_perorangan' di tabel 'sdm'
    // WHERE klausa digunakan untuk memastikan hanya baris dengan 'id_sdm' yang sesuai yang diperbarui
    $this->db->set('nrk_perorangan', $nrk);
    $this->db->where('id_sdm', $id_sdm);
    return $this->db->update('sdm');
}
public function get_sanggar_by_pengurus_nik_lengkap($nik) {
    $this->db->select('s.*, sak.alamat, sak.no_hp, js.nama_seni');
    $this->db->from('sanggar s');
    $this->db->join('pengurus_sanggar ps', 'ps.id_sanggar = s.id_sanggar');
    $this->db->join('sdm', 'sdm.id_sdm = ps.id_sdm');
    $this->db->join('sanggar_alamat_kontak sak', 'sak.id_sanggar = s.id_sanggar', 'left');
    $this->db->join('jenis_seni js', 'js.id_seni = s.id_seni', 'left');
    $this->db->where('sdm.nik', $nik);
    $this->db->order_by('s.created_at', 'DESC');
    $this->db->limit(1);
    return $this->db->get()->row();
}



/**
 * Mengambil data SDM lengkap (dengan join) dari tabel 'sdm' berdasarkan NIK.
 */
public function get_sdm_by_nik_lengkap($nik) {
    $this->db->select('sdm.*, sak.*, js.nama_seni');
    $this->db->from('sdm');
    $this->db->join('sdm_alamat_kontak sak', 'sak.id_sdm = sdm.id_sdm', 'left');
    $this->db->join('jenis_seni js', 'js.id_seni = sdm.id_seni', 'left');
    $this->db->where('sdm.nik', $nik);
    // ❌ hapus filter ini:
    // $this->db->where('sdm.jenis_sdm', 'perorangan');
    $this->db->order_by('sdm.created_at', 'DESC');
    $this->db->limit(1);
    return $this->db->get()->row();
}


/**
 * Mengambil semua pengurus dari sebuah sanggar, dengan detail SDM dan peran.
 */
// Pendaftaran_model.php
public function get_pengurus_by_sanggar_lengkap($id_sanggar) {
    // Hapus 'js.nama_seni' dan 'sdm.id_seni' dari SELECT
    $this->db->select('ps.*, sdm.*, mp.nama_peran, sak.no_hp'); 
    $this->db->from('pengurus_sanggar ps');
    $this->db->join('sdm', 'sdm.id_sdm = ps.id_sdm');
    $this->db->join('sdm_alamat_kontak sak', 'sak.id_sdm = sdm.id_sdm', 'left');
    // Hapus join ke jenis_seni
    // $this->db->join('jenis_seni js', 'js.id_seni = sdm.id_seni', 'left');
    $this->db->join('master_peran mp', 'mp.id_peran = ps.id_peran', 'left');
    $this->db->where('ps.id_sanggar', $id_sanggar);
    return $this->db->get()->result();
}

public function get_sanggar_by_user($id_user) {
    // Memilih semua kolom dari tabel sanggar dengan alias 's'
    $this->db->select('s.*');
    
    // Tentukan tabel utama yang akan dicari
    $this->db->from('sanggar s');
    
    // Gabungkan dengan tabel pengurus_sanggar
    $this->db->join('pengurus_sanggar ps', 'ps.id_sanggar = s.id_sanggar');
    
    // Tambahkan kondisi WHERE untuk mencari ID pengguna
    $this->db->where('ps.id_user', $id_user);
    
    // Ambil hasil kueri
    $query = $this->db->get();

    // Mengembalikan satu baris hasil kueri sebagai objek
    return $query->row();
}


// Di dalam Pendaftaran_model.php
public function get_seni_by_sdm($id_sdm) {
    $this->db->select('sdm_seni.id, sdm_seni.deskripsi, jenis_seni.nama_seni');
    $this->db->from('sdm_seni');
    $this->db->join('jenis_seni', 'sdm_seni.id_seni = jenis_seni.id_seni', 'left');
    $this->db->where('sdm_seni.id_sdm', $id_sdm);
    $query = $this->db->get();
    return $query->result();
}


public function get_seni_by_sanggar($nik_pengurus) {
    $this->db->select('js.*');
    $this->db->from('sanggar s');
    $this->db->join('jenis_seni js', 'js.id_seni = s.id_seni', 'left');
    $this->db->join('pengurus_sanggar ps', 'ps.id_sanggar = s.id_sanggar');
    $this->db->join('sdm', 'sdm.id_sdm = ps.id_sdm');
    $this->db->where('sdm.nik', $nik_pengurus);
    $this->db->limit(1);
    return $this->db->get()->result();
}
public function get_sdm_by_user($id_user) {
    $this->db->select('sdm.*, sak.*, js.nama_seni');
    $this->db->from('users u');
    $this->db->join('sdm', 'sdm.nik = u.nik');
    $this->db->join('sdm_alamat_kontak sak', 'sak.id_sdm = sdm.id_sdm', 'left');
    $this->db->join('jenis_seni js', 'js.id_seni = sdm.id_seni', 'left');
    $this->db->where('u.id_user', $id_user);
    $this->db->order_by('sdm.created_at', 'DESC');
    $this->db->limit(1);
    return $this->db->get()->row();
}
public function get_sanggar_by_id($id_sanggar)
{
    $this->db->select('*');
    $this->db->from('sanggar');
    $this->db->where('id_sanggar', $id_sanggar);
    $query = $this->db->get();
    return $query->row();
}
public function tambah_seni_ke_sanggar($data)
{
    // Cek apakah data sudah ada untuk menghindari duplikasi
    $this->db->where('id_sanggar', $data['id_sanggar']);
    $this->db->where('id_seni', $data['id_seni']);
    $query = $this->db->get('sanggar_seni');

    if ($query->num_rows() == 0) {
        // Jika belum ada, simpan data ke tabel sanggar_seni
        $this->db->insert('sanggar_seni', $data);
        return true;
    }
    return false; // Mengembalikan false jika data sudah ada
}
// di Pendaftaran_model.php
public function get_seni_sanggar_ids($id_sanggar) {
    $this->db->select('id_seni');
    $this->db->where('id_sanggar', $id_sanggar);
    return $this->db->get('sanggar_seni')->result_array();
}

    // Pendaftaran_model.php

public function update_jenis_seni_single($id_sanggar, $id_seni_lama, $id_seni_baru) {
    $this->db->where('id_sanggar', $id_sanggar);
    $this->db->where('id_seni', $id_seni_lama);
    $this->db->set('id_seni', $id_seni_baru);
    return $this->db->update('sanggar_seni');
}
public function get_seni_by_id($id_seni) {
    // Memilih semua kolom dari tabel 'jenis_seni'
    $this->db->select('*');
    
    // Menambahkan kondisi WHERE untuk mencari data berdasarkan id_seni
    $this->db->where('id_seni', $id_seni);
    
    // Mengeksekusi kueri dan mengambil satu baris hasil
    $query = $this->db->get('jenis_seni');

    // Mengembalikan hasil kueri sebagai objek
    return $query->row();
}
public function hapus_seni_sanggar($id_sanggar, $id_seni) {
    // Menentukan kondisi WHERE untuk menghapus data
    // Kita membutuhkan id_sanggar DAN id_seni untuk memastikan hanya relasi yang spesifik yang terhapus
    $this->db->where('id_sanggar', $id_sanggar);
    $this->db->where('id_seni', $id_seni);

    // Menjalankan perintah DELETE pada tabel 'sanggar_seni'
    return $this->db->delete('sanggar_seni');
}
public function delete_anggota($id_anggota) {
        $this->db->where('id_anggota', $id_anggota);
        $this->db->delete('anggota_kelompok'); // Pastikan 'anggota_kelompok' adalah nama tabel yang benar

        // Periksa apakah operasi delete berhasil
        if ($this->db->affected_rows() > 0) {
            return TRUE;
        }
        return FALSE;
    }
    public function get_pendaftar_by_nik_unique($nik)
{
    return $this->db->select('sdm.id_sdm, sdm.nama_lengkap, sak.alamat, sak.no_hp')
                    ->from('sdm')
                    ->join('sdm_alamat_kontak sak', 'sak.id_sdm = sdm.id_sdm', 'left')
                    ->where('sdm.nik', $nik)
                    ->get()
                    ->row();
}
public function create_sanggar_seni($data_batch) {
        if (!empty($data_batch)) {
            $this->db->insert_batch('sanggar_seni', $data_batch);
        }
    }
    public function get_pendaftar_by_id($id)
    {
        return $this->db->where('id_sdm', $id)
                        ->get('sdm')
                        ->row();
    }
    public function update_pendaftar($id, $data) {
        $this->db->where('id_sdm', $id);
        return $this->db->update('sdm', $data);
    }
    public function save_sdm_seni($data) {
    return $this->db->insert('sdm_seni', $data);
}
public function get_jenis_seni_by_sdm_id($id_sdm) {
    $this->db->select('jenis_seni.nama_seni'); // Use the correct table name
    $this->db->from('sdm_seni');
    $this->db->join('jenis_seni', 'sdm_seni.id_seni = jenis_seni.id_seni'); // Use the correct table name
    $this->db->where('sdm_seni.id_sdm', $id_sdm);
    $query = $this->db->get();
    return $query->result();
}
public function save_sanggar_seni($data) {
    return $this->db->insert('sanggar_seni', $data);
}

}