<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use Dompdf\Dompdf;

class Pdf {
    public function __construct() {
        require_once APPPATH.'third_party/dompdf/autoload.inc.php'; // kalau pakai composer bisa hapus baris ini
    }

    public function createPDF($html, $filename = '', $stream = true, $paper = 'A4', $orientation = 'portrait') {
        $dompdf = new Dompdf();
        $dompdf->loadHtml($html);
        $dompdf->setPaper($paper, $orientation);
        $dompdf->render();

        if ($stream) {
            $dompdf->stream($filename.".pdf", array("Attachment" => 1));
        } else {
            return $dompdf->output();
        }
    }
}