<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Auth extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('User_model');
        $this->load->library('session');
        $this->load->library('form_validation');
    }

    // ========================= HALAMAN PILIH LOGIN =========================
    public function index() {
        $this->load->view('auth/index'); // view pilihan login
    }

    // ========================= LOGIN ADMIN =========================
    public function login_admin() {
        if ($this->input->post()) {
            $email    = $this->input->post('email');
            $password = $this->input->post('password');

            $user = $this->User_model->login_by_email($email, $password);

            if ($user && $user->id_role == 1) {
                $this->session->set_userdata([
                    'id_user'   => $user->id_user,
                    'nama'      => $user->nama_lengkap,
                    'email'     => $user->email,
                    'id_role'   => $user->id_role,
                    'logged_in' => TRUE
                ]);
                redirect('admin/dashboard');
            } else {
                $this->session->set_flashdata('error', 'Email atau password salah / bukan admin.');
                redirect('auth/login_admin');
            }
        }

        $this->load->view('auth/login_admin');
    }

        // ========================= REGISTER ADMIN =========================
    public function register_admin() {
        if ($this->input->post()) {
            $this->form_validation->set_rules('email', 'Email', 'required|valid_email|is_unique[users.email]');
            $this->form_validation->set_rules('nama_lengkap', 'Nama Lengkap', 'required');
            $this->form_validation->set_rules('password', 'Password', 'required|min_length[6]');

            if ($this->form_validation->run() == FALSE) {
                $this->session->set_flashdata('error', validation_errors());
                redirect('auth/register_admin');
                return;
            }

            $data = [
                'nik'          => null,
                'email'        => $this->input->post('email'),
                'nama_lengkap' => $this->input->post('nama_lengkap'),
                'password'     => password_hash($this->input->post('password'), PASSWORD_BCRYPT),
                'id_role'      => 1 // role admin
            ];

            $this->User_model->register($data);

            $this->session->set_flashdata('success', 'Registrasi Admin berhasil. Silakan login.');
            redirect('auth/login_admin');
        }

        $this->load->view('auth/register_admin');
    }


    // ========================= LOGIN PERORANGAN =========================
    public function login_perorangan() {
        if ($this->input->post()) {
            $this->form_validation->set_rules('nik', 'NIK', 'required|numeric|exact_length[16]');
            $this->form_validation->set_rules('password', 'Password', 'required');

            if ($this->form_validation->run() == FALSE) {
                $this->session->set_flashdata('error', validation_errors());
                redirect('auth/login_perorangan');
                return;
            }

            $nik = $this->input->post('nik');
            $password = $this->input->post('password');

            $user = $this->db->get_where('users', ['nik' => $nik, 'id_role' => 2])->row();

            if ($user && password_verify($password, $user->password)) {
                $this->session->set_userdata([
                    'id_user'   => $user->id_user,
                    'nama'      => $user->nama_lengkap,
                    'nik'       => $user->nik,
                    'id_role'   => $user->id_role,
                    'logged_in' => TRUE
                ]);
                redirect('pendaftaran/dashboard');
            } else {
                $this->session->set_flashdata('error', 'NIK atau Password salah.');
                redirect('auth/login_perorangan');
            }
        }

        $this->load->view('auth/login_perorangan');
    }

    // ========================= REGISTER PERORANGAN =========================
    public function register_perorangan() {
        if ($this->input->post()) {
            $this->form_validation->set_rules('nik', 'NIK', 'required|numeric|exact_length[16]');
            $this->form_validation->set_rules('nama_lengkap', 'Nama Lengkap', 'required');
            $this->form_validation->set_rules('password', 'Password', 'required|min_length[6]');

            if ($this->form_validation->run() == FALSE) {
                $this->session->set_flashdata('error', validation_errors());
                redirect('auth/register_perorangan');
                return;
            }

            $nik = $this->input->post('nik');
            $cek = $this->db->get_where('users', ['nik' => $nik])->row();
            if ($cek) {
                $this->session->set_flashdata('error', 'NIK sudah terdaftar.');
                redirect('auth/register_perorangan');
                return;
            }

            $data = [
                'nik'          => $nik,
                'email'        => null,
                'nama_lengkap' => $this->input->post('nama_lengkap'),
                'password'     => password_hash($this->input->post('password'), PASSWORD_BCRYPT),
                'id_role'      => 2
            ];
            $this->User_model->register($data);

            $this->session->set_flashdata('success', 'Registrasi berhasil, silakan login.');
            redirect('auth/login_perorangan');
        }

        $this->load->view('auth/register_perorangan');
    }

   // ========================= LOGIN KELOMPOK (EMAIL + PASSWORD) =========================
public function login_kelompok() {
    if ($this->input->post()) {
        $email    = $this->input->post('email');
        $password = $this->input->post('password');

        $user = $this->db->get_where('users', ['email' => $email, 'id_role' => 3])->row();

        if ($user && password_verify($password, $user->password)) {
            $this->session->set_userdata([
                'id_user'   => $user->id_user,
                'nama'      => $user->nama_lengkap,
                'email'     => $user->email,
                'id_role'   => $user->id_role,
                'logged_in' => TRUE
            ]);
            redirect('pendaftaran/dashboard');
        } else {
            $this->session->set_flashdata('error', 'Email atau Password salah.');
            redirect('auth/login_kelompok');
        }
    }

    $this->load->view('auth/login_kelompok');
}

// ========================= REGISTER KELOMPOK (CEK NRK DI SDM) =========================
public function register_kelompok() {
    if ($this->input->post()) {
        $email        = $this->input->post('email');
        $nama_sanggar = $this->input->post('nama_sanggar');
        $nrk          = $this->input->post('nrk'); 
        $password     = $this->input->post('password'); // password kelompok beneran

        // Cek apakah NRK ada di tabel sdm
        $cek_nrk = $this->db->get_where('sdm', ['nrk_perorangan' => $nrk])->row();
        if (!$cek_nrk) {
            $this->session->set_flashdata('error', 'NRK tidak valid. Silakan daftar perorangan dulu.');
            redirect('auth/register_kelompok');
            return;
        }

        // Cek email unik
        $cek_email = $this->db->get_where('users', ['email' => $email])->row();
        if ($cek_email) {
            $this->session->set_flashdata('error', 'Email sudah terdaftar.');
            redirect('auth/register_kelompok');
            return;
        }

        // Simpan data kelompok
        $data_user = [
            'nik'          => null,
            'email'        => $email,
            'nama_lengkap' => $nama_sanggar,
            'password'     => password_hash($password, PASSWORD_BCRYPT),
            'id_role'      => 3
        ];
        $this->User_model->register($data_user);

        $this->session->set_flashdata('success', 'Registrasi berhasil. Silakan login dengan email & password.');
        redirect('auth/login_kelompok');
    }

    $this->load->view('auth/register_kelompok');
}




    // ========================= LOGOUT =========================
    public function logout() {
        $this->session->sess_destroy();
        redirect('auth');
    }
}